package com.clarkware.junitperf;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * The <code>ExampleTimedTest</code> demonstrates how to decorate a 
 * <code>Test</code> as a <code>TimedTest</code>.
 *
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 *
 * @see com.clarkware.junitperf.TimedTest
 */

public class ExampleTimedTest {

	public static final long toleranceInMillis = 100;

	public static Test suite() {
		
		long maxElapsedTimeInMillis = 1000 + toleranceInMillis;

		Test testCase = new ExampleTestCase("testOneSecondResponse");
		Test timedTest = new TimedTest(testCase, maxElapsedTimeInMillis);

		TestSuite suite = new TestSuite();
		suite.addTest(timedTest);

		return suite;
	}

	public static void main(String args[]) {
		junit.textui.TestRunner.run(suite());
	}
}
