/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import java.util.Hashtable;
import org.apache.xalan.stree.CDATASectionImpl;
import org.apache.xalan.stree.CommentImpl;
import org.apache.xalan.stree.DocImpl;
import org.apache.xalan.stree.DocumentFragmentImpl;
import org.apache.xalan.stree.DocumentTypeImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.ElementImplWithNS;
import org.apache.xalan.stree.ProcessingInstructionImpl;
import org.apache.xalan.stree.SourceTreeHandler;
import org.apache.xalan.stree.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentImpl
extends DocImpl {
    DocumentTypeImpl m_docType;
    ElementImpl m_docElement;
    Hashtable m_idAttributes = new Hashtable();

    DocumentImpl() {
        this.setDoc(this);
    }

    public DocumentImpl(int n) {
        super(n);
        this.setDoc(this);
    }

    DocumentImpl(SourceTreeHandler sourceTreeHandler) {
        this.setDoc(this);
        this.m_sourceTreeHandler = sourceTreeHandler;
    }

    DocumentImpl(DocumentType documentType) {
        this.setDoc(this);
        if (documentType != null) {
            this.m_docType = (DocumentTypeImpl)documentType;
        }
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.getNodeType() != 11) {
            short s = node.getNodeType();
            if (s == 1) {
                if (this.m_docElement != null) {
                    throw new DOMException(3, "DOM006 Hierarchy request error");
                }
                this.m_docElement = (ElementImpl)node;
            } else if (s == 10) {
                this.m_docType = (DocumentTypeImpl)node;
            }
        }
        return super.appendChild(node);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return super.createAttributeNS(string, string2);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl();
    }

    public Element createElement(String string) throws DOMException {
        return new ElementImpl(this, string);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        return new ElementImplWithNS(this, string, string2);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public DocumentType getDoctype() {
        return this.m_docType;
    }

    public Element getDocumentElement() {
        return this.m_docElement;
    }

    public Element getElementById(String string) {
        Element element = (Element)this.m_idAttributes.get(string);
        if (element == null && !this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                        element = (Element)this.m_idAttributes.get(string);
                        if (element == null) continue;
                        Element element2 = element;
                        Object var5_5 = null;
                        return element2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
            element = (Element)this.m_idAttributes.get(string);
        }
        return element;
    }

    public Hashtable getIDAttributes() {
        return this.m_idAttributes;
    }

    public String getLocalName() {
        return "#document";
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return super.importNode(node, bl);
    }

    public void setDoctype(DocumentType documentType) {
        this.m_docType = (DocumentTypeImpl)documentType;
    }

    public void setIDAttribute(String string, Element element) {
        this.m_idAttributes.put(string, element);
    }
}

