/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.HashTablePool;
import org.enhydra.instantdb.db.SqlSyntax;
import org.enhydra.instantdb.db.StringHashTable;
import org.enhydra.instantdb.db.matchedTokens;
import org.enhydra.instantdb.db.tokenList;
import org.enhydra.instantdb.db.utils;

class sqltoken {
    static final int LITERAL = 1;
    static final int VALUE = 2;
    static final int SUBEXPR = 3;
    static final int ALTERNATIVES = 4;
    int type;
    int subType;
    boolean repeat;
    boolean comma_repeat;
    boolean optional;
    boolean forwardReference;
    String value;
    String name;
    Vector tokens;
    static StringHashTable syntaxList;
    static Hashtable reservedWords;
    static int resCount;
    static StringBuffer indent;
    static String nothing;
    boolean dumped = false;

    static {
        nothing = "";
    }

    sqltoken(int n, tokenList tokenList2, String string, String string2) throws SQLException {
        if (string2 != null) {
            this.name = string2;
        }
        this.setupToken(n, tokenList2, string);
    }

    sqltoken(String string) {
        this.name = string;
        this.type = 1;
    }

    sqltoken(Database database) throws SQLException {
        this.type = 3;
        this.optional = false;
        this.comma_repeat = false;
        this.repeat = false;
        indent = new StringBuffer("");
        this.tokens = new Vector(1, 1);
        syntaxList = new StringHashTable(80);
        reservedWords = new Hashtable(350, 0.5f);
        resCount = 0;
        new sqltoken(1, null, ",", null);
    }

    void addReservedWord(String string, sqltoken sqltoken2) {
        if (this.isReservedWord(string)) {
            return;
        }
        reservedWords.put(string.toUpperCase(), sqltoken2);
    }

    boolean isReservedWord(String string) {
        String string2 = string.toUpperCase();
        return reservedWords.get(string2) != null;
    }

    boolean matches(tokenList tokenList2, StringHashTable stringHashTable, matchedTokens matchedTokens2, HashTablePool hashTablePool) {
        Vector<StringHashTable> vector = null;
        StringHashTable stringHashTable2 = stringHashTable;
        StringHashTable stringHashTable3 = null;
        String string = this.name;
        if (this.repeat) {
            if (string == null) {
                string = this.value;
            }
            vector = new Vector<StringHashTable>(10, 5);
            stringHashTable.put(string, vector);
        } else if (string != null) {
            stringHashTable2 = hashTablePool.getHashTable();
            stringHashTable.put(string, stringHashTable2);
        }
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        do {
            int n2;
            if (this.repeat) {
                stringHashTable2 = hashTablePool.getHashTable();
                vector.addElement(stringHashTable2);
            }
            n = tokenList2.mark();
            int n3 = tokenList2.getType();
            String string2 = tokenList2.getNext();
            bl2 = false;
            if (string2 == null) break;
            block0 : switch (this.type) {
                case 1: {
                    if (string2.equalsIgnoreCase(this.value)) {
                        bl2 = true;
                        stringHashTable2.put(this.value, nothing);
                        break;
                    }
                    matchedTokens2.syntaxError(this.value, string2, false);
                    break;
                }
                case 2: {
                    if (!(this.isReservedWord(string2) && n3 != 5 || this.subType != n3 && this.subType != 2)) {
                        stringHashTable2.put(this.value, string2);
                        bl2 = true;
                        break;
                    }
                    matchedTokens2.syntaxError(this.value, string2, this.isReservedWord(string2));
                    break;
                }
                case 4: {
                    sqltoken sqltoken2;
                    stringHashTable3 = hashTablePool.getHashTable();
                    n2 = 0;
                    while (n2 < this.tokens.size()) {
                        tokenList2.reset(n);
                        sqltoken2 = (sqltoken)this.tokens.elementAt(n2);
                        if (sqltoken2.matches(tokenList2, stringHashTable3, matchedTokens2, hashTablePool)) {
                            bl2 = true;
                            break block0;
                        }
                        stringHashTable3.clear();
                        ++n2;
                    }
                    break;
                }
                default: {
                    sqltoken sqltoken2;
                    tokenList2.reset(n);
                    bl2 = true;
                    stringHashTable3 = hashTablePool.getHashTable();
                    n2 = 0;
                    while (n2 < this.tokens.size()) {
                        sqltoken2 = (sqltoken)this.tokens.elementAt(n2);
                        if (!sqltoken2.matches(tokenList2, stringHashTable3, matchedTokens2, hashTablePool)) {
                            bl2 = false;
                            break block0;
                        }
                        ++n2;
                    }
                    break block0;
                }
            }
            if (stringHashTable3 != null && bl2) {
                n2 = 0;
                while (n2 < stringHashTable3.count) {
                    stringHashTable2.put(stringHashTable3.keys[n2], stringHashTable3.values[n2]);
                    ++n2;
                }
            }
            if (this.comma_repeat) {
                string2 = tokenList2.getNext();
                if (string2 == null) break;
                if (!string2.equals(",")) {
                    tokenList2.putBack(1);
                    break;
                }
            }
            if (!bl2) continue;
            bl = true;
        } while (this.repeat && bl2);
        if (!bl2) {
            tokenList2.reset(n);
            if (bl) {
                bl2 = true;
            }
        }
        if (!bl2 && string != null) {
            stringHashTable.remove(string);
        }
        if (this.optional) {
            bl2 = true;
        }
        return bl2;
    }

    void removeRedundantExpression(sqltoken sqltoken2) {
        if (sqltoken2.tokens.size() == 1) {
            sqltoken sqltoken3 = (sqltoken)sqltoken2.tokens.elementAt(0);
            if (sqltoken3.forwardReference) {
                return;
            }
            sqltoken2.type = sqltoken3.type;
            sqltoken2.subType = sqltoken3.subType;
            if (sqltoken3.repeat) {
                sqltoken2.repeat = true;
            }
            if (sqltoken3.comma_repeat) {
                sqltoken2.comma_repeat = true;
            }
            if (sqltoken3.optional) {
                sqltoken2.optional = true;
            }
            sqltoken2.value = sqltoken3.value;
            sqltoken2.name = sqltoken3.name;
            sqltoken2.tokens = sqltoken3.tokens;
        }
    }

    void removeReservedWord(String string) {
        reservedWords.remove(string.toUpperCase());
    }

    void setRepeat(boolean bl, boolean bl2) {
        this.repeat = bl;
        if (bl2) {
            this.comma_repeat = true;
        }
    }

    synchronized void setupSyntax() throws IOException, SQLException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = SqlSyntax.getNextLine()) != null) {
            stringBuffer = stringBuffer.append(string);
            if (!string.endsWith(";")) continue;
            tokenList tokenList2 = new tokenList(stringBuffer.toString(), false);
            String string2 = tokenList2.getNext();
            String string3 = tokenList2.getNext();
            if (!string3.equals("=")) {
                throw new SQLException("Expected '=' in SQL syntax, found: " + string3, "XOPEN?");
            }
            sqltoken sqltoken2 = (sqltoken)syntaxList.get(string2);
            if (sqltoken2 == null) {
                sqltoken2 = new sqltoken(3, tokenList2, ";", string2);
                syntaxList.put(string2, sqltoken2);
            } else {
                sqltoken2.setupToken(3, tokenList2, ";");
            }
            stringBuffer.setLength(0);
        }
        this.tokens.addElement((sqltoken)syntaxList.get("statement"));
    }

    void setupToken(int n, tokenList tokenList2, String string) throws SQLException {
        sqltoken sqltoken2 = null;
        boolean bl = false;
        this.type = n;
        if (this.type == 1) {
            this.value = string;
            this.addReservedWord(this.value, this);
            return;
        }
        if (this.type == 2) {
            this.value = tokenList2.getNext();
            this.subType = 2;
            if (this.value.equals("#")) {
                this.value = tokenList2.getNext();
                this.subType = 1;
            } else if (this.value.equals("$")) {
                this.value = tokenList2.getNext();
                this.subType = 5;
            }
            String string2 = tokenList2.getNext();
            if (!string2.equals(">")) {
                throw new SQLException("Expected '>' in SQL syntax, found: " + string2, "XOPEN?");
            }
            return;
        }
        if (string.equals("]")) {
            this.optional = true;
        }
        int n2 = tokenList2.mark();
        this.tokens = new Vector(1, 2);
        while (true) {
            String string3;
            if (string.lastIndexOf(string3 = tokenList2.getNext()) > -1) {
                if (string.lastIndexOf("|") > -1 && !string3.equals("|")) {
                    tokenList2.putBack(1);
                }
                return;
            }
            if (this.type == 4) {
                tokenList2.putBack(1);
                sqltoken2 = new sqltoken(3, tokenList2, String.valueOf(string) + "|", null);
                this.removeRedundantExpression(sqltoken2);
                this.tokens.addElement(sqltoken2);
                continue;
            }
            if (string3.equals("[") && !bl) {
                sqltoken2 = new sqltoken(3, tokenList2, "]", null);
                this.removeRedundantExpression(sqltoken2);
                this.tokens.addElement(sqltoken2);
                continue;
            }
            if (string3.equals("{") && !bl) {
                sqltoken2 = new sqltoken(3, tokenList2, "}", null);
                this.removeRedundantExpression(sqltoken2);
                this.tokens.addElement(sqltoken2);
                continue;
            }
            if (string3.equals("|") && !bl) {
                if (this.type == 4) continue;
                this.tokens.removeAllElements();
                tokenList2.reset(n2);
                this.type = 4;
                this.comma_repeat = false;
                this.repeat = false;
                continue;
            }
            if (string3.equals("<") && !bl) {
                sqltoken2 = new sqltoken(2, tokenList2, null, null);
                this.tokens.addElement(sqltoken2);
                continue;
            }
            if (string3.equals(",...") && !bl) {
                sqltoken2.setRepeat(true, true);
                continue;
            }
            if (string3.equals("...") && !bl) {
                sqltoken2.setRepeat(true, false);
                continue;
            }
            if (string3.equals("\\") && !bl) {
                bl = true;
                continue;
            }
            if (utils.isUpperCase(string3)) {
                sqltoken2 = (sqltoken)reservedWords.get(string3);
                if (sqltoken2 == null) {
                    sqltoken2 = new sqltoken(1, tokenList2, string3, null);
                }
                this.tokens.addElement(sqltoken2);
                bl = false;
                continue;
            }
            sqltoken2 = (sqltoken)syntaxList.get(string3);
            if (sqltoken2 == null) {
                sqltoken2 = new sqltoken(string3);
                syntaxList.put(string3, sqltoken2);
                sqltoken2.forwardReference = true;
            }
            this.tokens.addElement(sqltoken2);
            bl = false;
        }
    }

    public String toString() {
        if (this.dumped) {
            return String.valueOf(indent.toString()) + this.name + "\n";
        }
        this.dumped = true;
        String string = indent.toString();
        if (this.optional) {
            string = String.valueOf(string) + "optional ";
        }
        if (this.repeat) {
            string = String.valueOf(string) + "repeat ";
        }
        if (this.comma_repeat) {
            string = String.valueOf(string) + "(comma) ";
        }
        if (this.type == 1) {
            string = String.valueOf(string) + "LITERAL: " + this.value + "\n";
        } else if (this.type == 2) {
            string = String.valueOf(string) + "VALUE:   " + this.value + "\n";
        } else {
            string = this.type == 4 ? String.valueOf(string) + "ALTERNATIVES:\n" : String.valueOf(string) + "EXPRESSION:\n";
            indent.append(" ");
            int n = 0;
            while (n < this.tokens.size()) {
                string = String.valueOf(string) + this.tokens.elementAt(n);
                ++n;
            }
            indent.setLength(indent.length() - 1);
        }
        this.dumped = false;
        return string;
    }
}

