/* 
 *   Creation Date: <2000/12/31 04:29:36 samuel>
 *   Time-stamp: <2000/12/31 04:36:02 samuel>
 *   
 *	<io.h>
 *	
 *	I/O related things
 *   
 *   Copyright (C) 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_IO
#define _H_IO

extern void 	ioports_init( void );
extern void 	ioports_cleanup( void );

extern void 	do_io_read( void *_ior, ulong mphys, int len, ulong *retvalue );
extern void 	do_io_write( void *_ior, ulong mphys, ulong data, int len );
/**************************************************************
*  little-endian conversions (from asm/io.h)
**************************************************************/

static unsigned ld_le16( const unsigned short *addr );
static void	st_le16( unsigned short *addr, unsigned short val );
static unsigned ld_le32( const ulong *addr );
static void 	st_le32( ulong *addr, ulong val );

/* little-endian conversions */
static __inline__ unsigned ld_le16( const unsigned short *addr) {
        unsigned val;
        __asm__ __volatile__("lhbrx %0,0,%1" : "=r" (val) : "r" (addr), "m" (*addr) );
        return val;
}
static __inline__ void st_le16( unsigned short *addr, unsigned short val) {
        __asm__ __volatile__("sthbrx %1,0,%2" : "=m" (*addr) : "r" (val), "r" (addr) );
}
static __inline__ unsigned ld_le32(const ulong *addr) {
        unsigned val;
        __asm__ __volatile__("lwbrx %0,0,%1" : "=r" (val) : "r" (addr), "m" (*addr) );
        return val;
}
static __inline__ void st_le32(ulong *addr, ulong val) {
        __asm__ __volatile__("stwbrx %1,0,%2" : "=m" (*addr) : "r" (val), "r" (addr) );
}

#endif   /* _H_IO */
