/* 
 *   Creation Date: <2001/02/24 14:08:28 samuel>
 *   Time-stamp: <2001/06/25 00:50:09 samuel>
 *   
 *	<platform.S>
 *	
 *	Linux Kernel Hooks
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

	
	////////////////////////////////////////////////////////
	// flush_hash_page_hook
	//
	// Kernel hook
	//
	//    r3:	context
	//    r4:	virtual address
	//    r5:	pointer to linux PTE (2.4.6 or later)
	//    r10:	return address
	//
	// [must not modify: r3-r5,r10 - otherwise normal C-function]
	// MMU is ON

.set STACK_SPACE,	32
.set STACK_LR,		STACK_SPACE+4
.set STACK_V0,		8
.set STACK_V1,		12
.set STACK_V2,		16
.set STACK_V3,		20
.set STACK_V4,		24

FHOOK( FHOOK_FLUSH_HASH_PAGE )
GLOBAL_SYMBOL( r__flush_hash_page_hook ):
	stwu	r1,-STACK_SPACE(r1)	// Push stackframe
	mflr	r0
	stw	r0,STACK_LR(r1)

	stw	r10,STACK_V1(r1)	// Save registers
	stw	r3,STACK_V2(r1)
	stw	r4,STACK_V3(r1)
	stw	r5,STACK_V4(r1)
		
	LI_VIRT( r7,do_flush )		
	mtctr	r7
	bctrl

	lwz	r10,STACK_V1(r1)	// Restore registers
	lwz	r3,STACK_V2(r1)
	lwz	r4,STACK_V3(r1)
	lwz	r5,STACK_V4(r1)

	lwz	r0,STACK_LR(r1)		// Pop stackframe
	addi	r1,r1,STACK_SPACE
	mtlr	r0
	blr
