/* 
 *   Creation Date: <2001/04/08 15:59:44 samuel>
 *   Time-stamp: <2001/08/04 20:18:09 samuel>
 *   
 *	<molcompat.c>
 *	
 *	Kernel module compatibility glue 
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "compat.h"

#ifndef LINUX_24
#define EXPORT_SYMTAB
#endif
#include <linux/config.h>
#include <linux/module.h>

#include <linux/stddef.h>
#include <linux/sys.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <asm/pgtable.h>
#include <asm/system.h>
#include <asm/mmu_context.h>

ulong	msym_handle_mm_fault = 0;
ulong	msym_flush_hash_page = 0;
ulong	msym_next_mmu_context = 0;

EXPORT_SYMBOL_NOVERS( msym_flush_hash_page );
EXPORT_SYMBOL_NOVERS( msym_handle_mm_fault );
EXPORT_SYMBOL_NOVERS( msym_next_mmu_context );

MODULE_PARM( msym_handle_mm_fault, "l" );
MODULE_PARM( msym_flush_hash_page, "l" );
MODULE_PARM( msym_next_mmu_context, "l" );

int
init_module( void )
{
	/* Userside extracted symbols (typically 2.2) */
	if( !msym_handle_mm_fault || !msym_next_mmu_context || !msym_flush_hash_page )
		return 1;
	return 0;
}

void
cleanup_module( void )
{
	/* dummy */
}


