/**************************************************************
*   
*   Creation Date: <97/06/06 20:01:18 samuel>
*   Time-stamp: <2001/09/22 14:32:12 samuel>
*   
*	<multiplexer.h>
*	
*	Module/task interface
*   
*   Copyright (C) 1997, 1999, 2000, 2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#ifndef _MULTIPLEXER_H
#define _MULTIPLEXER_H

#include <asm/unistd.h>		/* contains the syscall number */

#ifdef __KERNEL__
#ifndef __ASSEMBLY__
extern ulong sys_macos_multiplexer( int what, int sess_id, ulong arg1, ulong arg2, ulong arg3, ulong arg4 );
#endif
#endif

#ifndef __NR_multiplexer
#define __NR_multiplexer	201	/* syscall # */
#endif

#define	fBreakpointFlags	1	/* void ( ulong flags ) */
#define	fGetMregs 	 	2	/* void ( void )  */
#define fAddIORange		3	/* void ( ulong mbase, size_t size, io_ops_t *)*/
#define fRemoveIORange		4	/* void ( ulong mbase, size_t size ) */
#define fSprChanged		5	/* void ( void ) */
#define	fInit			6	/* int ( void ) */
#define fCleanup	       	7	/* void ( void ) */
#define fGetPVR			8	/* int ( void ) */
#define fSetMacRam		9	/* void ( ulong ram_start, ulong ram_end ) */
#define fPromGetNodeSize	10	/* size_t ( struct device_node *node ) */
#define fPromCopyNode		11	/* void ( struct device_node *dest, *src ) */
#define fGetPTE			12	/* int ( ulong vsid, ulong va, PTE *retpte ) */
#define fGetPhysicalAddr	13	/* int ( ulong lvptr, ulong *retptr ) */
#define fEmulateTLBIE		14	/* void ( ulong pageindex ) */
#define fEmulateTLBIA		15	/* void ( void ) */
#define fKernelMemmove		16	/* void ( char *dest, char *src, size_t len ) */
#define fGetKvarBase		19	/* char * ( void ) */
#define fGetMolModVersion	20	/* int ( void ) --- DON'T CHANGE THIS NUMBER (20) --- */
#define fAddMMUMapping		21	/* void ( struct mmu_mapping *m ) */
#define fRemoveMMUMapping	22	/* void ( struct mmu_mapping *m ) */
#define fMsrChanged		23	/* void ( void ) */
#define fTranslateIEa		24	/* int ( int context, ulong ea, PTE *retpte ) */
#define fTranslateDEa		25	/* int ( int context, ulong ea, PTE *retpte ) */
#define fSetupFBAccel		26	/* void * ( char *lvbase, int bytes_per_row, int height ) */
#define fGetDirtyFBLines	27	/* int ( short *rettable, int table_size_in_bytes ) */
#define fTrackDirtyRAM		29	/* int ( char *lvbase, size_t size ) */
#define fGetDirtyRAM		30	/* size_t ( char *retbuf ) */
#define fSetDirtyRAM		31	/* void ( char *dirtybuf ) */
#define fGetMregsPhys		32	/* ulong ( void ) */

#define fCallKernelFunc		33	/* --- special --- */

#define fGetPerformanceInfo	34	/* int ( int index, char *retbuf, int size, int *retval ) */
#define fGetKernelVersion	35	/* int ( void ) */
#define fGetTBFrequency		36	/* ulong ( void )*/

/* fInit error codes */
#define	errGeneralError		1
#define errSessionInUse		2
#define errSessionOutOfBounds	3



#endif
