/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.util;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.util.DeclarationVisitor;

class DeclarationScanner
implements DeclarationVisitor {
    protected DeclarationVisitor pre;
    protected DeclarationVisitor post;

    DeclarationScanner(DeclarationVisitor declarationVisitor, DeclarationVisitor declarationVisitor2) {
        this.pre = declarationVisitor;
        this.post = declarationVisitor2;
    }

    public void visitDeclaration(Declaration declaration) {
        declaration.accept(this.pre);
        declaration.accept(this.post);
    }

    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) {
        packageDeclaration.accept(this.pre);
        for (ClassDeclaration typeDeclaration : packageDeclaration.getClasses()) {
            typeDeclaration.accept(this);
        }
        for (InterfaceDeclaration interfaceDeclaration : packageDeclaration.getInterfaces()) {
            interfaceDeclaration.accept(this);
        }
        packageDeclaration.accept(this.post);
    }

    public void visitMemberDeclaration(MemberDeclaration memberDeclaration) {
        this.visitDeclaration(memberDeclaration);
    }

    public void visitTypeDeclaration(TypeDeclaration typeDeclaration) {
        typeDeclaration.accept(this.pre);
        for (TypeParameterDeclaration declaration : typeDeclaration.getFormalTypeParameters()) {
            declaration.accept(this);
        }
        for (FieldDeclaration fieldDeclaration : typeDeclaration.getFields()) {
            fieldDeclaration.accept(this);
        }
        for (MethodDeclaration methodDeclaration : typeDeclaration.getMethods()) {
            methodDeclaration.accept(this);
        }
        for (TypeDeclaration typeDeclaration2 : typeDeclaration.getNestedTypes()) {
            typeDeclaration2.accept(this);
        }
        typeDeclaration.accept(this.post);
    }

    public void visitClassDeclaration(ClassDeclaration classDeclaration) {
        classDeclaration.accept(this.pre);
        for (TypeParameterDeclaration declaration : classDeclaration.getFormalTypeParameters()) {
            declaration.accept(this);
        }
        for (FieldDeclaration fieldDeclaration : classDeclaration.getFields()) {
            fieldDeclaration.accept(this);
        }
        for (MethodDeclaration methodDeclaration : classDeclaration.getMethods()) {
            methodDeclaration.accept(this);
        }
        for (TypeDeclaration typeDeclaration : classDeclaration.getNestedTypes()) {
            typeDeclaration.accept(this);
        }
        for (ConstructorDeclaration constructorDeclaration : classDeclaration.getConstructors()) {
            constructorDeclaration.accept(this);
        }
        classDeclaration.accept(this.post);
    }

    public void visitEnumDeclaration(EnumDeclaration enumDeclaration) {
        this.visitClassDeclaration(enumDeclaration);
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration interfaceDeclaration) {
        this.visitTypeDeclaration(interfaceDeclaration);
    }

    public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration annotationTypeDeclaration) {
        this.visitInterfaceDeclaration(annotationTypeDeclaration);
    }

    public void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        this.visitMemberDeclaration(fieldDeclaration);
    }

    public void visitEnumConstantDeclaration(EnumConstantDeclaration enumConstantDeclaration) {
        this.visitFieldDeclaration(enumConstantDeclaration);
    }

    public void visitExecutableDeclaration(ExecutableDeclaration executableDeclaration) {
        executableDeclaration.accept(this.pre);
        for (TypeParameterDeclaration declaration : executableDeclaration.getFormalTypeParameters()) {
            declaration.accept(this);
        }
        for (ParameterDeclaration parameterDeclaration : executableDeclaration.getParameters()) {
            parameterDeclaration.accept(this);
        }
        executableDeclaration.accept(this.post);
    }

    public void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        this.visitExecutableDeclaration(constructorDeclaration);
    }

    public void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        this.visitExecutableDeclaration(methodDeclaration);
    }

    public void visitAnnotationTypeElementDeclaration(AnnotationTypeElementDeclaration annotationTypeElementDeclaration) {
        this.visitMethodDeclaration(annotationTypeElementDeclaration);
    }

    public void visitParameterDeclaration(ParameterDeclaration parameterDeclaration) {
        this.visitDeclaration(parameterDeclaration);
    }

    public void visitTypeParameterDeclaration(TypeParameterDeclaration typeParameterDeclaration) {
        this.visitDeclaration(typeParameterDeclaration);
    }
}

