/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class AnnotationTypeBuilder
extends AbstractBuilder {
    public static final String ROOT = "AnnotationTypeDoc";
    private AnnotationTypeDoc annotationTypeDoc;
    private AnnotationTypeWriter writer;

    private AnnotationTypeBuilder(Configuration configuration) {
        super(configuration);
    }

    public static AnnotationTypeBuilder getInstance(Configuration configuration, AnnotationTypeDoc annotationTypeDoc, AnnotationTypeWriter annotationTypeWriter) throws Exception {
        AnnotationTypeBuilder annotationTypeBuilder = new AnnotationTypeBuilder(configuration);
        annotationTypeBuilder.configuration = configuration;
        annotationTypeBuilder.annotationTypeDoc = annotationTypeDoc;
        annotationTypeBuilder.writer = annotationTypeWriter;
        if (containingPackagesSeen == null) {
            containingPackagesSeen = new HashSet();
        }
        return annotationTypeBuilder;
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public void build() throws IOException {
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    public String getName() {
        return ROOT;
    }

    public void buildAnnotationTypeDoc(List list) throws Exception {
        this.build(list);
        this.writer.close();
        this.copyDocFiles();
    }

    private void copyDocFiles() {
        PackageDoc packageDoc = this.annotationTypeDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, packageDoc) >= 0 || containingPackagesSeen.contains(packageDoc.name()))) {
            Util.copyDocFiles(this.configuration, Util.getPackageSourcePath(this.configuration, this.annotationTypeDoc.containingPackage()) + DirectoryManager.getDirectoryPath(this.annotationTypeDoc.containingPackage()) + File.separator, "doc-files", true);
            containingPackagesSeen.add(packageDoc.name());
        }
    }

    public void buildAnnotationTypeHeader() {
        this.writer.writeHeader(this.configuration.getText("doclet.AnnotationType") + " " + this.annotationTypeDoc.name());
    }

    public void buildDeprecationInfo() {
        this.writer.writeAnnotationTypeDeprecationInfo();
    }

    public void buildAnnotationTypeSignature() {
        StringBuffer stringBuffer = new StringBuffer(this.annotationTypeDoc.modifiers() + " ");
        this.writer.writeAnnotationTypeSignature(Util.replaceText(stringBuffer.toString(), "interface", "@interface"));
    }

    public void buildAnnotationTypeDescription() {
        this.writer.writeAnnotationTypeDescription();
    }

    public void buildAnnotationTypeTagInfo() {
        this.writer.writeAnnotationTypeTagInfo();
    }

    public void buildMemberSummary(List list) throws Exception {
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).build(list);
        this.writer.completeMemberSummaryBuild();
    }

    public void buildAnnotationTypeOptionalMemberDetails(List list) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeOptionalMemberBuilder(this.writer).build(list);
    }

    public void buildAnnotationTypeRequiredMemberDetails(List list) throws Exception {
        this.configuration.getBuilderFactory().getAnnotationTypeRequiredMemberBuilder(this.writer).build(list);
    }

    public void buildAnnotationTypeFooter() {
        this.writer.writeFooter();
    }
}

