/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.support;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.Codecs;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class RfcTest {
    protected static PrintStream out = System.out;
    protected static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    protected static Properties loadProperties(String file_name) {
        Properties props = new Properties();
        try {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file_name);
                props.load(fis);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fis.close();
                throw throwable;
            }
            fis.close();
            {
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (((Hashtable)props).containsKey("jco.client.passwd")) {
            String passwd = props.getProperty("jco.client.passwd");
            props.setProperty("jco.client.passwd", Codec.decode(passwd));
        }
        if (((Hashtable)props).containsKey("jco.client.ipasswd")) {
            String ipasswd = props.getProperty("jco.client.ipasswd");
            props.setProperty("jco.client.ipasswd", Codec.decode(ipasswd));
        }
        return props;
    }

    protected static void storeProperties(Properties props, String file_name, String description) {
        String passwd = null;
        String ipasswd = null;
        if (((Hashtable)props).containsKey("jco.client.passwd")) {
            passwd = props.getProperty("jco.client.passwd");
            props.setProperty("jco.client.passwd", Codec.encode(passwd));
        }
        if (((Hashtable)props).containsKey("jco.client.ipasswd")) {
            ipasswd = props.getProperty("jco.client.ipasswd");
            props.setProperty("jco.client.ipasswd", Codec.encode(ipasswd));
        }
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file_name);
                props.store(fos, description);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                fos.close();
                throw throwable;
            }
            fos.close();
            {
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (((Hashtable)props).containsKey("jco.client.passwd")) {
            props.setProperty("jco.client.passwd", passwd);
        }
        if (((Hashtable)props).containsKey("jco.client.ipasswd")) {
            props.setProperty("jco.client.ipasswd", ipasswd);
        }
    }

    protected static String ask(String question, String def_answer) {
        String answer;
        if (def_answer != null && def_answer.trim().length() > 0) {
            out.print(question + " [" + def_answer + "] :");
        } else {
            out.print(question + " :");
        }
        try {
            answer = in.readLine().trim();
        }
        catch (IOException ex) {
            answer = "";
        }
        if (answer.length() == 0) {
            return def_answer;
        }
        return answer;
    }

    protected static String askSecure(String question, String def_answer) {
        String answer;
        String maskedAnswer = "?";
        if (def_answer != null && def_answer.trim().length() > 0) {
            char[] maskedChars = new char[def_answer.trim().length()];
            Arrays.fill(maskedChars, '*');
            maskedAnswer = new String(maskedChars);
            out.print(question + " [" + maskedAnswer + "] :");
        } else {
            out.print(question + " :");
        }
        try {
            answer = in.readLine().trim();
        }
        catch (IOException ex) {
            answer = "";
        }
        if (answer.length() == 0) {
            return def_answer;
        }
        return answer;
    }

    protected static void displayProperties(Properties props) {
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.equals("jco.client.passwd")) {
                out.println("   " + key + " : " + props.getProperty(key));
                continue;
            }
            out.println("   " + key + " : " + "XXXXXX");
        }
    }

    protected static void displayException(Throwable ex) {
        if (ex instanceof JCO.Exception) {
            out.println("JCO.Exception occured:");
            out.println("   Group:" + ((JCO.Exception)ex).getGroup());
            out.println("   Key:" + ((JCO.Exception)ex).getKey());
            out.println("   Message:" + ((JCO.Exception)ex).getMessage());
        } else {
            out.println(ex.getClass().getName() + " occured:");
            out.println("   Message:" + ex.getMessage());
        }
    }

    protected static String stateToString(int state) {
        StringBuffer sb = new StringBuffer();
        if ((state & 1) != 0) {
            sb.append(" STOPPED ");
        }
        if ((state & 2) != 0) {
            sb.append(" STARTED ");
        }
        if ((state & 8) != 0) {
            sb.append(" LISTENING ");
        }
        if ((state & 0x20) != 0) {
            sb.append(" TRANSACTION ");
        }
        if ((state & 4) != 0) {
            sb.append(" BUSY ");
        }
        return sb.toString();
    }

    protected static class Codec {
        protected Codec() {
        }

        protected static String encode(String in) {
            if (in == null) {
                return "null";
            }
            try {
                byte[] bytes = in.getBytes("UTF8");
                char[] chars = Codecs.Base64.encode(bytes);
                return new String(chars);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }

        protected static String decode(String in) {
            if (in.equals("null")) {
                return null;
            }
            try {
                byte[] bytes = Codecs.Base64.decode(in);
                return new String(bytes, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
    }

    static class TidEntry {
        String TID;
        String state;
        private static final int tid_offset = 0;
        private static final int tid_length = 32;
        private static final int state_offset = 34;
        private static final int state_length = 25;

        TidEntry(String tid, String state) {
            this.TID = tid;
            this.state = state;
        }

        byte[] getBytes() {
            try {
                byte[] result = new byte[60];
                Arrays.fill(result, (byte)32);
                System.arraycopy(this.TID.getBytes("UTF8"), 0, result, 0, this.TID.length());
                System.arraycopy(this.state.getBytes("UTF8"), 0, result, 34, this.state.length());
                result[59] = 10;
                return result;
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        static TidEntry parse(byte[] line) {
            if (line[0] == 42) {
                return null;
            }
            TidEntry entry = new TidEntry(new String(line, 0, 32).trim(), new String(line, 34, 25).trim());
            if (entry.TID.length() > 0 && entry.state.length() > 0) {
                return entry;
            }
            return null;
        }
    }

    static class TidManager {
        private String fileName = null;
        private File file;
        public static final String CHECKED = "CHECKED";
        public static final String CONFIRMED = "CONFIRMED";
        public static final String COMMITED = "COMMITED";
        public static final String ROLLBACKED = "ROLLBACKED";
        public static final String CREATED = "CREATED";

        TidManager(String fileName) {
            this.fileName = fileName;
            this.file = new File(fileName);
            RandomAccessFile ras = null;
            try {
                if (!this.file.exists()) {
                    try {
                        ras = new RandomAccessFile(this.file, "rw");
                        ras.write("***   TID-MANAGEMENT FOR TRANSACTIONAL RFC (Server Program)   ***\n".getBytes("UTF8"));
                    }
                    catch (IOException ex) {
                        System.out.println("Error during file operation: " + ex.toString());
                    }
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (ras != null) {
                        ras.close();
                    }
                }
                catch (IOException ex) {
                    System.out.println("Error during file operation: " + ex.toString());
                }
                throw throwable;
            }
            try {
                if (ras != null) {
                    ras.close();
                }
            }
            catch (IOException ex) {
                System.out.println("Error during file operation: " + ex.toString());
            }
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        void update_TID(String tid, String tid_state) {
            block16: {
                RandomAccessFile ras;
                block15: {
                    int idx = 0;
                    byte[] line = new byte[60];
                    ras = null;
                    boolean eof = false;
                    boolean found = false;
                    ras = new RandomAccessFile(this.file, "rw");
                    long file_offset = ras.getFilePointer();
                    while (!eof) {
                        Arrays.fill(line, (byte)32);
                        idx = 0;
                        try {
                            byte b;
                            file_offset = ras.getFilePointer();
                            while ((b = ras.readByte()) != 10) {
                                void var8_11;
                                if (idx >= line.length) continue;
                                line[idx++] = var8_11;
                            }
                        }
                        catch (EOFException ex) {
                            eof = true;
                        }
                        TidEntry entry = TidEntry.parse(line);
                        if (entry == null || !entry.TID.equals(tid)) continue;
                        found = true;
                        entry.state = tid_state;
                        ras.seek(file_offset);
                        ras.write(new TidEntry(tid, tid_state).getBytes());
                    }
                    if (found) break block15;
                    ras.write(new TidEntry(tid, tid_state).getBytes());
                }
                Object var14_13 = null;
                try {
                    if (ras != null) {
                        ras.close();
                    }
                    break block16;
                }
                catch (IOException ex2) {
                    System.out.println("Error during file closing: " + ex2.toString());
                }
                break block16;
                {
                    catch (IOException ex) {
                        System.out.println("Error during file operation: " + ex.toString());
                        Object var14_14 = null;
                        try {
                            if (ras != null) {
                                ras.close();
                            }
                            break block16;
                        }
                        catch (IOException ex2) {
                            System.out.println("Error during file closing: " + ex2.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    try {
                        if (ras != null) {
                            ras.close();
                        }
                    }
                    catch (IOException ex2) {
                        System.out.println("Error during file closing: " + ex2.toString());
                    }
                    throw throwable;
                }
            }
        }
    }
}

