/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoIdentifiablePart;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class JGoPort
extends JGoDrawable
implements JGoIdentifiablePart {
    public static final int StyleHidden = 0;
    public static final int StyleObject = 1;
    public static final int StyleEllipse = 2;
    public static final int StyleTriangle = 3;
    public static final int StyleRectangle = 4;
    public static final int StyleDiamond = 5;
    public static final int ChangedStyle = 301;
    public static final int ChangedObject = 302;
    public static final int ChangedValidSource = 303;
    public static final int ChangedValidDestination = 304;
    public static final int ChangedFromSpot = 305;
    public static final int ChangedToSpot = 306;
    public static final int ChangedAddedLink = 307;
    public static final int ChangedRemovedLink = 308;
    public static final int ChangedEndSegmentLength = 309;
    public static final int ChangedValidSelfNode = 310;
    public static final int ChangedValidDuplicateLinks = 311;
    public static final int ChangedPartID = 312;
    static final int ChangedClearsLinksWhenRemoved = 313;
    private static final int flagValidLink = 32768;
    private static final int flagValidSource = 16384;
    private static final int flagValidDestination = 8192;
    private static final int flagValidSelfNode = 4096;
    private static final int flagValidDuplicateLinks = 65536;
    private static final int flagRecursive = 131072;
    private static final int flagClearsLinksWhenRemoved = 262144;
    private static final int flagNoClearLinks = 524288;
    private static double myDefaultPaintNothingScale = 0.15;
    private static double myDefaultPaintGreekScale = 0.25;
    private int myPartID = -1;
    private int myStyle = 2;
    private JGoObject myObject = null;
    private int myFromLinkSpot = 4;
    private int myToLinkSpot = 8;
    private JGoObjList myLinks = new JGoObjList();
    private int myEndSegmentLength = 10;

    public JGoPort() {
        this.init(2);
    }

    public JGoPort(Rectangle rect) {
        super(rect);
        this.init(2);
    }

    public JGoPort(Point location, Dimension size) {
        super(location, size);
        this.init(2);
    }

    public JGoPort(Rectangle rect, JGoObject object) {
        super(rect);
        this.init(1);
        if (object.getLayer() != null) {
            object.getLayer().removeObject(object.getTopLevelObject());
        } else if (object.getView() != null) {
            object.getView().removeObject(object.getTopLevelObject());
        }
        object.setSelectable(false);
        object.setDraggable(false);
        object.setResizable(false);
        this.myObject = object;
    }

    private final void init(int style) {
        this.myStyle = style;
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFFFB & 0xFFFFFFEF | 0x4000 | 0x2000 | 0x40000);
        this.setBrush(JGoBrush.black);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoPort newobj = (JGoPort)super.copyObject(env);
        if (newobj != null) {
            newobj.myPartID = this.myPartID;
            newobj.setInternalFlags(newobj.getInternalFlags() & 0xFFFF7FFF);
            newobj.myStyle = this.myStyle;
            newobj.myFromLinkSpot = this.myFromLinkSpot;
            newobj.myToLinkSpot = this.myToLinkSpot;
            newobj.myEndSegmentLength = this.myEndSegmentLength;
            newobj.myObject = this.myObject;
            if (this.myObject != null) {
                env.delay(this);
            }
        }
        return newobj;
    }

    public void copyObjectDelayed(JGoCopyEnvironment env, JGoObject newobj) {
        super.copyObjectDelayed(env, newobj);
        JGoPort newport = (JGoPort)newobj;
        JGoObject newportobj = (JGoObject)env.get(this.myObject);
        if (newportobj != null) {
            newport.myObject = newportobj;
        }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoPort = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoPort", jGoElementGroup);
            jGoPort.setAttribute("partid", Integer.toString(this.myPartID));
            jGoPort.setAttribute("portstyle", Integer.toString(this.myStyle));
            jGoPort.setAttribute("fromlinkspot", Integer.toString(this.myFromLinkSpot));
            jGoPort.setAttribute("tolinkspot", Integer.toString(this.myToLinkSpot));
            jGoPort.setAttribute("endsegmentlength", Integer.toString(this.myEndSegmentLength));
            if (this.myObject != null) {
                if (!svgDoc.isRegisteredReference(this.myObject)) {
                    jGoPort.setAttribute("embeddedportobject", "true");
                    DomElement subGroup = svgDoc.createElement("g");
                    jGoPort.appendChild(subGroup);
                    this.myObject.SVGWriteObject(svgDoc, subGroup);
                }
                svgDoc.registerReferencingNode(jGoPort, "portobject", this.myObject);
            }
        }
        if (svgDoc.SVGOutputEnabled()) {
            Rectangle r = this.getBoundingRect();
            int[] x = new int[4];
            int[] y = new int[4];
            switch (this.myStyle) {
                case 0: {
                    break;
                }
                case 3: {
                    switch (this.getToSpot()) {
                        case 1: {
                            x[0] = r.x + r.width / 2;
                            y[0] = r.y;
                            x[1] = r.x + r.width;
                            y[1] = r.y + r.height;
                            x[2] = r.x;
                            y[2] = r.y + r.height / 2;
                            break;
                        }
                        case 2: {
                            x[0] = r.x + r.width;
                            y[0] = r.y;
                            x[1] = r.x + r.width / 2;
                            y[1] = r.y + r.height;
                            x[2] = r.x;
                            y[2] = r.y;
                            break;
                        }
                        case 3: {
                            x[0] = r.x + r.width;
                            y[0] = r.y + r.height / 2;
                            x[1] = r.x;
                            y[1] = r.y + r.height;
                            x[2] = r.x + r.width / 2;
                            y[2] = r.y;
                            break;
                        }
                        case 4: {
                            x[0] = r.x + r.width;
                            y[0] = r.y + r.height;
                            x[1] = r.x;
                            y[1] = r.y + r.height / 2;
                            x[2] = r.x + r.width;
                            y[2] = r.y;
                            break;
                        }
                        case 5: {
                            x[0] = r.x + r.width / 2;
                            y[0] = r.y + r.height;
                            x[1] = r.x;
                            y[1] = r.y;
                            x[2] = r.x + r.width;
                            y[2] = r.y + r.height / 2;
                            break;
                        }
                        case 6: {
                            x[0] = r.x;
                            y[0] = r.y + r.height;
                            x[1] = r.x + r.width / 2;
                            y[1] = r.y;
                            x[2] = r.x + r.width;
                            y[2] = r.y + r.height;
                            break;
                        }
                        case 7: {
                            x[0] = r.x;
                            y[0] = r.y + r.height / 2;
                            x[1] = r.x + r.width;
                            y[1] = r.y;
                            x[2] = r.x + r.width / 2;
                            y[2] = r.y + r.height;
                            break;
                        }
                        default: {
                            x[0] = r.x;
                            y[0] = r.y;
                            x[1] = r.x + r.width;
                            y[1] = r.y + r.height / 2;
                            x[2] = r.x;
                            y[2] = r.y + r.height;
                        }
                    }
                    DomElement path = svgDoc.createElement("path");
                    String pathArgs = "M " + Integer.toString(x[0]) + " " + Integer.toString(y[0]);
                    pathArgs = pathArgs + " L " + Integer.toString(x[1]) + " " + Integer.toString(y[1]);
                    pathArgs = pathArgs + " L " + Integer.toString(x[2]) + " " + Integer.toString(y[2]);
                    pathArgs = pathArgs + " Z";
                    path.setAttribute("d", pathArgs);
                    this.SVGWriteAttributes(path);
                    jGoElementGroup.appendChild(path);
                    break;
                }
                case 4: {
                    DomElement rect = svgDoc.createElement("rect");
                    rect.setAttribute("x", Integer.toString(r.x));
                    rect.setAttribute("y", Integer.toString(r.y));
                    rect.setAttribute("width", Integer.toString(r.width));
                    rect.setAttribute("height", Integer.toString(r.height));
                    this.SVGWriteAttributes(rect);
                    jGoElementGroup.appendChild(rect);
                    break;
                }
                case 5: {
                    x[0] = r.x + r.width / 2;
                    y[0] = r.y;
                    x[1] = r.x + r.width;
                    y[1] = r.y + r.height / 2;
                    x[2] = x[0];
                    y[2] = r.y + r.height;
                    x[3] = r.x;
                    y[3] = y[1];
                    DomElement diamond = svgDoc.createElement("path");
                    String diamondArgs = "M " + Integer.toString(x[0]) + " " + Integer.toString(y[0]);
                    diamondArgs = diamondArgs + " L " + Integer.toString(x[1]) + " " + Integer.toString(y[1]);
                    diamondArgs = diamondArgs + " L " + Integer.toString(x[2]) + " " + Integer.toString(y[2]);
                    diamondArgs = diamondArgs + " L " + Integer.toString(x[3]) + " " + Integer.toString(y[3]);
                    diamondArgs = diamondArgs + " Z";
                    diamond.setAttribute("d", diamondArgs);
                    this.SVGWriteAttributes(diamond);
                    jGoElementGroup.appendChild(diamond);
                    break;
                }
                default: {
                    int cx = this.getTopLeft().x + this.getWidth() / 2;
                    int cy = this.getTopLeft().y + this.getHeight() / 2;
                    int rx = this.getWidth() / 2;
                    int ry = this.getHeight() / 2;
                    DomElement ellipse = svgDoc.createElement("ellipse");
                    ellipse.setAttribute("rx", Integer.toString(rx));
                    ellipse.setAttribute("ry", Integer.toString(ry));
                    ellipse.setAttribute("cx", Integer.toString(cx));
                    ellipse.setAttribute("cy", Integer.toString(cy));
                    this.SVGWriteAttributes(ellipse);
                    jGoElementGroup.appendChild(ellipse);
                }
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String endSegmentLength;
            String toLinkSpot;
            String style;
            String partid = jGoChildElement.getAttribute("partid");
            if (partid.length() > 0) {
                this.myPartID = Integer.parseInt(partid);
            }
            if ((style = jGoChildElement.getAttribute("portstyle")).length() > 0) {
                this.setStyle(Integer.parseInt(style));
            }
            if (jGoChildElement.getAttribute("embeddedportobject").equals("true")) {
                svgDoc.SVGTraverseChildren(jGoDoc, jGoChildElement, null, false);
            }
            String portObject = jGoChildElement.getAttribute("portobject");
            svgDoc.registerReferencingObject(this, "portobject", portObject);
            String fromLinkSpot = jGoChildElement.getAttribute("fromlinkspot");
            if (fromLinkSpot.length() > 0) {
                this.myFromLinkSpot = Integer.parseInt(fromLinkSpot);
            }
            if ((toLinkSpot = jGoChildElement.getAttribute("tolinkspot")).length() > 0) {
                this.myToLinkSpot = Integer.parseInt(toLinkSpot);
            }
            if ((endSegmentLength = jGoChildElement.getAttribute("endsegmentlength")).length() > 0) {
                this.myEndSegmentLength = Integer.parseInt(endSegmentLength);
            }
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            return svgElement.getNextSibling();
        }
        return svgElement.getNextSibling();
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("portobject")) {
            this.setPortObject((JGoObject)referencedObject);
        }
    }

    public void paint(Graphics2D g, JGoView view) {
        if (this.paintGreek(g, view)) {
            return;
        }
        Rectangle r = this.getBoundingRect();
        switch (this.getStyle()) {
            case 0: {
                return;
            }
            case 1: {
                JGoObject pobj = this.getPortObject();
                if (pobj == null || pobj.getLayer() != null || pobj.getView() != null) break;
                pobj.setBoundingRect(r);
                pobj.paint(g, view);
                break;
            }
            case 3: {
                int[] x = view.getTempXs(3);
                int[] y = view.getTempYs(3);
                switch (this.getToSpot()) {
                    case 1: {
                        x[0] = r.x + r.width / 2;
                        y[0] = r.y;
                        x[1] = r.x + r.width;
                        y[1] = r.y + r.height;
                        x[2] = r.x;
                        y[2] = r.y + r.height / 2;
                        break;
                    }
                    case 2: {
                        x[0] = r.x + r.width;
                        y[0] = r.y;
                        x[1] = r.x + r.width / 2;
                        y[1] = r.y + r.height;
                        x[2] = r.x;
                        y[2] = r.y;
                        break;
                    }
                    case 3: {
                        x[0] = r.x + r.width;
                        y[0] = r.y + r.height / 2;
                        x[1] = r.x;
                        y[1] = r.y + r.height;
                        x[2] = r.x + r.width / 2;
                        y[2] = r.y;
                        break;
                    }
                    case 4: {
                        x[0] = r.x + r.width;
                        y[0] = r.y + r.height;
                        x[1] = r.x;
                        y[1] = r.y + r.height / 2;
                        x[2] = r.x + r.width;
                        y[2] = r.y;
                        break;
                    }
                    case 5: {
                        x[0] = r.x + r.width / 2;
                        y[0] = r.y + r.height;
                        x[1] = r.x;
                        y[1] = r.y;
                        x[2] = r.x + r.width;
                        y[2] = r.y + r.height / 2;
                        break;
                    }
                    case 6: {
                        x[0] = r.x;
                        y[0] = r.y + r.height;
                        x[1] = r.x + r.width / 2;
                        y[1] = r.y;
                        x[2] = r.x + r.width;
                        y[2] = r.y + r.height;
                        break;
                    }
                    case 7: {
                        x[0] = r.x;
                        y[0] = r.y + r.height / 2;
                        x[1] = r.x + r.width;
                        y[1] = r.y;
                        x[2] = r.x + r.width / 2;
                        y[2] = r.y + r.height;
                        break;
                    }
                    default: {
                        x[0] = r.x;
                        y[0] = r.y;
                        x[1] = r.x + r.width;
                        y[1] = r.y + r.height / 2;
                        x[2] = r.x;
                        y[2] = r.y + r.height;
                    }
                }
                this.drawPolygon(g, x, y, 3);
                break;
            }
            case 4: {
                this.drawRect(g, r.x, r.y, r.width, r.height);
                break;
            }
            case 5: {
                int[] x = view.getTempXs(4);
                int[] y = view.getTempYs(4);
                x[0] = r.x + r.width / 2;
                y[0] = r.y;
                x[1] = r.x + r.width;
                y[1] = r.y + r.height / 2;
                x[2] = x[0];
                y[2] = r.y + r.height;
                x[3] = r.x;
                y[3] = y[1];
                this.drawPolygon(g, x, y, 4);
                break;
            }
            default: {
                this.drawEllipse(g, r.x, r.y, r.width, r.height);
            }
        }
    }

    public boolean paintGreek(Graphics2D g, JGoView view) {
        double scale = view.getScale();
        double nothing = JGoPort.getDefaultPaintNothingScale();
        double greek = JGoPort.getDefaultPaintGreekScale();
        if (view.isPrinting()) {
            nothing /= 3.0;
            greek /= 3.0;
        }
        if (scale <= nothing) {
            return true;
        }
        if (scale <= greek) {
            if (this.getStyle() != 0) {
                Rectangle rect = this.getBoundingRect();
                this.drawRect(g, rect.x, rect.y, rect.width, rect.height);
            }
            return true;
        }
        return false;
    }

    public void expandRectByPenWidth(Rectangle rect) {
        if (this.getStyle() == 0) {
            return;
        }
        JGoObject pobj = this.getPortObject();
        if (pobj != null && pobj != this && this.getStyle() == 1 && pobj.getLayer() == null && pobj.getView() == null && (this.getInternalFlags() & 0x20000) == 0) {
            this.setInternalFlags(this.getInternalFlags() | 0x20000);
            pobj.expandRectByPenWidth(rect);
            this.setInternalFlags(this.getInternalFlags() & 0xFFFDFFFF);
        } else {
            super.expandRectByPenWidth(rect);
        }
    }

    public boolean getNearestIntersectionPoint(int px, int py, int cx, int cy, Point result) {
        JGoObject portobj = this.getPortObject();
        if (portobj != null && portobj != this && this.getStyle() != 1 && (this.getInternalFlags() & 0x20000) == 0 && (portobj.getLayer() != null || portobj.getView() != null || JGoObject.findCommonParent(this, portobj) != null)) {
            this.setInternalFlags(this.getInternalFlags() | 0x20000);
            boolean found = portobj.getNearestIntersectionPoint(px, py, cx, cy, result);
            this.setInternalFlags(this.getInternalFlags() & 0xFFFDFFFF);
            return found;
        }
        return super.getNearestIntersectionPoint(px, py, cx, cy, result);
    }

    public int getPartID() {
        return this.myPartID;
    }

    public void setPartID(int id) {
        int old = this.myPartID;
        if (old != id) {
            this.myPartID = id;
            this.update(312, old, null);
        }
    }

    public int getStyle() {
        return this.myStyle;
    }

    public void setStyle(int s) {
        this.internalSetStyle(s, false);
    }

    private void internalSetStyle(int s, boolean undoing) {
        int oldStyle = this.myStyle;
        if (oldStyle != s) {
            this.myStyle = s;
            this.update(301, oldStyle, null);
            if (!undoing) {
                this.portChange(301, oldStyle, null);
            }
        }
    }

    public JGoObject getPortObject() {
        return this.myObject;
    }

    public void setPortObject(JGoObject obj) {
        this.internalSetPortObject(obj, false);
    }

    private void internalSetPortObject(JGoObject obj, boolean undoing) {
        JGoObject oldObj = this.myObject;
        if (oldObj != obj) {
            this.myObject = obj;
            this.update(302, 0, oldObj);
            if (!undoing) {
                this.portChange(302, 0, oldObj);
            }
        }
    }

    public int getNumLinks() {
        return this.myLinks.getNumObjects();
    }

    public int getNumFromLinks() {
        int count = 0;
        JGoListPosition pos = this.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = this.getLinkAtPos(pos);
            pos = this.getNextLinkPos(pos);
            if (link.getFromPort() != this || link.getToPort().getDocument() == null) continue;
            ++count;
        }
        return count;
    }

    public int getNumToLinks() {
        int count = 0;
        JGoListPosition pos = this.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = this.getLinkAtPos(pos);
            pos = this.getNextLinkPos(pos);
            if (link.getToPort() != this) continue;
            ++count;
        }
        return count;
    }

    public boolean hasNoLinks() {
        return this.myLinks.isEmpty();
    }

    public JGoListPosition getFirstLinkPos() {
        return this.myLinks.getFirstObjectPos();
    }

    public JGoLink getLinkAtPos(JGoListPosition pos) {
        return (JGoLink)this.myLinks.getObjectAtPos(pos);
    }

    public JGoListPosition getNextLinkPos(JGoListPosition pos) {
        return this.myLinks.getNextObjectPos(pos);
    }

    public void removeAllLinks() {
        this.clearLinks(null);
    }

    private void clearLinks(JGoObject mainObject) {
        ArrayList<JGoLink> linkarray = null;
        JGoListPosition pos = this.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = this.getLinkAtPos(pos);
            pos = this.getNextLinkPos(pos);
            if (mainObject != null && link.isChildOf(mainObject)) continue;
            if (linkarray == null) {
                linkarray = new ArrayList<JGoLink>();
            }
            linkarray.add(link);
        }
        if (linkarray != null) {
            for (int i = 0; i < linkarray.size(); ++i) {
                JGoLink link = (JGoLink)linkarray.get(i);
                link.unlink();
            }
        }
    }

    public Point getLinkPoint(int spot, Point result) {
        Rectangle rect = this.getBoundingRect();
        if (result == null) {
            result = new Point(0, 0);
        }
        int x1 = rect.x;
        int x2 = rect.x + rect.width / 2;
        int x3 = rect.x + rect.width;
        int y1 = rect.y;
        int y2 = rect.y + rect.height / 2;
        int y3 = rect.y + rect.height;
        switch (spot) {
            default: {
                result.x = x2;
                result.y = y2;
                break;
            }
            case 1: {
                result.x = x1;
                result.y = y1;
                break;
            }
            case 2: {
                result.x = x2;
                result.y = y1;
                break;
            }
            case 3: {
                result.x = x3;
                result.y = y1;
                break;
            }
            case 4: {
                result.x = x3;
                result.y = y2;
                break;
            }
            case 5: {
                result.x = x3;
                result.y = y3;
                break;
            }
            case 6: {
                result.x = x2;
                result.y = y3;
                break;
            }
            case 7: {
                result.x = x1;
                result.y = y3;
                break;
            }
            case 8: {
                result.x = x1;
                result.y = y2;
            }
        }
        return result;
    }

    public final Point getLinkPoint(int spot) {
        return this.getLinkPoint(spot, null);
    }

    public Point getLinkPointFromPoint(int x, int y, Point result) {
        JGoObject pobj;
        if (result == null) {
            result = new Point(0, 0);
        }
        if ((pobj = this.getPortObject()) == null || pobj.getLayer() == null && pobj.getView() == null && JGoObject.findCommonParent(this, pobj) == null) {
            pobj = this;
        }
        result.x = x;
        result.y = y;
        if (pobj.isPointInObj(result)) {
            Rectangle r = pobj.getBoundingRect();
            result.x = r.x + r.width / 2;
            result.y = r.y + r.height / 2;
            return result;
        }
        Rectangle r = this.getBoundingRect();
        if (this.getNearestIntersectionPoint(x, y, r.x + r.width / 2, r.y + r.height / 2, result)) {
            return result;
        }
        r = pobj.getBoundingRect();
        result.x = r.x + r.width / 2;
        result.y = r.y + r.height / 2;
        return result;
    }

    public Point getFromLinkPoint(JGoLink link, Point result) {
        if (this.getFromSpot() != -1) {
            return this.getLinkPoint(this.getFromSpot(), result);
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        if (link == null || link.getToPort() == null) {
            result.x = this.getLeft() + this.getWidth() / 2;
            result.y = this.getTop() + this.getHeight() / 2;
            return result;
        }
        if (link.getNumPoints() > (link.isOrthogonal() ? 6 : 2)) {
            Point p1 = link.getPoint(1);
            result.x = p1.x;
            result.y = p1.y;
            if (link.isOrthogonal()) {
                result = this.orthoPointToward(result);
            }
        } else {
            JGoPort to = link.getToPort();
            result.x = to.getLeft() + to.getWidth() / 2;
            result.y = to.getTop() + to.getHeight() / 2;
            if (link.isOrthogonal()) {
                result = this.orthoPointToward(result);
            }
        }
        return this.getLinkPointFromPoint(result.x, result.y, result);
    }

    private Point orthoPointToward(Point p) {
        int cx = this.getLeft() + this.getWidth() / 2;
        int cy = this.getTop() + this.getHeight() / 2;
        if (Math.abs(p.x - cx) >= Math.abs(p.y - cy)) {
            p.x = p.x >= cx ? (p.x += 99999) : (p.x -= 99999);
            p.y = cy;
        } else {
            p.y = p.y >= cy ? (p.y += 99999) : (p.y -= 99999);
            p.x = cx;
        }
        return p;
    }

    public final Point getFromLinkPoint(Point result) {
        return this.getLinkPoint(this.getFromSpot(), result);
    }

    public final Point getFromLinkPoint() {
        return this.getLinkPoint(this.getFromSpot(), null);
    }

    public Point getToLinkPoint(JGoLink link, Point result) {
        if (this.getToSpot() != -1) {
            return this.getLinkPoint(this.getToSpot(), result);
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        if (link == null || link.getFromPort() == null) {
            result.x = this.getLeft() + this.getWidth() / 2;
            result.y = this.getTop() + this.getHeight() / 2;
            return result;
        }
        if (link.getNumPoints() > (link.isOrthogonal() ? 6 : 2)) {
            Point p2 = link.getPoint(link.getNumPoints() - 2);
            result.x = p2.x;
            result.y = p2.y;
            if (link.isOrthogonal()) {
                result = this.orthoPointToward(result);
            }
        } else {
            JGoPort from = link.getFromPort();
            result.x = from.getLeft() + from.getWidth() / 2;
            result.y = from.getTop() + from.getHeight() / 2;
            if (link.isOrthogonal()) {
                result = this.orthoPointToward(result);
            }
        }
        return this.getLinkPointFromPoint(result.x, result.y, result);
    }

    public final Point getToLinkPoint(Point result) {
        return this.getToLinkPoint(null, result);
    }

    public final Point getToLinkPoint() {
        return this.getLinkPoint(this.getToSpot(), null);
    }

    public int getFromSpot() {
        return this.myFromLinkSpot;
    }

    public void setFromSpot(int spot) {
        this.internalSetFromSpot(spot, false);
    }

    private void internalSetFromSpot(int spot, boolean undoing) {
        int oldFromSpot = this.myFromLinkSpot;
        if (oldFromSpot != spot) {
            this.myFromLinkSpot = spot;
            this.update(305, oldFromSpot, null);
            if (!undoing) {
                this.portChange(305, oldFromSpot, null);
            }
        }
    }

    public int getToSpot() {
        return this.myToLinkSpot;
    }

    public void setToSpot(int spot) {
        this.internalSetToSpot(spot, false);
    }

    private void internalSetToSpot(int spot, boolean undoing) {
        int oldToSpot = this.myToLinkSpot;
        if (oldToSpot != spot) {
            this.myToLinkSpot = spot;
            this.update(306, oldToSpot, null);
            if (!undoing) {
                this.portChange(306, oldToSpot, null);
            }
        }
    }

    public double getLinkDir(int spot) {
        switch (spot) {
            default: {
                return -1.0;
            }
            case 1: {
                return 3.9269908169872414;
            }
            case 2: {
                return 4.71238898038469;
            }
            case 3: {
                return 5.497787143782138;
            }
            case 4: {
                return 0.0;
            }
            case 5: {
                return 0.7853981633974483;
            }
            case 6: {
                return 1.5707963267948966;
            }
            case 7: {
                return 2.356194490192345;
            }
            case 8: 
        }
        return Math.PI;
    }

    public double getFromLinkDir() {
        return this.getLinkDir(this.getFromSpot());
    }

    public double getToLinkDir() {
        return this.getLinkDir(this.getToSpot());
    }

    public double getFromLinkDir(JGoLink link) {
        int fromspot = this.getFromSpot();
        if (fromspot != -1 && fromspot != 0) {
            return this.getFromLinkDir();
        }
        if (link == null || link.getToPort() == null) {
            return 0.0;
        }
        JGoPort toport = link.getToPort();
        int px = toport.getLeft() + toport.getWidth() / 2;
        int py = toport.getTop() + toport.getHeight() / 2;
        int cx = this.getLeft() + this.getWidth() / 2;
        int cy = this.getTop() + this.getHeight() / 2;
        if (Math.abs(px - cx) > Math.abs(py - cy)) {
            if (px >= cx) {
                return 0.0;
            }
            return Math.PI;
        }
        if (py >= cy) {
            return 1.5707963267948966;
        }
        return 4.71238898038469;
    }

    public double getToLinkDir(JGoLink link) {
        int tospot = this.getToSpot();
        if (tospot != -1 && tospot != 0) {
            return this.getToLinkDir();
        }
        if (link == null || link.getFromPort() == null) {
            return 0.0;
        }
        JGoPort fromport = link.getFromPort();
        int px = fromport.getLeft() + fromport.getWidth() / 2;
        int py = fromport.getTop() + fromport.getHeight() / 2;
        int cx = this.getLeft() + this.getWidth() / 2;
        int cy = this.getTop() + this.getHeight() / 2;
        if (Math.abs(px - cx) > Math.abs(py - cy)) {
            if (px >= cx) {
                return 0.0;
            }
            return Math.PI;
        }
        if (py >= cy) {
            return 1.5707963267948966;
        }
        return 4.71238898038469;
    }

    public boolean validLink(JGoPort to) {
        return this.canLinkFrom() && to != null && to.canLinkTo() && (this.isValidSelfNode() && to.isValidSelfNode() || !this.isInSameNode(to)) && (this.isValidDuplicateLinks() && to.isValidDuplicateLinks() || !this.isLinked(to)) && this.cycleOK(to);
    }

    public boolean isValidLink() {
        return (this.getInternalFlags() & 0x8000) != 0;
    }

    private boolean cycleOK(JGoPort toPort) {
        JGoDocument doc = this.getDocument();
        if (doc == null) {
            return true;
        }
        int c = doc.getValidCycle();
        switch (c) {
            default: {
                return true;
            }
            case 1: {
                return !JGoDocument.makesDirectedCycle(this.getParentJGoNode(), toPort.getParentJGoNode());
            }
            case 2: {
                return !JGoDocument.makesDirectedCycleFast(this.getParentJGoNode(), toPort.getParentJGoNode());
            }
            case 3: {
                return !JGoDocument.makesUndirectedCycle(this.getParentJGoNode(), toPort.getParentJGoNode());
            }
            case 4: {
                return toPort.getNumToLinks() == 0 && !JGoDocument.makesDirectedCycleFast(this.getParentJGoNode(), toPort.getParentJGoNode());
            }
            case 5: 
        }
        return this.getNumFromLinks() == 0 && !JGoDocument.makesDirectedCycleFast(this.getParentJGoNode(), toPort.getParentJGoNode());
    }

    public boolean canLinkFrom() {
        if (!this.isValidSource()) {
            return false;
        }
        return this.canView();
    }

    public boolean canLinkTo() {
        if (!this.isValidDestination()) {
            return false;
        }
        return this.canView();
    }

    public boolean isValidSource() {
        return (this.getInternalFlags() & 0x4000) != 0;
    }

    public void setValidSource(boolean valid) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x4000) != 0;
        if (old != valid) {
            if (valid) {
                this.setInternalFlags(this.getInternalFlags() | 0x4000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFFBFFF);
            }
            this.update(303, old ? 1 : 0, null);
        }
    }

    public boolean isValidDestination() {
        return (this.getInternalFlags() & 0x2000) != 0;
    }

    public void setValidDestination(boolean valid) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x2000) != 0;
        if (old != valid) {
            if (valid) {
                this.setInternalFlags(this.getInternalFlags() | 0x2000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFFDFFF);
            }
            this.update(304, old ? 1 : 0, null);
        }
    }

    public boolean isValidSelfNode() {
        return (this.getInternalFlags() & 0x1000) != 0;
    }

    public void setValidSelfNode(boolean valid) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x1000) != 0;
        if (old != valid) {
            if (valid) {
                this.setInternalFlags(this.getInternalFlags() | 0x1000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFFEFFF);
            }
            this.update(310, old ? 1 : 0, null);
        }
    }

    public static boolean isInSameNode(JGoPort a, JGoPort b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        JGoObject an = a.getParentNode();
        JGoObject bn = b.getParentNode();
        return an != null && an == bn;
    }

    public boolean isInSameNode(JGoPort p) {
        return JGoPort.isInSameNode(this, p);
    }

    public boolean isValidDuplicateLinks() {
        return (this.getInternalFlags() & 0x10000) != 0;
    }

    public void setValidDuplicateLinks(boolean valid) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x10000) != 0;
        if (old != valid) {
            if (valid) {
                this.setInternalFlags(this.getInternalFlags() | 0x10000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFEFFFF);
            }
            this.update(311, old ? 1 : 0, null);
        }
    }

    public static boolean isLinked(JGoPort a, JGoPort b) {
        if (a == null || b == null) {
            return false;
        }
        JGoListPosition pos = a.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = a.getLinkAtPos(pos);
            pos = a.getNextLinkPos(pos);
            if (link.getFromPort() != a || link.getToPort() != b) continue;
            return true;
        }
        return false;
    }

    public boolean isLinked(JGoPort p) {
        return JGoPort.isLinked(this, p);
    }

    void setValidLink(boolean valid) {
        if (valid) {
            this.setInternalFlags(this.getInternalFlags() | 0x8000);
        } else {
            this.setInternalFlags(this.getInternalFlags() & 0xFFFF7FFF);
        }
    }

    void addLink(JGoLink link) {
        this.myLinks.addObjectAtTail(link);
        this.linkChange();
        this.update(307, 0, link);
    }

    void removeLink(JGoLink link) {
        JGoListPosition pos = this.myLinks.findObject(link);
        if (pos != null) {
            this.myLinks.removeObjectAtPos(pos);
            this.linkChange();
            this.update(308, 0, link);
        }
    }

    protected void geometryChange(Rectangle prevRect) {
        super.geometryChange(prevRect);
        this.portChange(1, 0, prevRect);
    }

    public void portChange(int hint, int prevInt, Object prevVal) {
        JGoListPosition pos = this.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = this.getLinkAtPos(pos);
            pos = this.getNextLinkPos(pos);
            link.portChange(this, hint, prevInt, prevVal);
        }
    }

    public void linkChange() {
    }

    protected void ownerChange(JGoObjectCollection oldOwner, JGoObjectCollection newOwner, JGoObject mainObject) {
        super.ownerChange(oldOwner, newOwner, mainObject);
        if (newOwner == null && this.isClearsLinksWhenRemoved() && !this.isNoClearLinks()) {
            this.clearLinks(mainObject);
        }
    }

    void setNoClearLinks(boolean bFlag) {
        int f = this.getInternalFlags();
        f = bFlag ? (f |= 0x80000) : (f &= 0xFFF7FFFF);
        this.setInternalFlags(f);
    }

    boolean isNoClearLinks() {
        return (this.getInternalFlags() & 0x80000) != 0;
    }

    boolean isClearsLinksWhenRemoved() {
        return (this.getInternalFlags() & 0x40000) != 0;
    }

    void setClearsLinksWhenRemoved(boolean bFlag) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x40000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x40000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFBFFFF);
            }
            this.update(313, old ? 1 : 0, null);
        }
    }

    public boolean doUncapturedMouseMove(int flags, Point dc, Point vc, JGoView view) {
        if (this.getLayer() != null && !this.getLayer().isModifiable()) {
            return false;
        }
        if (!this.isValidSource() && !this.isValidDestination()) {
            return false;
        }
        view.setCursorType(12);
        return true;
    }

    public int getEndSegmentLength() {
        return this.myEndSegmentLength;
    }

    public void setEndSegmentLength(int len) {
        this.internalSetEndSegmentLength(len, false);
    }

    private void internalSetEndSegmentLength(int len, boolean undoing) {
        int old = this.myEndSegmentLength;
        if (old != len) {
            this.myEndSegmentLength = len;
            this.update(309, old, null);
            if (!undoing) {
                this.portChange(309, old, null);
            }
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 301: {
                e.setNewValueInt(this.getStyle());
                return;
            }
            case 302: {
                e.setNewValue(this.getPortObject());
                return;
            }
            case 303: {
                e.setNewValueBoolean(this.isValidSource());
                return;
            }
            case 304: {
                e.setNewValueBoolean(this.isValidDestination());
                return;
            }
            case 305: {
                e.setNewValueInt(this.getFromSpot());
                return;
            }
            case 306: {
                e.setNewValueInt(this.getToSpot());
                return;
            }
            case 307: {
                return;
            }
            case 308: {
                return;
            }
            case 309: {
                e.setNewValueInt(this.getEndSegmentLength());
                return;
            }
            case 312: {
                e.setNewValueInt(this.getPartID());
                return;
            }
            case 313: {
                e.setNewValueBoolean(this.isClearsLinksWhenRemoved());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 301: {
                this.internalSetStyle(e.getValueInt(undo), true);
                return;
            }
            case 302: {
                this.internalSetPortObject((JGoObject)e.getValue(undo), true);
                return;
            }
            case 303: {
                this.setValidSource(e.getValueBoolean(undo));
                return;
            }
            case 304: {
                this.setValidDestination(e.getValueBoolean(undo));
                return;
            }
            case 305: {
                this.internalSetFromSpot(e.getValueInt(undo), true);
                return;
            }
            case 306: {
                this.internalSetToSpot(e.getValueInt(undo), true);
                return;
            }
            case 307: {
                JGoLink l = (JGoLink)e.getOldValue();
                if (undo) {
                    this.removeLink(l);
                } else {
                    this.addLink(l);
                }
                return;
            }
            case 308: {
                JGoLink l = (JGoLink)e.getOldValue();
                if (undo) {
                    this.addLink(l);
                } else {
                    this.removeLink(l);
                }
                return;
            }
            case 309: {
                this.internalSetEndSegmentLength(e.getValueInt(undo), true);
                return;
            }
            case 312: {
                this.setPartID(e.getValueInt(undo));
                return;
            }
            case 313: {
                this.setClearsLinksWhenRemoved(e.getValueBoolean(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public static double getDefaultPaintNothingScale() {
        return myDefaultPaintNothingScale;
    }

    public static void setDefaultPaintNothingScale(double s) {
        myDefaultPaintNothingScale = s;
    }

    public static double getDefaultPaintGreekScale() {
        return myDefaultPaintGreekScale;
    }

    public static void setDefaultPaintGreekScale(double s) {
        myDefaultPaintGreekScale = s;
    }
}

