/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import com.sun.encoder.coco.appinfo.CocoEncoding;
import com.sun.encoder.coco.model.CocoParseException;
import com.sun.encoder.coco.model.CocoPicture;
import com.sun.encoder.coco.model.CocoSign;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xsdschema.AnnotationDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.Element;

public class CocoDescriptionEntry {
    protected ArrayList mChildren;
    protected CocoDescriptionEntry mParent;
    protected String mName;
    protected String mOriginalName;
    protected String mFQN;
    protected int mLevel;
    protected String mIndicatorValue;
    protected boolean mIsContinuation;
    protected boolean mIsComment;
    protected boolean mIsBlankWhenZero;
    protected boolean mIsJustified;
    protected boolean mIsSigned;
    protected CocoDescriptionEntry mOccursDepends;
    protected int mOccursMax;
    protected int mOccursMin;
    protected String mOccursDependsName;
    protected List mOccursDependsQualifiers;
    protected CocoPicture mPicture;
    protected CocoDescriptionEntry mRedefinedTarget;
    protected List mRedefinitions;
    protected int mUsage;
    protected CocoSign mSign;
    protected boolean mSetSign;
    protected boolean mSignSeparate;
    private boolean mUsageExplicit;
    private boolean mIsNameFiller;
    private boolean mIsNameBlank;
    private CocoParseException mReservedWordAfterLevel;
    private final ErrorManager mErrorMgr = ErrorManager.getManager("OpenESB.encoder.COBOLCopybook." + this.getClass().getName());

    public CocoDescriptionEntry() {
        this.mName = "";
        this.mOriginalName = "";
        this.mLevel = -1;
        this.mIndicatorValue = "";
        this.mPicture = null;
        this.mRedefinedTarget = null;
        this.mOccursDepends = null;
        this.mRedefinitions = Collections.synchronizedList(new ArrayList());
        this.mIsContinuation = false;
        this.mIsComment = false;
        this.mIsBlankWhenZero = false;
        this.mIsJustified = false;
        this.mUsage = 3;
        this.mOccursMin = 1;
        this.mOccursMax = 1;
        this.mParent = null;
        this.mChildren = new ArrayList();
        this.mSetSign = false;
        this.mSign = CocoSign.TrailingSign;
        this.mSignSeparate = false;
        this.mUsageExplicit = false;
        this.mIsNameFiller = false;
        this.mIsNameBlank = false;
    }

    public CocoDescriptionEntry(String name, int level) throws IllegalArgumentException {
        if ((level < 1 || level > 49) && level != 66 && level != 77 && level != 88) {
            Message msg = MessageCatalog.getMessage("CCCB4108");
            String text = msg.formatText(new Object[]{String.valueOf(name), String.valueOf(level)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.setName(name);
        this.mLevel = level;
        this.mIndicatorValue = "";
        this.mPicture = null;
        this.mRedefinedTarget = null;
        this.mOccursDepends = null;
        this.mRedefinitions = Collections.synchronizedList(new ArrayList());
        this.mIsContinuation = false;
        this.mIsComment = false;
        this.mIsBlankWhenZero = false;
        this.mIsJustified = false;
        this.mUsage = 3;
        this.mOccursMin = 1;
        this.mOccursMax = 1;
        this.mParent = null;
        this.mChildren = new ArrayList();
        this.mIsSigned = false;
        this.mSetSign = false;
        this.mSign = CocoSign.TrailingSign;
        this.mSignSeparate = false;
        this.mUsageExplicit = false;
        this.mIsNameFiller = false;
        this.mIsNameBlank = false;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name != null ? ((name = name.trim()).length() > 0 ? name : "") : "";
    }

    public String getOriginalName() {
        return this.mOriginalName;
    }

    public void setOriginalName(String originalName) {
        this.mOriginalName = originalName != null ? ((originalName = originalName.trim()).length() > 0 ? originalName : "") : "";
    }

    public boolean isNameFiller() {
        return this.mIsNameFiller;
    }

    public void setNameFiller(boolean isFiller) {
        this.mIsNameFiller = isFiller;
    }

    public boolean isNameBlank() {
        return this.mIsNameBlank;
    }

    public void setNameBlank(boolean isBlank) {
        this.mIsNameBlank = isBlank;
    }

    public String getFQN() {
        return this.mFQN;
    }

    public void setFQN(String name) {
        this.mFQN = name;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public void setLevel(int level) throws IllegalArgumentException {
        if ((level < 1 || level > 49) && level != 66 && level != 77 && level != 88) {
            Message msg = MessageCatalog.getMessage("CCCB4108");
            String text = msg.formatText(new Object[]{String.valueOf(this.mName), String.valueOf(level)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mLevel = level;
    }

    public String getIndicatorValue() {
        return this.mIndicatorValue;
    }

    public void setIndicatorValue(String value) {
        this.mIndicatorValue = value == null ? "" : value;
    }

    public boolean isContinuation() {
        return this.mIsContinuation;
    }

    public void setContinuation(boolean is) {
        this.mIsContinuation = is;
    }

    public boolean isComment() {
        return this.mIsComment;
    }

    public void setComment(boolean is) {
        this.mIsComment = is;
    }

    public boolean isBlankWhenZero() {
        return this.mIsBlankWhenZero;
    }

    public void setBlankWhenZero(boolean is) {
        this.mIsBlankWhenZero = is;
    }

    public boolean isJustified() {
        return this.mIsJustified;
    }

    public void setJustified(boolean is) {
        this.mIsJustified = is;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public void setUsage(int type) throws IllegalArgumentException {
        switch (type) {
            case 3: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 31: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 1: 
            case 2: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 21: {
                if (this.mPicture != null) {
                    Message msg = MessageCatalog.getMessage("CCCB4109");
                    String text = msg.formatText(new Object[]{this.getName()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 22: {
                if (this.mPicture != null) {
                    Message msg = MessageCatalog.getMessage("CCCB4110");
                    String text = msg.formatText(new Object[]{this.getName()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 23: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 24: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 25: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 4: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            case 5: {
                this.mUsage = type;
                this.mUsageExplicit = true;
                break;
            }
            default: {
                Message msg = MessageCatalog.getMessage("CCCB4112");
                String text = msg.formatText(new Object[]{this.getName(), String.valueOf(type)});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
    }

    public String getPicture() {
        String pic = "";
        if (this.mPicture != null) {
            pic = this.mPicture.getPicture();
        }
        return pic;
    }

    public void setPicture(CocoPicture picture) throws IllegalArgumentException {
        if ((this.mUsage == 21 || this.mUsage == 22) && picture != null) {
            Message msg = MessageCatalog.getMessage("CCCB4111");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (picture.getCategory() == 6) {
            this.mUsage = 31;
        }
        this.mPicture = picture;
        this.evaluateForSign();
    }

    public static int computeElementarySize(CocoPicture picture, int usage, boolean separateSign) {
        int length = 0;
        if (picture == null) {
            switch (usage) {
                case 21: {
                    length = 4;
                    break;
                }
                case 22: {
                    length = 8;
                }
            }
        } else if (picture.getCategory() == 7) {
            String pic = picture.getPicture();
            int stopIdx = pic.indexOf(69);
            int numBytes = 0;
            for (int i = 0; i < stopIdx; ++i) {
                if ("9.".indexOf(pic.charAt(i)) == -1) continue;
                ++numBytes;
            }
            length = numBytes + 5;
        } else {
            String pic = picture.getPicture();
            boolean stop = false;
            block20: for (int i = 0; i < pic.length() && !stop; ++i) {
                char ch = pic.charAt(i);
                switch (ch) {
                    case 'A': 
                    case 'E': 
                    case 'X': {
                        ++length;
                        continue block20;
                    }
                    case 'G': 
                    case 'N': {
                        length += 2;
                        continue block20;
                    }
                    case 'B': {
                        length += picture.getCategory() == 6 ? 2 : 1;
                        continue block20;
                    }
                    case 'S': {
                        length += separateSign ? 1 : 0;
                        continue block20;
                    }
                    case 'C': 
                    case 'D': {
                        ++i;
                        length += 2;
                        continue block20;
                    }
                    case 'P': 
                    case 'V': {
                        length += 0;
                        continue block20;
                    }
                    default: {
                        switch (usage) {
                            case 1: 
                            case 2: 
                            case 24: 
                            case 25: {
                                int j;
                                int digitCount = 0;
                                for (j = 0; j < pic.length(); ++j) {
                                    char numch = pic.charAt(j);
                                    if ("90Z".indexOf(numch) == -1) continue;
                                    ++digitCount;
                                }
                                if (digitCount > 0) {
                                    length = digitCount < 5 ? 2 : (digitCount < 10 ? 4 : 8);
                                }
                                stop = true;
                                continue block20;
                            }
                            case 4: 
                            case 23: {
                                int j;
                                int digitCount = 0;
                                for (j = 0; j < pic.length(); ++j) {
                                    if ("90Z".indexOf(pic.charAt(j)) == -1) continue;
                                    ++digitCount;
                                }
                                boolean oddNumbered = digitCount % 2 != 0;
                                length = digitCount / 2 + digitCount % 2;
                                length += oddNumbered ? 0 : 1;
                                stop = true;
                                continue block20;
                            }
                            case 5: {
                                length = 4;
                                stop = true;
                                continue block20;
                            }
                            case 3: {
                                ++length;
                                continue block20;
                            }
                            case 31: {
                                length += 2;
                            }
                        }
                    }
                }
            }
        }
        return length;
    }

    public int getSize() {
        int length = 0;
        if (!this.isElementary()) {
            ListIterator it = this.mChildren.listIterator();
            while (it.hasNext()) {
                CocoDescriptionEntry entry = (CocoDescriptionEntry)it.next();
                int multiplier = entry.getOccursOn() == null ? entry.getMaximumOccurs() : 1;
                length += entry.getSize() * multiplier;
            }
        } else {
            length = CocoDescriptionEntry.computeElementarySize(this.mPicture, this.mUsage, this.isSeparateSign());
        }
        return length;
    }

    public int getJavaType() {
        int type;
        if (this.mPicture != null) {
            int category = this.mPicture.getCategory();
            switch (category) {
                case 1: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 2;
                    break;
                }
                case 5: {
                    type = 2;
                    break;
                }
                case 6: {
                    type = 4;
                    break;
                }
                case 7: {
                    type = 3;
                    break;
                }
                case 3: {
                    type = 2;
                    break;
                }
                case 2: {
                    int decPos = this.mPicture.getDecimalPosition();
                    if (decPos > 0) {
                        type = 3;
                        break;
                    }
                    int numDigits = this.mPicture.countDigits();
                    if (decPos < 0) {
                        numDigits += Math.abs(decPos);
                    }
                    if (numDigits <= 9) {
                        type = 0;
                        break;
                    }
                    if (numDigits <= 18) {
                        type = 1;
                        break;
                    }
                    type = 3;
                    break;
                }
                default: {
                    Message msg = MessageCatalog.getMessage("CCCB4113");
                    String text = msg.formatText(new Object[]{this.getName(), this.mPicture.getPicture()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new RuntimeException(text);
                }
            }
        } else {
            switch (this.mUsage) {
                case 21: {
                    type = 5;
                    break;
                }
                case 22: {
                    type = 6;
                    break;
                }
                default: {
                    type = 2;
                }
            }
        }
        return type;
    }

    public static int getJavaType(String typeName) {
        int trial = 1;
        if (typeName == null) {
            return -1;
        }
        while (trial != 0) {
            if (typeName.equals("int")) {
                return 0;
            }
            if (typeName.equals("long")) {
                return 1;
            }
            if (typeName.equals("float")) {
                return 5;
            }
            if (typeName.equals("double")) {
                return 6;
            }
            if (typeName.equals("BigDecimal") || typeName.equals("java.math.BigDecimal")) {
                return 3;
            }
            if (typeName.equals("byte[]") || typeName.equals("byte []")) {
                return 4;
            }
            if (typeName.equals("java.lang.String") || typeName.equals("String")) {
                return 2;
            }
            if (trial != true) continue;
            typeName = typeName.trim();
            --trial;
        }
        return -1;
    }

    public String getJavaTypeName() {
        String javaType;
        switch (this.getJavaType()) {
            case 3: {
                javaType = "java.math.BigDecimal";
                break;
            }
            case 4: {
                javaType = "byte[]";
                break;
            }
            case 0: {
                javaType = "int";
                break;
            }
            case 1: {
                javaType = "long";
                break;
            }
            case 2: {
                javaType = "java.lang.String";
                break;
            }
            case 6: {
                javaType = "double";
                break;
            }
            case 5: {
                javaType = "float";
                break;
            }
            default: {
                javaType = "java.lang.String";
            }
        }
        return javaType;
    }

    public static String getJavaTypeName(int type) {
        String javaType;
        switch (type) {
            case 0: {
                javaType = "int";
                break;
            }
            case 1: {
                javaType = "long";
                break;
            }
            case 5: {
                javaType = "float";
                break;
            }
            case 6: {
                javaType = "double";
                break;
            }
            case 4: {
                javaType = "byte[]";
                break;
            }
            case 2: {
                javaType = "java.lang.String";
                break;
            }
            case 3: {
                javaType = "java.math.BigDecimal";
                break;
            }
            default: {
                javaType = null;
            }
        }
        return javaType;
    }

    public boolean isPrimitiveJavaType() {
        switch (this.getJavaType()) {
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public static boolean isPrimitiveJavaType(int type) {
        switch (type) {
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 6: {
                return true;
            }
            case 5: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean isRedefined() {
        return this.mRedefinitions.size() > 0;
    }

    public boolean isRedefinition() {
        return this.mRedefinedTarget != null;
    }

    public CocoDescriptionEntry getRedefinedTarget() {
        return this.mRedefinedTarget;
    }

    public int countRedefinitions() {
        return this.mRedefinitions.size();
    }

    public CocoDescriptionEntry getRedefinition(int idx) throws IndexOutOfBoundsException {
        return (CocoDescriptionEntry)this.mRedefinitions.get(idx);
    }

    public void setRedefinedTarget(CocoDescriptionEntry entry) throws IllegalArgumentException, IllegalStateException {
        if (entry == null) {
            throw new NullPointerException();
        }
        if (entry == this) {
            Message msg = MessageCatalog.getMessage("CCCB4114");
            String text = msg.formatText(new Object[]{this.getName()});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (this.mRedefinedTarget != null && this.mRedefinedTarget != entry) {
            Message msg = MessageCatalog.getMessage("CCCB4115");
            String text = msg.formatText(new Object[]{this.getName(), entry.getName(), this.mRedefinedTarget.getName()});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalStateException(text);
        }
        if (this.mLevel != entry.getLevel()) {
            Message msg = MessageCatalog.getMessage("CCCB4116");
            String text = msg.formatText(new Object[]{this.getName(), entry.getName(), String.valueOf(this.mLevel), String.valueOf(entry.getLevel())});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (entry.isRedefinition()) {
            entry = entry.getRedefinedTarget();
        }
        this.mRedefinedTarget = entry;
        if (!entry.mRedefinitions.contains(this)) {
            CocoDescriptionEntry parentEntry;
            entry.mRedefinitions.add(this);
            if (!this.mUsageExplicit && null != (parentEntry = entry.getParent())) {
                this.setUsage(parentEntry.getUsage());
                this.mUsageExplicit = false;
            }
        }
    }

    public int getMinimumOccurs() {
        return this.mOccursMin;
    }

    public int getMaximumOccurs() {
        return this.mOccursMax;
    }

    public CocoDescriptionEntry getOccursOn() {
        return this.mOccursDepends;
    }

    public String getDependOnName() {
        return this.mOccursDependsName;
    }

    public void setDependOnName(String name) {
        this.mOccursDependsName = name;
    }

    public List getDependOnNameQualifiers() {
        return this.mOccursDependsQualifiers;
    }

    public void setDependOnNameQualifiers(List qualifiers) {
        this.mOccursDependsQualifiers = qualifiers;
    }

    public void setOccurs(int count) throws IllegalArgumentException {
        if (count < 1) {
            Message msg = MessageCatalog.getMessage("CCCB4117");
            String text = msg.formatText(new Object[]{String.valueOf(count)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mOccursMin = count;
        this.mOccursMax = count;
        this.mOccursDepends = null;
    }

    public void setDependsOnTarget(CocoDescriptionEntry entry) {
        this.mOccursDepends = entry;
    }

    public void setSign(CocoSign sign) {
        if (sign != null) {
            this.mSetSign = true;
            this.mSign = sign;
        }
        this.evaluateForSign();
    }

    public void setSeparateSign(boolean hasSeparateSign) {
        this.mSignSeparate = hasSeparateSign;
        this.evaluateForSign();
    }

    public boolean isSeparateSign() {
        return this.mSignSeparate;
    }

    public boolean isSigned() {
        return this.mIsSigned;
    }

    private void evaluateForSign() {
        boolean bl = this.mIsSigned = this.mPicture != null && this.mPicture.getPicture().indexOf("S") != -1;
        if (!this.mIsSigned) {
            this.mSignSeparate = false;
        }
    }

    public void setOccurs(int low, int high, CocoDescriptionEntry depends) throws IllegalArgumentException {
        if (low < 1 && low == high) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (low < 0) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (high < 0) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (high < low) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (null == depends) {
            Message msg = MessageCatalog.getMessage("CCCB4119");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mOccursDependsName = null;
        this.mOccursDependsQualifiers = null;
        this.mOccursMin = low;
        this.mOccursMax = high;
        this.mOccursDepends = depends;
    }

    public void setOccursResolveLater(int low, int high, List qualifiers, String depend_on_name) throws IllegalArgumentException {
        if (low < 1 && low == high) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (low < 0) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (high < 0) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (high < low) {
            Message msg = MessageCatalog.getMessage("CCCB4118");
            String text = msg.formatText(new Object[]{String.valueOf(low), String.valueOf(high)});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        String normalName = "";
        if (depend_on_name != null) {
            normalName = depend_on_name.toUpperCase();
        }
        this.mOccursDependsName = normalName;
        this.mOccursDependsQualifiers = this.normalizeQualifiers(qualifiers);
        this.mOccursMin = low;
        this.mOccursMax = high;
        this.mOccursDepends = null;
    }

    private List normalizeQualifiers(List qualifiers) {
        if (qualifiers != null && qualifiers.size() > 0) {
            for (int i = 0; i < qualifiers.size(); ++i) {
                String qn = (String)qualifiers.get(i);
                if (qn == null) continue;
                qualifiers.set(i, qn.toUpperCase());
            }
        }
        return qualifiers;
    }

    public CocoDescriptionEntry getParent() {
        return this.mParent;
    }

    public void setParent(CocoDescriptionEntry entry) throws IllegalArgumentException {
        if (entry == this) {
            Message msg = MessageCatalog.getMessage("CCCB4120");
            String text = msg.formatText(new Object[]{this.getName()});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (this.mChildren.contains(entry)) {
            Message msg = MessageCatalog.getMessage("CCCB4121");
            String text = msg.formatText(new Object[]{entry.getName(), this.getName()});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mParent = entry;
    }

    public boolean isElementary() {
        return this.mChildren.size() == 0;
    }

    public int countChildren() {
        return this.mChildren.size();
    }

    public CocoDescriptionEntry getChild(int idx) throws IndexOutOfBoundsException {
        return (CocoDescriptionEntry)this.mChildren.get(idx);
    }

    public void addChild(CocoDescriptionEntry entry) throws IllegalArgumentException {
        if (entry == this || entry == null) {
            throw new NullPointerException();
        }
        if (this.mChildren.contains(entry)) {
            return;
        }
        if (entry == this.mParent || entry.getLevel() <= this.mLevel) {
            Message msg = MessageCatalog.getMessage("CCCB4122");
            String text = msg.formatText(new Object[]{entry.getName(), this.getName()});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        int idx = this.mChildren.size() - 1;
        if (idx < 0) {
            if (this.mUsageExplicit) {
                entry.setUsage(this.mUsage);
            }
            this.mChildren.add(entry);
            entry.setParent(this);
        } else {
            CocoDescriptionEntry lastChild = (CocoDescriptionEntry)this.mChildren.get(idx);
            if (lastChild.getLevel() < entry.getLevel()) {
                lastChild.addChild(entry);
            } else {
                if (this.mUsageExplicit) {
                    entry.setUsage(this.mUsage);
                }
                this.mChildren.add(entry);
                entry.setParent(this);
            }
        }
    }

    public String getInfo() {
        return this.getLevel() + " " + this.getName() + " FQN = " + this.getFQN();
    }

    public CocoEncoding toElement(Element elem) {
        if (this.isElementary()) {
            if (this.mUsageExplicit && this.mUsage != 3 && this.mUsage != 31) {
                switch (this.mUsage) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 23: 
                    case 24: 
                    case 25: {
                        if (this.mPicture == null) {
                            elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
                            break;
                        }
                        this.setBestFitDecimalType(elem, this.mPicture);
                        break;
                    }
                    case 21: {
                        elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "float"));
                        break;
                    }
                    case 22: {
                        elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "double"));
                        break;
                    }
                    case 5: {
                        elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
                        break;
                    }
                    default: {
                        Message msg = MessageCatalog.getMessage("CCCB4015");
                        String text = msg.formatText(new Object[]{this.mUsage});
                        this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                        throw new IllegalArgumentException(text);
                    }
                }
            } else if (this.mPicture == null) {
                elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            } else if (this.mPicture.getCategory() == 2) {
                this.setBestFitDecimalType(elem, this.mPicture);
            } else {
                elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
            }
        }
        CocoEncoding encoding = CocoEncoding.Factory.newInstance();
        if (this.mIsNameFiller) {
            encoding.setNameFiller("");
        } else if (this.mIsNameBlank) {
            encoding.setNameBlank("");
        } else {
            encoding.setOriginalName(this.mOriginalName);
        }
        if (this.mIsBlankWhenZero) {
            encoding.setBlankWhenZero("");
        }
        if (this.mIsJustified) {
            encoding.setJustified("");
        }
        if (this.mSetSign) {
            CocoEncoding.Sign sign = encoding.addNewSign();
            if (this.mSign == CocoSign.LeadingSign) {
                sign.setLeading("");
            } else if (this.mSign == CocoSign.TrailingSign) {
                sign.setTrailing("");
            }
            if (this.isSeparateSign()) {
                sign.setSeparate("");
            }
        }
        if (this.mPicture != null) {
            encoding.setPicture(this.mPicture.getOriginalPicture());
        }
        encoding.setLevel((short)this.mLevel);
        if (this.mUsageExplicit) {
            CocoEncoding.Usage usage = encoding.addNewUsage();
            switch (this.mUsage) {
                case 1: {
                    usage.setBinary("");
                    break;
                }
                case 2: {
                    usage.setComp("");
                    break;
                }
                case 21: {
                    usage.setComp1("");
                    break;
                }
                case 22: {
                    usage.setComp2("");
                    break;
                }
                case 23: {
                    usage.setComp3("");
                    break;
                }
                case 24: {
                    usage.setComp4("");
                    break;
                }
                case 25: {
                    usage.setComp5("");
                    break;
                }
                case 3: {
                    usage.setDisplay("");
                    break;
                }
                case 31: {
                    usage.setDisplay1("");
                    break;
                }
                case 5: {
                    usage.setIndex("");
                    break;
                }
                case 4: {
                    usage.setPackedDecimal("");
                }
            }
        }
        encoding.setSource("urn:com.sun:encoder");
        AnnotationDocument.Annotation anno = elem.isSetAnnotation() ? elem.getAnnotation() : elem.addNewAnnotation();
        if (anno.sizeOfAppinfoArray() == 0) {
            anno.addNewAppinfo();
        }
        anno.getAppinfoArray(0).set((XmlObject)encoding);
        return encoding;
    }

    private void setBestFitDecimalType(Element elem, CocoPicture picture) {
        if (picture.getDecimalPosition() <= 0) {
            int digits = picture.countDigits() - picture.getDecimalPosition();
            if (digits > 9) {
                elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "long"));
            } else if (digits > 4) {
                elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "int"));
            } else {
                elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "short"));
            }
        } else {
            elem.setType(new QName("http://www.w3.org/2001/XMLSchema", "decimal"));
        }
    }

    public void setReservedWordAfterLevel(CocoParseException e) {
        this.mReservedWordAfterLevel = e;
    }

    public CocoParseException getReservedWordAfterLevel() {
        return this.mReservedWordAfterLevel;
    }

    public boolean usageExplicit() {
        return this.mUsageExplicit;
    }

    public String getUsageName(int type) {
        String name = "Unknown";
        switch (type) {
            case 2: {
                name = "COMP";
                break;
            }
            case 21: {
                name = "COMP-1";
                break;
            }
            case 22: {
                name = "COMP-2";
                break;
            }
            case 23: {
                name = "COMP-3";
                break;
            }
            case 24: {
                name = "COMP-4";
                break;
            }
            case 25: {
                name = "COMP-5";
                break;
            }
            case 1: {
                name = "BINARY";
                break;
            }
            case 3: {
                name = "DISPLAY";
                break;
            }
            case 31: {
                name = "DISPLAY1";
                break;
            }
            case 5: {
                name = "INDEX";
                break;
            }
            case 4: {
                name = "PACKED-DECIMAL";
                break;
            }
        }
        return name;
    }

    public static interface JavaType {
        public static final int INT = 0;
        public static final int LONG = 1;
        public static final int STRING = 2;
        public static final int BIGDEC = 3;
        public static final int BYTEARRAY = 4;
        public static final int FLOAT = 5;
        public static final int DOUBLE = 6;
    }

    public static interface BarkKey {
        public static final String IS_ELEMENTARY = "Elementary?";
        public static final String IS_REDEFINITION = "Redefinition?";
        public static final String IS_REDEFINED = "Redefined?";
        public static final String IS_BLANK_WHEN_ZERO = "BlankWhenZero?";
        public static final String IS_JUSTIFIED = "Justified?";
        public static final String IS_SIGNED = "Signed?";
        public static final String IS_SIGN_SEPARATE = "SignIsSeparate?";
        public static final String IS_SIGN_LEADING = "SignIsLeading?";
        public static final String IS_SIGN_TRAILING = "SignIsTrailing?";
        public static final String LEVEL = "Level";
        public static final String OCCURS_DEPENDS = "OccursDependsOn";
        public static final String REDEFINITION_ID = "RedefinitionObject";
        public static final String LENGTH = "Length";
        public static final String MAX_OCCURS = "MaxOccurs";
        public static final String MIN_OCCURS = "MinOccurs";
        public static final String PICTURE = "Picture";
        public static final String PICTURE_CATEGORY = "PictureCategory";
        public static final String PICTURE_DECIMAL_POS = "PictureDecimalPos";
        public static final String PICTURE_DECIMAL_SCALING_SPAN = "PictureDecimalScalePositions";
        public static final String USAGE = "Usage";
        public static final String JAVATYPE = "JavaType";
        public static final String FQN = "FQN";
    }

    public static interface UsageTypeName {
        public static final String BINARY = "BINARY";
        public static final String COMP = "COMP";
        public static final String COMP1 = "COMP-1";
        public static final String COMP2 = "COMP-2";
        public static final String COMP3 = "COMP-3";
        public static final String COMP4 = "COMP-4";
        public static final String COMP5 = "COMP-5";
        public static final String DISPLAY = "DISPLAY";
        public static final String DISPLAY1 = "DISPLAY1";
        public static final String PACDEC = "PACKED-DECIMAL";
        public static final String INDEX = "INDEX";
    }

    public static interface UsageType {
        public static final int BINARY = 1;
        public static final int COMP = 2;
        public static final int COMP1 = 21;
        public static final int COMP2 = 22;
        public static final int COMP3 = 23;
        public static final int COMP4 = 24;
        public static final int COMP5 = 25;
        public static final int DISPLAY = 3;
        public static final int DISPLAY1 = 31;
        public static final int PACDEC = 4;
        public static final int INDEX = 5;
    }
}

