/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngine;
import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLEngineListener;
import com.sun.etl.engine.ETLEngineLogEvent;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.utils.AttributeMap;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ETLTaskNodeImpl
implements ETLTaskNode {
    private static final String ATTR_DEPENDSON = "dependsOn";
    private static final String ATTR_DN = "displayName";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TASKREFIDS = "taskRefIds";
    private static final String ATTR_TASKTYPE = "taskType";
    private static final String ATTR_TN = "tableName";
    private static final String TAG_INIT_PROCESS = "initMetadata";
    private static final String TAG_NEXT = "next";
    private static final String TAG_PER_TABLE = "perTableStatements";
    private static final String TAG_SITUATION = "situation";
    protected AttributeMap attributes = new AttributeMap();
    private String dependsOn;
    private String displayName;
    private String id;
    private ETLEngine parent;
    private Map situationToNextTaskIdMap;
    private List sqlParts;
    private Map statementMap = new HashMap();
    private String status;
    private String tableName;
    private Map tableToStatementsMap = new HashMap();
    private String taskType;

    public ETLTaskNodeImpl() {
        this.situationToNextTaskIdMap = new HashMap();
        this.sqlParts = new ArrayList();
    }

    public int addNextETLTaskNode(String situation, String nextTaskID) {
        if (situation == null || "START".equals(nextTaskID)) {
            return -1;
        }
        String idList = (String)this.situationToNextTaskIdMap.get(situation);
        if (idList == null || idList.length() == 0) {
            idList = nextTaskID;
        } else {
            HashSet<String> nodeIds = new HashSet<String>(StringUtil.createStringListFrom(idList));
            if (!nodeIds.contains(nextTaskID)) {
                nodeIds.add(nextTaskID);
                idList = StringUtil.createDelimitedStringFrom(new ArrayList(nodeIds));
            }
        }
        this.situationToNextTaskIdMap.put(situation, idList);
        return 0;
    }

    public void addOptionalTask(SQLPart sqlPart) {
        this.sqlParts.add(sqlPart);
    }

    public void addStatement(SQLPart newSql) {
        if (newSql == null) {
            throw new IllegalArgumentException("Must supply non-null ETLSQLStatement ref for parameter 'newSql'.");
        }
        this.statementMap.put(newSql.getType(), newSql);
    }

    public void addTableSpecificStatement(String aTableName, SQLPart newSql) {
        Map tableStmtMap = this.getOrCreateTableStatementMap(aTableName);
        tableStmtMap.put(newSql.getType(), newSql);
    }

    public void fireETLEngineExecutionEvent(ETLEngineExecEvent evnt) {
        ETLEngineListener listener = this.parent.getETLEngineListener();
        if (listener != null) {
            listener.executionPerformed(evnt);
        }
    }

    public synchronized void fireETLEngineLogEvent(String logMessage) {
        this.fireETLEngineLogEvent(logMessage, 20000);
    }

    public synchronized void fireETLEngineLogEvent(String logMessage, int level) {
        MessageManager msgMgr = MessageManager.getManager("com.sun.etl.engine.impl");
        try {
            ETLEngineListener listener = this.parent.getETLEngineListener();
            if (listener != null) {
                String msgMarker = "";
                if (!StringUtil.isNullString(this.displayName)) {
                    String collabName = this.parent.getDisplayName();
                    msgMarker = !StringUtil.isNullString(collabName) ? msgMgr.getString("LBL_tasknode_marker_collab_dn", collabName.trim(), this.displayName.trim()) : msgMgr.getString("LBL_tasknode_marker_dn_only", this.displayName.trim());
                }
                String nl = System.getProperty("line.separator");
                listener.updateOutputMessage(new ETLEngineLogEvent(msgMarker, logMessage + nl, level));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List getAllNextETLTaskNodes() {
        HashSet nodeSet = new HashSet();
        Iterator iter = this.situationToNextTaskIdMap.values().iterator();
        while (iter.hasNext()) {
            nodeSet.addAll(StringUtil.createStringListFrom((String)iter.next()));
        }
        return new ArrayList(nodeSet);
    }

    public List getAllSituations() {
        return new ArrayList(this.situationToNextTaskIdMap.keySet());
    }

    public Map getAllStatements() {
        return this.statementMap;
    }

    public AttributeMap getAttributeMap() {
        return this.attributes;
    }

    public ETLEngineContext getContext() {
        return this.parent == null ? null : this.parent.getContext();
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getNextTaskList(String situation) {
        return this.situationToNextTaskIdMap != null && situation != null ? (String)this.situationToNextTaskIdMap.get(situation) : null;
    }

    public List getOptionalTasks() {
        return this.sqlParts;
    }

    public ETLEngine getParent() {
        return this.parent;
    }

    public SQLPart getStatement(String stmtType) {
        if (StringUtil.isNullString(stmtType)) {
            throw new IllegalArgumentException("Must supply non-empty String value for parameter 'stmtType'.");
        }
        return (SQLPart)this.statementMap.get(stmtType);
    }

    public List getStatementTypes() {
        return new ArrayList(this.statementMap.keySet());
    }

    public String getStatus() {
        return this.status;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Collection getTableNamesWithSpecificStatements() {
        return this.tableToStatementsMap.keySet();
    }

    public SQLPart getTableSpecificStatement(String aTableName, String stmtType) {
        Map tableStmtMap = this.getOrCreateTableStatementMap(aTableName);
        return (SQLPart)tableStmtMap.get(stmtType);
    }

    public Map getTableSpecificStatements(String aTableName) {
        Map tableStmtMap = this.getOrCreateTableStatementMap(aTableName);
        return Collections.unmodifiableMap(tableStmtMap);
    }

    public String getTaskType() {
        return this.taskType;
    }

    public boolean isStartNode() {
        "START".equals(this.getTaskType());
        return false;
    }

    public void parseXML(Element element) throws BaseException {
        if (element == null) {
            throw new BaseException("Must supply non-null Element ref for parameter 'element'.");
        }
        this.id = element.getAttribute(ATTR_ID);
        if (StringUtil.isNullString(this.id)) {
            throw new BaseException("XML element has an empty or missing value for attribute 'id'.");
        }
        this.taskType = element.getAttribute(ATTR_TASKTYPE);
        if (StringUtil.isNullString(this.taskType)) {
            throw new BaseException("XML element has an empty or missing value for attribute 'taskType'.");
        }
        this.displayName = element.getAttribute(ATTR_DN);
        if (StringUtil.isNullString(this.taskType)) {
            this.displayName = null;
        }
        this.tableName = element.getAttribute(ATTR_TN);
        if (StringUtil.isNullString(this.taskType)) {
            this.tableName = null;
        }
        this.dependsOn = element.getAttribute(ATTR_DEPENDSON);
        NodeList list = element.getElementsByTagName(TAG_NEXT);
        this.parseNextTaskElements(list);
        NodeList childNodes = element.getChildNodes();
        ArrayList<Element> childSQLParts = new ArrayList<Element>();
        Element tmpElement = null;
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            if (childNodes.item(i).getNodeType() != 1 || !"sqlPart".equals((tmpElement = (Element)childNodes.item(i)).getNodeName())) continue;
            childSQLParts.add(tmpElement);
        }
        this.parseSQLStatements(childSQLParts, this.statementMap);
        list = element.getElementsByTagName(TAG_INIT_PROCESS);
        this.parseInitProcessTasks(list);
        list = element.getElementsByTagName(TAG_PER_TABLE);
        this.parsePerTableStatements(list);
        list = element.getChildNodes();
        try {
            this.attributes.parseAttributeList(list);
        }
        catch (Exception e) {
            Logger.print(10000, this.getClass().getName(), (Object)"Failed to parseAttributeList in TaskNodeImpl", e);
            throw new BaseException("Failed to parseAttributeList in TaskNodeImpl", e);
        }
    }

    public int removeNextETLTaskNode(String situation, String nextTaskID) {
        if (situation == null || "START".equals(nextTaskID)) {
            return -1;
        }
        String idList = (String)this.situationToNextTaskIdMap.get(situation);
        if (idList == null || idList.length() == 0) {
            return 0;
        }
        HashSet nodeIds = new HashSet(StringUtil.createStringListFrom(idList));
        if (nodeIds.contains(nextTaskID)) {
            nodeIds.remove(nextTaskID);
            idList = StringUtil.createDelimitedStringFrom(new ArrayList(nodeIds));
            this.situationToNextTaskIdMap.put(situation, idList);
        }
        return 0;
    }

    public boolean removeStatement(String stmtType) {
        if (StringUtil.isNullString(stmtType)) {
            throw new IllegalArgumentException("Must supply non-empty String value for parameter 'typeName.'");
        }
        return this.statementMap.remove(stmtType) != null;
    }

    public void setAllStatement(Map stmtMap) {
        this.statementMap = stmtMap;
    }

    public void setAttributeMap(AttributeMap attrMap) {
        this.attributes = attrMap;
    }

    public void setDependsOn(String adepends) {
        this.dependsOn = adepends;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public void setOptionalTasks(List theSqlParts) {
        this.sqlParts = theSqlParts;
    }

    public void setParent(ETLEngine parent) {
        this.parent = parent;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public void setTaskType(String ataskType) {
        this.taskType = ataskType;
    }

    public String toXMLString() {
        return this.toXMLString("");
    }

    public String toXMLString(String prefix) {
        StringBuffer buf = new StringBuffer(250);
        if (prefix == null) {
            prefix = "";
        }
        buf.append(prefix).append("<task ");
        buf.append("id=\"").append(this.id).append("\" ");
        buf.append("taskType=\"").append(this.taskType).append("\" ");
        buf.append("dependsOn=\"");
        if (this.dependsOn != null) {
            buf.append(this.dependsOn.trim());
        }
        buf.append("\"");
        if (!StringUtil.isNullString(this.displayName)) {
            buf.append(" ").append(ATTR_DN).append("=\"").append(this.displayName.trim()).append("\"");
        }
        if (!StringUtil.isNullString(this.tableName)) {
            buf.append(" ").append(ATTR_TN).append("=\"").append(this.tableName.trim()).append("\"");
        }
        buf.append(">\n");
        buf.append(this.attributes.toXMLString(prefix));
        buf.append(this.writeNextTaskElements(prefix + "\t"));
        buf.append(this.writeSQLStatementsForMap(this.statementMap, prefix + "\t"));
        buf.append(this.writeSQLStatementsForList(prefix + "\t"));
        buf.append(this.writePerTableSQLStatements(prefix + "\t"));
        buf.append(prefix).append("</task>\n");
        return buf.toString();
    }

    public boolean validate() throws ETLException {
        return true;
    }

    private Map getOrCreateTableStatementMap(String aTableName) {
        HashMap tableStmtMap = (HashMap)this.tableToStatementsMap.get(aTableName);
        if (tableStmtMap == null) {
            tableStmtMap = new HashMap();
            this.tableToStatementsMap.put(aTableName, tableStmtMap);
        }
        return tableStmtMap;
    }

    private void parseInitProcessTasks(NodeList list) throws BaseException {
        Node aNode;
        if (list != null && list.getLength() != 0 && (aNode = list.item(0)).getNodeType() == 1) {
            NodeList sqlPartsList = aNode.getChildNodes();
            this.parseSQL(sqlPartsList);
        }
    }

    private void parseNextTaskElements(NodeList list) throws BaseException {
        if (list.getLength() == 0) {
            throw new BaseException("No next task elements found!");
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node aNode = list.item(i);
            if (aNode.getNodeType() != 1) continue;
            Element elem = (Element)aNode;
            if (!TAG_NEXT.equals(aNode.getNodeName())) continue;
            NodeList situations = elem.getElementsByTagName(TAG_SITUATION);
            this.parseSituationElements(situations);
            break;
        }
    }

    private void parsePerTableStatements(NodeList list) throws BaseException {
        if (list != null && list.getLength() != 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node aNode = list.item(i);
                if (aNode.getNodeType() != 1) continue;
                Element perTableElement = (Element)aNode;
                String aTableName = perTableElement.getAttribute(ATTR_TN);
                NodeList sqlPartsList = aNode.getChildNodes();
                this.parseSQLStatements(sqlPartsList, this.getOrCreateTableStatementMap(aTableName));
            }
        }
    }

    private void parseSituationElements(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem;
            String situationType;
            Node aNode = list.item(i);
            if (aNode.getNodeType() != 1 || !"Success".equals(situationType = (elem = (Element)aNode).getAttribute(ATTR_NAME)) && !"Exception".equals(situationType)) continue;
            this.situationToNextTaskIdMap.put(situationType, elem.getAttribute(ATTR_TASKREFIDS));
        }
    }

    private void parseSQL(NodeList list) throws BaseException {
        for (int i = 0; i < list.getLength(); ++i) {
            Node aNode = list.item(i);
            if (aNode.getNodeType() != 1) continue;
            SQLPart stmt = new SQLPart((Element)aNode);
            this.sqlParts.add(stmt);
        }
    }

    private void parseSQLStatements(NodeList list, Map stmtMap) throws BaseException {
        for (int i = 0; i < list.getLength(); ++i) {
            Node aNode = list.item(i);
            if (aNode.getNodeType() != 1) continue;
            SQLPart stmt = new SQLPart((Element)aNode);
            stmtMap.put(stmt.getType(), stmt);
        }
    }

    private void parseSQLStatements(List list, Map stmtMap) throws BaseException {
        for (int i = 0; i < list.size(); ++i) {
            Node aNode = (Node)list.get(i);
            if (aNode.getNodeType() != 1) continue;
            SQLPart stmt = new SQLPart((Element)aNode);
            stmtMap.put(stmt.getType(), stmt);
        }
    }

    private String writeNextTaskElements(String prefix) {
        StringBuffer buf = new StringBuffer(100);
        if (prefix == null) {
            prefix = "";
        }
        buf.append(prefix).append("<next");
        if (this.situationToNextTaskIdMap.size() == 0) {
            buf.append(" />\n");
        } else {
            buf.append(">\n");
            for (Map.Entry entry : this.situationToNextTaskIdMap.entrySet()) {
                String situation = (String)entry.getKey();
                String idList = (String)entry.getValue();
                buf.append(prefix + "\t").append("<situation ");
                buf.append("name=\"" + situation.trim() + "\" ");
                buf.append("taskRefIds=\"" + idList.trim() + "\" />\n");
            }
            buf.append(prefix).append("</next>\n");
        }
        return buf.toString();
    }

    private String writePerTableSQLStatements(String prefix) {
        StringBuffer buf = new StringBuffer(100);
        if (prefix == null) {
            prefix = "";
        }
        if (this.tableToStatementsMap.size() != 0) {
            for (Map.Entry entry : this.tableToStatementsMap.entrySet()) {
                String aTableName = (String)entry.getKey();
                Map stmtMap = (Map)entry.getValue();
                buf.append(prefix).append("<").append(TAG_PER_TABLE).append(" ").append(ATTR_TN).append("=\"").append(aTableName).append("\"").append(">").append("\n");
                buf.append(this.writeSQLStatementsForMap(stmtMap, prefix + "\t"));
                buf.append(prefix).append("</").append(TAG_PER_TABLE).append(">").append("\n");
            }
        }
        return buf.toString();
    }

    private String writeSQLStatements(String prefix, Iterator iter) {
        StringBuffer buf = new StringBuffer(100);
        if (prefix == null) {
            prefix = "";
        }
        while (iter.hasNext()) {
            SQLPart stmt = (SQLPart)iter.next();
            buf.append(stmt.toXMLString(prefix));
        }
        return buf.toString();
    }

    private String writeSQLStatementsForList(String prefix) {
        StringBuffer buf = new StringBuffer(100);
        if (prefix == null) {
            prefix = "";
        }
        if (this.sqlParts.size() != 0) {
            buf.append(prefix).append("<").append(TAG_INIT_PROCESS).append(">").append("\n");
            Iterator iter = this.sqlParts.iterator();
            buf.append(this.writeSQLStatements(prefix + "\t", iter));
            buf.append(prefix).append("</").append(TAG_INIT_PROCESS).append(">\n");
        }
        return buf.toString();
    }

    private String writeSQLStatementsForMap(Map statements, String prefix) {
        Iterator iter = statements.values().iterator();
        return this.writeSQLStatements(prefix, iter);
    }
}

