/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngineContext;
import com.sun.etl.engine.ETLEngineExecEvent;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.jdbc.SQLUtils;
import com.sun.sql.framework.utils.AttributeMap;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class Extractor
extends SimpleTask {
    public static final String KEY_ISONEPASS = "isOnePass";
    public static final String KEY_JOBQUEUESIZE = "jobQueueSize";
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final String LOG_CATEGORY = Extractor.class.getName();
    private static final MessageManager MSG_MGR = MessageManager.getManager("com.sun.etl.engine.impl");
    private int batchSize = 5000;
    private String createInsertPoolName = null;
    private Connection destPoolCon = null;
    private DBConnectionFactory factory = DBConnectionFactory.getInstance();
    private String selectPoolName = null;
    private Connection srcPoolCon = null;
    private ETLTaskNode taskNode;
    private BlockingQueue<PreparedStatement> jobQueue;
    private BlockingQueue<PreparedStatement> preparedStmtPool;

    public void cleanUp() {
        Logger.print(10000, LOG_CATEGORY, (Object)this, MSG_MGR.getString("MSG_extractor_close_src_conn", this.srcPoolCon));
        this.factory.closeConnection(this.srcPoolCon);
        if (this.destPoolCon != null) {
            Logger.print(10000, LOG_CATEGORY, (Object)this, MSG_MGR.getString("MSG_extractor_mark_for_release", this.destPoolCon));
            this.taskNode.getContext().closeAndReleaseLater(this.destPoolCon);
        }
        this.taskNode = null;
        super.cleanUp();
    }

    public void handleException(ETLException ex) {
        this.cleanUp();
        Logger.printThrowable(10000, LOG_CATEGORY, "Extractor", "Handling exception for Extractor...", ex);
        if (this.destPoolCon != null && this.createInsertPoolName != null) {
            this.factory.closeConnection(this.destPoolCon);
            this.destPoolCon = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(ETLTaskNode node) throws ETLException {
        ResultSet rs = null;
        try {
            SQLPart insertSQLPart;
            int bsInt;
            boolean isOnePass;
            if (node == null) {
                throw new ETLException("Task node is null....");
            }
            this.taskNode = node;
            Object onePassFlagObj = node.getAttributeMap().getAttributeValue(KEY_ISONEPASS);
            boolean bl = isOnePass = onePassFlagObj instanceof Boolean && (Boolean)onePassFlagObj != false;
            if (isOnePass) {
                ETLEngineContext.CollabStatistics stats = node.getParent().getContext().getStatistics();
                Timestamp startTime = super.createExecutionEntryInSummaryTable(node);
                stats.setTableStartTime(node.getTableName(), startTime);
                int executionId = super.getExecutionEntryIdFromSummaryTable(node, startTime);
                stats.setTableExecutionId(node.getTableName(), executionId);
                ETLEngineExecEvent evnt = new ETLEngineExecEvent(3, node.getTableName(), "" + executionId);
                this.taskNode.fireETLEngineExecutionEvent(evnt);
            }
            if (!StringUtil.isNullString(node.getDisplayName())) {
                this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
            }
            String msg = MSG_MGR.getString("MSG_extractor_started");
            node.fireETLEngineLogEvent(msg, 10000);
            List connList = node.getParent().getConnectionDefList();
            AttributeMap attrMap = this.taskNode.getAttributeMap();
            String batchSizeStr = (String)attrMap.getAttributeValue("batchSize");
            if (!StringUtil.isNullString(batchSizeStr) && (bsInt = StringUtil.getInt(batchSizeStr)) > 0) {
                this.batchSize = bsInt;
            }
            if ((insertSQLPart = node.getStatement("insertStatement")) == null) {
                throw new ETLException(this.DN + "Missing required insert SQLPart element");
            }
            String insertStmt = insertSQLPart.getSQL();
            if (insertStmt == null) {
                throw new ETLException(this.DN + "Missing required insert statement");
            }
            Map attribMap = this.taskNode.getParent().getInputAttrMap();
            insertStmt = SQLUtils.replaceTableNameFromRuntimeArguments(insertStmt, attribMap);
            this.createInsertPoolName = insertSQLPart.getConnectionPoolName();
            this.destPoolCon = this.getConnection(this.createInsertPoolName, connList);
            Logger.print(10000, LOG_CATEGORY, this.DN + " Got staging connection: " + this.destPoolCon);
            this.setAutoCommitIfRequired(this.destPoolCon, true);
            this.dropTable(node, this.destPoolCon);
            this.createTable(node, this.destPoolCon);
            this.setAutoCommitIfRequired(this.destPoolCon, false);
            if (!this.createBeforeProcess(node, this.destPoolCon)) {
                this.truncateBeforeProcess(node, this.destPoolCon);
            }
            rs = this.getSelectData(node);
            List types = (List)insertSQLPart.getAttribute("jdbcTypeList").getAttributeValue();
            this.insertData(rs, insertStmt, this.destPoolCon, types, node);
            msg = MSG_MGR.getString("MSG_extractor_finished");
            node.fireETLEngineLogEvent(msg, 10000);
        }
        catch (Exception t) {
            this.handleException(t);
        }
        finally {
            Statement rsStmt = null;
            if (rs != null) {
                try {
                    rsStmt = rs.getStatement();
                }
                catch (SQLException e) {}
                this.closeResultSet(rs);
                this.closeStatement(rsStmt);
            }
        }
        return "Success";
    }

    private void handleException(Throwable t) throws ThreadDeath, ETLException {
        t = this.unwrapThrowable(t);
        StringBuffer errMsg = new StringBuffer(this.DN);
        String throwableMsg = t.getMessage();
        if (StringUtil.isNullString(throwableMsg)) {
            throwableMsg = t.toString();
        }
        errMsg.append(MSG_MGR.getString("MSG_common_chain_colon", MSG_MGR.getString("MSG_extractor_failed"), throwableMsg));
        String msg = errMsg.toString();
        Logger.print(10000, LOG_CATEGORY, (Object)msg, t);
        throw new ETLException(msg, t);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTable(ETLTaskNode node, Connection con) throws Exception {
        SQLPart createSQLPart;
        String createTableRelatedSql;
        Statement stmt;
        block8: {
            stmt = null;
            createTableRelatedSql = "";
            createSQLPart = node.getStatement("createStatement");
            if (createSQLPart != null) break block8;
            this.closeStatement(stmt);
            return;
        }
        try {
            Iterator itr = createSQLPart.getIterator();
            while (itr.hasNext()) {
                stmt = con.createStatement();
                createTableRelatedSql = (String)itr.next();
                Map attribMap = this.taskNode.getParent().getInputAttrMap();
                createTableRelatedSql = SQLUtils.replaceTableNameFromRuntimeArguments(createTableRelatedSql, attribMap);
                String createStartMsg = MSG_MGR.getString("MSG_extractor_create_attempt");
                this.taskNode.fireETLEngineLogEvent(createStartMsg, 10000);
                String showSqlMsg = MSG_MGR.getString("MSG_common_using_sql", createTableRelatedSql);
                this.taskNode.fireETLEngineLogEvent(showSqlMsg, 10000);
                stmt.executeQuery(createTableRelatedSql);
                String successMsg = MSG_MGR.getString("MSG_extractor_create_success");
                this.taskNode.fireETLEngineLogEvent(successMsg, 10000);
            }
        }
        catch (SQLException e) {
            block9: {
                try {
                    if (!this.isObjectAlreadyExistsException(e)) break block9;
                    String tableExistsMsg = MSG_MGR.getString("MSG_extractor_create_failure_table_exists");
                    this.taskNode.fireETLEngineLogEvent(tableExistsMsg, 30000);
                }
                catch (Throwable throwable) {
                    this.closeStatement(stmt);
                    throw throwable;
                }
                this.closeStatement(stmt);
                return;
            }
            super.logSQLException(40000, LOG_CATEGORY, e);
            throw e;
            catch (Exception e2) {
                String failureMsg = MSG_MGR.getString("MSG_extractor_create_failure");
                this.taskNode.fireETLEngineLogEvent(failureMsg, 10000);
                Logger.printThrowable(10000, LOG_CATEGORY, this, this.DN + failureMsg, e2);
                throw e2;
            }
        }
        this.closeStatement(stmt);
        return;
    }

    private void dropTable(ETLTaskNode node, Connection con) throws BaseException, SQLException {
        Statement stmt = null;
        try {
            SQLPart checkTablePart = node.getStatement("checkTableExists");
            SQLPart dropSQLPart = node.getStatement("dropStatement");
            if (dropSQLPart == null) {
                return;
            }
            String dropMsg = MSG_MGR.getString("MSG_extractor_drop_attempt");
            node.fireETLEngineLogEvent(dropMsg, 10000);
            String dropSQL = dropSQLPart.getSQL();
            String checkSQL = checkTablePart.getSQL();
            String checkStmtMsg = MSG_MGR.getString("MSG_common_using_sql", checkSQL);
            String dropStmtMsg = MSG_MGR.getString("MSG_common_using_sql", dropSQL);
            Logger.print(10000, LOG_CATEGORY, this.DN + checkStmtMsg);
            node.fireETLEngineLogEvent(dropStmtMsg, 10000);
            Map attribMap = this.taskNode.getParent().getInputAttrMap();
            checkSQL = SQLUtils.replaceTableNameFromRuntimeArguments(checkSQL, attribMap);
            dropSQL = SQLUtils.replaceTableNameFromRuntimeArguments(dropSQL, attribMap);
            stmt = con.createStatement();
            if (this.isTableExists(con, checkSQL, node)) {
                stmt.executeUpdate(dropSQL);
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            String droppedMsg = MSG_MGR.getString("MSG_common_table_dropped");
            node.fireETLEngineLogEvent(droppedMsg, 10000);
            this.closeStatement(stmt);
        }
        catch (SQLException e) {
            if (this.isObjectDoesNotExistException(e)) {
                String tableExistsMsg = MSG_MGR.getString("MSG_extractor_drop_failure_table_nonexistent");
                this.taskNode.fireETLEngineLogEvent(tableExistsMsg, 30000);
                return;
            }
            super.logSQLException(40000, LOG_CATEGORY, e);
            throw e;
        }
        catch (Exception t) {
            Logger.printThrowable(40000, LOG_CATEGORY, this, "Unexpected error while dropping table.", t);
            throw new BaseException(t);
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    private ResultSet getSelectData(ETLTaskNode node) throws BaseException {
        ResultSet rs;
        PreparedStatement stmt = null;
        String selectStmt = null;
        try {
            SQLPart selectSQLPart = node.getStatement("selectStatement");
            if (selectSQLPart == null) {
                throw new ETLException(this.DN + "Missing required select SQLPart element");
            }
            selectStmt = selectSQLPart.getSQL();
            if (selectStmt == null) {
                throw new ETLException(this.DN + "Missing required select statement");
            }
            this.selectPoolName = selectSQLPart.getConnectionPoolName();
            this.srcPoolCon = this.getConnection(this.selectPoolName, node.getParent().getConnectionDefList());
            Logger.print(10000, LOG_CATEGORY, this.DN + " got source connection: " + this.srcPoolCon);
            String startMsg = MSG_MGR.getString("MSG_extractor_select_attempt");
            node.fireETLEngineLogEvent(startMsg, 10000);
            String showSqlMsg = MSG_MGR.getString("MSG_common_using_sql", selectStmt);
            node.fireETLEngineLogEvent(showSqlMsg, 10000);
            ArrayList paramList = new ArrayList();
            Map attribMap = this.taskNode.getParent().getInputAttrMap();
            String ps = SQLUtils.createPreparedStatement(selectStmt, attribMap, paramList);
            stmt = this.srcPoolCon.prepareStatement(ps);
            stmt.setFetchSize(this.batchSize);
            SQLUtils.populatePreparedStatement(stmt, attribMap, paramList);
            rs = stmt.executeQuery();
            if (rs == null) {
                throw new ETLException(this.DN + "Failed to get the ResultSet in " + LOG_CATEGORY + "; SQL execution failed");
            }
            String successMsg = MSG_MGR.getString("MSG_extractor_select_success");
            node.fireETLEngineLogEvent(successMsg, 10000);
        }
        catch (Exception e) {
            this.closeStatement(stmt);
            throw new BaseException("Failed to get the ResultSet for " + selectStmt, e);
        }
        return rs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertData(ResultSet rs, String insertStmt, Connection dbCon, List types, ETLTaskNode node) throws BaseException {
        ETLEngineContext context = node.getParent().getContext();
        ETLEngineContext.CollabStatistics stats = context.getStatistics();
        Object onePassFlagObj = node.getAttributeMap().getAttributeValue(KEY_ISONEPASS);
        boolean isOnePass = onePassFlagObj instanceof Boolean && (Boolean)onePassFlagObj != false;
        String jobQ = (String)node.getAttributeMap().getAttributeValue(KEY_JOBQUEUESIZE);
        int jobQueueSize = 2;
        try {
            jobQueueSize = Integer.parseInt(jobQ);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.jobQueue = new ArrayBlockingQueue<PreparedStatement>(jobQueueSize, true);
        this.preparedStmtPool = new ArrayBlockingQueue<PreparedStatement>(jobQueueSize);
        PreparedStatement prepStmt = null;
        try {
            ResultSetMetaData rsMeta = rs.getMetaData();
            if (rsMeta == null) {
                this.taskNode.fireETLEngineLogEvent("Unable to fetch source table metadata", 10000);
                throw new BaseException("Unable to fetch source table metadata");
            }
            String insertStartMsg = MSG_MGR.getString("MSG_extractor_insert_attempt");
            this.taskNode.fireETLEngineLogEvent(insertStartMsg, 10000);
            String prepStmtMsg = MSG_MGR.getString("MSG_extractor_show_prep_stmt", insertStmt);
            this.taskNode.fireETLEngineLogEvent(prepStmtMsg, 10000);
            prepStmt = dbCon.prepareStatement(insertStmt);
            if (prepStmt == null) {
                String errMsg = MSG_MGR.getString("MSG_extractor_invalid_insert");
                this.taskNode.fireETLEngineLogEvent(errMsg, 10000);
                throw new BaseException("Invalid insert statement.");
            }
            long localBatchSize = 0L;
            long insertCount = 0L;
            ExecutorService consumerThread = Executors.newSingleThreadExecutor();
            BatchProcessingConsumer consumer = new BatchProcessingConsumer();
            Future<Long> result = consumerThread.submit(consumer);
            while (true) {
                if (rs.next()) {
                } else {
                    if (this.batchSize > 1) {
                        consumer.stopConsuming();
                        if (localBatchSize != 0L) {
                            this.jobQueue.put(prepStmt);
                        }
                        consumerThread.shutdown();
                        insertCount += result.get().longValue();
                    }
                    stats.setRowsExtractedCount(node.getTableName(), insertCount);
                    if (isOnePass) {
                        this.updateInsertStats(node, insertCount);
                        ETLEngineExecEvent evnt = new ETLEngineExecEvent(4, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
                        this.taskNode.fireETLEngineExecutionEvent(evnt);
                    }
                    dbCon.commit();
                    String successMsg = MSG_MGR.getString("MSG_extractor_insert_success", new Long(insertCount));
                    this.taskNode.fireETLEngineLogEvent(successMsg, 20000);
                    this.closeResultSet(rs);
                    this.closeStatement(prepStmt);
                    return;
                }
                for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
                    Object value;
                    int colType = rsMeta.getColumnType(i);
                    switch (colType) {
                        case 93: {
                            value = rs.getTimestamp(i);
                            break;
                        }
                        default: {
                            value = rs.getObject(i);
                        }
                    }
                    if (!rs.wasNull() && value != null) {
                        prepStmt.setObject(i, value);
                        continue;
                    }
                    if (rsMeta.isNullable(i) != 1) throw new BaseException("Column " + rsMeta.getColumnType(i) + " is not nullable.");
                    prepStmt.setNull(i, StringUtil.getInt((String)types.get(i - 1)));
                }
                if (this.batchSize > 1) {
                    prepStmt.addBatch();
                    if (++localBatchSize != (long)this.batchSize) continue;
                    String engineState = (String)this.taskNode.getContext().getValue("engineState");
                    if (engineState != null && engineState.trim().equalsIgnoreCase("not-active")) {
                        prepStmt.close();
                        this.closeResultSet(rs);
                        this.closeStatement(prepStmt);
                        return;
                    }
                    this.jobQueue.put(prepStmt);
                    prepStmt = (PreparedStatement)this.preparedStmtPool.poll();
                    if (null == prepStmt) {
                        prepStmt = dbCon.prepareStatement(insertStmt);
                    }
                    localBatchSize = 0L;
                    continue;
                }
                prepStmt.executeUpdate();
                ++insertCount;
            }
        }
        catch (Exception se) {
            try {
                String errMsg = MSG_MGR.getString("MSG_common_sql_failed_show", se.getMessage());
                Logger.printThrowable(40000, LOG_CATEGORY, null, errMsg, se);
                this.taskNode.fireETLEngineLogEvent(errMsg, 40000);
                if (!isOnePass) throw new BaseException(se);
                this.updateInsertStats(node, 0L);
                ETLEngineExecEvent evnt = new ETLEngineExecEvent(5, node.getTableName(), "" + stats.getTableExecutionId(node.getTableName()));
                evnt.setCause(se);
                this.taskNode.fireETLEngineExecutionEvent(evnt);
                throw new BaseException(se);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(prepStmt);
                throw throwable;
            }
        }
    }

    private boolean isObjectAlreadyExistsException(SQLException e) {
        String sqlState = e.getSQLState();
        int vendorCode = e.getErrorCode();
        return "42710".equals(sqlState) || "42000".equals(sqlState) && 955 == vendorCode;
    }

    private boolean isObjectDoesNotExistException(SQLException e) {
        String sqlState = e.getSQLState();
        int vendorCode = e.getErrorCode();
        return "42704".equals(sqlState) || "42000".equals(sqlState) && 942 == vendorCode;
    }

    private void updateInsertStats(ETLTaskNode node, long insertCount) {
        ETLEngineContext context = node.getParent().getContext();
        ETLEngineContext.CollabStatistics stats = context.getStatistics();
        Timestamp endDate = new Timestamp(System.currentTimeMillis());
        stats.setTableFinishTime(node.getTableName(), endDate);
        stats.setRowsInsertedCount(node.getTableName(), insertCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BatchProcessingConsumer
    implements Callable<Long> {
        private AtomicBoolean stopFlag = new AtomicBoolean(false);

        private BatchProcessingConsumer() {
        }

        @Override
        public Long call() throws Exception {
            long insertCount = 0L;
            block8: while (true) {
                try {
                    while (!this.stopFlag.get()) {
                        PreparedStatement prepStmt = (PreparedStatement)Extractor.this.jobQueue.take();
                        if (prepStmt == null) continue;
                        int[] rows = null;
                        try {
                            rows = prepStmt.executeBatch();
                            insertCount += (long)rows.length;
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                        prepStmt.clearBatch();
                        if (Extractor.this.preparedStmtPool.offer(prepStmt)) continue;
                        try {
                            prepStmt.close();
                            continue block8;
                        }
                        catch (SQLException ex) {
                        }
                    }
                    break;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            int I = Extractor.this.jobQueue.size();
            for (int i = 0; i < I; ++i) {
                PreparedStatement prepStmt = (PreparedStatement)Extractor.this.jobQueue.poll();
                if (prepStmt == null) continue;
                int[] rows = null;
                try {
                    rows = prepStmt.executeBatch();
                    insertCount += (long)rows.length;
                    prepStmt.close();
                    continue;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            return insertCount;
        }

        public void stopConsuming() {
            this.stopFlag.set(true);
        }
    }
}

