/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ServerNotificationDispatcher;
import com.sun.jdmk.internal.ClassLogger;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class HeartBeatServerHandler {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.heartbeat", "HeartBeatServerHandler");
    private static final ClassLogger wpLogger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.heartbeat", "WaitPing");
    private MBeanServer mbs;
    private static String mbsId;
    private ServerNotificationDispatcher snd;
    private static long counter;
    private static String uniqueId;
    private Hashtable clients = new Hashtable();
    static /* synthetic */ Class class$com$sun$jdmk$comm$HeartBeatServerHandler;

    public HeartBeatServerHandler(MBeanServer mBeanServer, ServerNotificationDispatcher serverNotificationDispatcher) {
        if (logger.finerOn()) {
            logger.finer("Constructor", "Create HeartBeatServerHandler.");
        }
        this.mbs = mBeanServer;
        this.snd = serverNotificationDispatcher;
        try {
            mbsId = (String)mBeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
        }
        catch (Exception exception) {
            mbsId = "unknown";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pingHeartBeatServer(String string, int n, int n2, Long l) {
        HBClientInfo hBClientInfo;
        String string2 = string;
        if (string2 == null) {
            string2 = HeartBeatServerHandler.getSessionId();
        } else if (!string2.endsWith(mbsId)) {
            return null;
        }
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            hBClientInfo = (HBClientInfo)this.clients.get(string2);
        }
        if (hBClientInfo == null) {
            if (n <= 0) {
                return string2;
            }
            hBClientInfo = new HBClientInfo(string2, n, n2, l);
            hashtable = this.clients;
            synchronized (hashtable) {
                this.clients.put(string2, hBClientInfo);
            }
            hBClientInfo.startWaitPing();
            return string2;
        }
        if (n <= 0) {
            hashtable = this.clients;
            synchronized (hashtable) {
                this.clients.remove(string2);
            }
            hBClientInfo.stopWaitPing(-1);
            return string2;
        }
        hBClientInfo.setPeriod(n);
        hBClientInfo.setNRetries(n2);
        hBClientInfo.setNotifSessionId(l);
        hBClientInfo.startWaitPing();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(String string) {
        HBClientInfo hBClientInfo;
        Serializable serializable = this.clients;
        synchronized (serializable) {
            hBClientInfo = (HBClientInfo)this.clients.remove(string);
        }
        if (hBClientInfo != null && (serializable = hBClientInfo.getNotifSessionId()) != null) {
            this.snd.remoteTerminate((Long)serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupClientResources() {
        Hashtable hashtable = this.clients;
        synchronized (hashtable) {
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                HBClientInfo hBClientInfo = (HBClientInfo)enumeration.nextElement();
                hBClientInfo.stopWaitPing(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSessionId() {
        Class clazz = class$com$sun$jdmk$comm$HeartBeatServerHandler == null ? (class$com$sun$jdmk$comm$HeartBeatServerHandler = HeartBeatServerHandler.class$("com.sun.jdmk.comm.HeartBeatServerHandler")) : class$com$sun$jdmk$comm$HeartBeatServerHandler;
        synchronized (clazz) {
            uniqueId = counter++ + "_" + mbsId;
            return uniqueId;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        counter = 0L;
    }

    private class HBClientInfo {
        private String hbSessionId;
        private int period;
        private int nretries;
        private Long notifSessionId;
        private long timeout;
        private long newThreadEndTime;
        private WaitPing threadWaitPing;

        public HBClientInfo(String string, int n, int n2, Long l) {
            this.hbSessionId = string;
            this.period = n;
            this.nretries = n2;
            this.notifSessionId = l;
        }

        public int getPeriod() {
            return this.period;
        }

        public void setPeriod(int n) {
            this.period = n;
        }

        public int getNRetries() {
            return this.nretries;
        }

        public void setNRetries(int n) {
            this.nretries = n;
        }

        public Long getNotifSessionId() {
            return this.notifSessionId;
        }

        public void setNotifSessionId(Long l) {
            this.notifSessionId = l;
        }

        public synchronized void startWaitPing() {
            this.timeout = this.nretries == 0 ? (long)((double)this.period + 1.2 * (double)this.period) : (long)((double)this.period + 1.2 * (double)(this.period * this.nretries));
            this.newThreadEndTime = System.currentTimeMillis() + this.timeout;
            if (this.threadWaitPing == null || !this.threadWaitPing.isAlive()) {
                this.threadWaitPing = new WaitPing();
                this.threadWaitPing.start();
            }
        }

        public synchronized void stopWaitPing(int n) {
            if (this.threadWaitPing != null) {
                this.threadWaitPing.terminate(n);
                this.threadWaitPing = null;
            }
        }

        public void cleanupHBClientInfo() {
            HeartBeatServerHandler.this.cleanup(this.hbSessionId);
        }

        private class WaitPing
        extends Thread {
            private long actualThreadEndTime = 0L;
            private boolean toBeTerminated = false;
            private final int[] lock = new int[0];

            private WaitPing() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                while (!this.toBeTerminated) {
                    block6: {
                        if (HBClientInfo.this.timeout <= 0L) return;
                        try {
                            int[] nArray = this.lock;
                            // MONITORENTER : this.lock
                            this.lock.wait(HBClientInfo.this.timeout);
                            // MONITOREXIT : nArray
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.toBeTerminated) break block6;
                            return;
                        }
                    }
                    this.actualThreadEndTime = System.currentTimeMillis();
                    if (this.actualThreadEndTime <= HBClientInfo.this.newThreadEndTime || this.toBeTerminated) continue;
                    this.toBeTerminated = true;
                    if (wpLogger.finerOn()) {
                        wpLogger.finer("run", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " died.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void terminate(int n) {
                this.toBeTerminated = true;
                if (n == -1) {
                    if (wpLogger.finerOn()) {
                        wpLogger.finer("terminate", "Cleaning up: Client with SessionId = " + HBClientInfo.this.hbSessionId + " disconnected.");
                    }
                    HBClientInfo.this.cleanupHBClientInfo();
                    int[] nArray = this.lock;
                    synchronized (this.lock) {
                        this.lock.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                    }
                } else if (wpLogger.finerOn()) {
                    wpLogger.finer("terminate", "Ping stopped for client with SessionId = " + HBClientInfo.this.hbSessionId);
                }
            }
        }
    }
}

