/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.ActualMonitor;
import com.sun.jdmk.discovery.DiscoveryMonitorMBean;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

public class DiscoveryMonitor
extends NotificationBroadcasterSupport
implements Serializable,
DiscoveryMonitorMBean,
MBeanRegistration {
    private static final long serialVersionUID = 4303049868337627283L;
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    private String localClassName;
    private String dbgTag;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryMonitor");
    private ObjectName monitorObjectName;
    private MBeanServer cmf;
    private static final String sccs_id = "@(#)DiscoveryMonitor.java 4.32 04/05/12 SMI";
    private static int defaultMulticastPort = 9000;
    private static String defaultMulticastGroup = "224.224.224.224";
    private int multicastPort;
    private String multicastGroup;
    private transient ActualMonitor monitor;
    private transient Thread monitorThread;
    private volatile transient int state;
    private transient Vector listeners;
    private static final String GROUP = "group";
    private static final String PORT = "port";
    private InetAddress usrInet;

    public DiscoveryMonitor() {
        this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
        this.monitorObjectName = null;
        this.cmf = null;
        this.monitor = null;
        this.monitorThread = null;
        this.state = 1;
        this.listeners = new Vector();
        this.usrInet = null;
        this.multicastGroup = defaultMulticastGroup;
        this.multicastPort = defaultMulticastPort;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + this.multicastGroup + "'");
            logger.finer("constructor ", "Set port  to '" + this.multicastPort + "'");
        }
    }

    public DiscoveryMonitor(String string, int n) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
        this.monitorObjectName = null;
        this.cmf = null;
        this.monitor = null;
        this.monitorThread = null;
        this.state = 1;
        this.listeners = new Vector();
        this.usrInet = null;
        this.multicastGroup = string;
        this.multicastPort = n;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + string + "'");
            logger.finer("constructor ", "Set port  to '" + n + "'");
        }
    }

    public DiscoveryMonitor(String string, int n, InetAddress inetAddress) {
        this.dbgTag = this.localClassName = "com.sun.jdmk.discovery.DiscoveryMonitor";
        this.monitorObjectName = null;
        this.cmf = null;
        this.monitor = null;
        this.monitorThread = null;
        this.state = 1;
        this.listeners = new Vector();
        this.usrInet = null;
        this.multicastGroup = string;
        this.multicastPort = n;
        this.usrInet = inetAddress;
        if (logger.finerOn()) {
            logger.finer("constructor ", "Set group to '" + string + "'");
            logger.finer("constructor ", "Set port  to '" + n + "'");
            logger.finer("constructor ", "Set interface  to '" + inetAddress + "'");
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        String string;
        String string2;
        if (logger.finerOn()) {
            logger.finer("preRegister ", "object name   = " + objectName);
        }
        if ((string2 = objectName.getKeyProperty(GROUP)) != null) {
            this.multicastGroup = string2;
        }
        if (logger.finerOn()) {
            logger.finer("preRegister ", "Set group to '" + this.multicastGroup + "'");
        }
        if ((string = objectName.getKeyProperty(PORT)) != null) {
            this.multicastPort = Integer.parseInt(string);
        }
        if (logger.finerOn()) {
            logger.finer("preRegister ", "Set Port  to '" + this.multicastPort + "'");
        }
        this.monitorObjectName = objectName;
        return objectName;
    }

    public void postRegister(Boolean bl) {
        if (bl == Boolean.FALSE) {
            return;
        }
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
        System.runFinalization();
    }

    public void start() throws IOException {
        if (this.state == 1) {
            try {
                this.changeState(3);
                this.monitor = new ActualMonitor(this.multicastGroup, this.multicastPort, this);
                if (this.usrInet != null) {
                    this.monitor.setInterface(this.usrInet);
                    if (logger.finerOn()) {
                        logger.finer("start", "set to the interface " + this.usrInet);
                    }
                }
                this.monitorThread = this.cmf == null ? new Thread(this.monitor) : new Thread(this.monitor);
                this.monitorThread.setName("Multicast monitor");
            }
            catch (IOException iOException) {
                if (logger.finestOn()) {
                    logger.finest("start", iOException);
                }
                throw iOException;
            }
            catch (NullPointerException nullPointerException) {
                if (logger.finestOn()) {
                    logger.finest("start ", nullPointerException);
                }
                throw new IOException(nullPointerException.getMessage());
            }
            this.monitorThread.start();
        } else if (logger.finerOn()) {
            logger.finer("start ", "not OFFLINE ");
        }
    }

    public void stop() {
        if (this.state == 0) {
            this.changeState(2);
            this.monitor.stopMonitor();
        } else if (logger.finerOn()) {
            logger.finer("stop ", "not ONLINE");
        }
    }

    public Integer getState() {
        return new Integer(this.state);
    }

    public String getStateString() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "ONLINE";
                break;
            }
            case 1: {
                string = "OFFLINE";
                break;
            }
            case 2: {
                string = "STOPPING";
                break;
            }
            case 3: {
                string = "STARTING";
            }
        }
        return string;
    }

    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    public void setMulticastGroup(String string) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastGroup = string;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int n) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.multicastPort = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitState(int n, long l) {
        if (logger.finerOn()) {
            logger.finer("waitState", n + "(0on,1off,2st) TO=" + l + " ; current state = " + this.getStateString());
        }
        if (l < 0L) {
            return this.state == n;
        }
        boolean bl = this.state == n;
        long l2 = -1L;
        Date date = new Date(new Date().getTime() + l);
        while (!bl) {
            if (l != 0L && (l2 = date.getTime() - new Date().getTime()) <= 0L) {
                bl = true;
                break;
            }
            try {
                DiscoveryMonitor discoveryMonitor = this;
                synchronized (discoveryMonitor) {
                    if (l == 0L) {
                        if (logger.finerOn()) {
                            logger.finer("waitState", "Start waiting infinite, current state = " + this.state);
                        }
                        boolean bl2 = bl = this.state == n;
                        while (!bl) {
                            bl = this.state == n;
                            try {
                                this.wait(1000L);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        if (logger.finerOn()) {
                            logger.finer("waitState", "Start waiting " + l2 + " current state = " + this.state);
                        }
                        this.wait(l2);
                    }
                }
                bl = this.state == n;
            }
            catch (InterruptedException interruptedException) {
                bl = this.state == n;
            }
        }
        if (logger.finerOn()) {
            logger.finer("waitState", "End, TO=" + l2);
        }
        return this.state == n;
    }

    synchronized void changeState(int n) {
        if (this.state == n) {
            return;
        }
        int n2 = this.state;
        this.state = n;
        this.notifyAll();
    }
}

