/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading;

import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import java.io.IOException;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class BasicMBeanServerConnectionFactory
implements MBeanServerConnectionFactory {
    private final Subject subject;
    private final JMXConnector connector;
    private MBeanServerConnection connection;
    private boolean failed = false;
    private final NotificationBroadcasterSupport emitter;
    private final NotificationListener listener;

    public BasicMBeanServerConnectionFactory(JMXConnector jMXConnector, Subject subject) {
        this.connector = jMXConnector;
        this.subject = subject;
        this.connection = null;
        this.emitter = new NotificationBroadcasterSupport();
        this.listener = new NotificationListener(){

            public void handleNotification(Notification notification, Object object) {
                BasicMBeanServerConnectionFactory.this.handleConnectionNotification(notification, object);
            }
        };
        this.failed = false;
        if (jMXConnector != null) {
            this.connector.addConnectionNotificationListener(this.listener, null, jMXConnector);
        }
    }

    public synchronized JMXConnector getJMXConnector() {
        return this.connector;
    }

    public final Subject getDelegationSubject() {
        return this.subject;
    }

    public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
        if (this.failed) {
            throw new IOException("connection already failed");
        }
        if (this.connection == null) {
            this.connection = this.connector.getMBeanServerConnection(this.subject);
        }
        return this.connection;
    }

    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public String getConnectionId() throws IOException {
        if (this.failed) {
            throw new IOException("connection already failed");
        }
        return this.getJMXConnector().getConnectionId();
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL jMXServiceURL) throws IOException {
        return BasicMBeanServerConnectionFactory.newInstance(jMXServiceURL, null, null);
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        return BasicMBeanServerConnectionFactory.newInstance(jMXServiceURL, map, null);
    }

    public static MBeanServerConnectionFactory newInstance(JMXServiceURL jMXServiceURL, Map map, Subject subject) throws IOException {
        return BasicMBeanServerConnectionFactory.newInstance(JMXConnectorFactory.connect(jMXServiceURL, map), subject);
    }

    public static MBeanServerConnectionFactory newInstance(JMXConnector jMXConnector) {
        return BasicMBeanServerConnectionFactory.newInstance(jMXConnector, null);
    }

    public static MBeanServerConnectionFactory newInstance(JMXConnector jMXConnector, Subject subject) {
        return new BasicMBeanServerConnectionFactory(jMXConnector, subject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionNotification(Notification notification, Object object) {
        block9: {
            try {
                if (!"jmx.remote.connection.failed".equals(notification.getType())) break block9;
                BasicMBeanServerConnectionFactory basicMBeanServerConnectionFactory = this;
                synchronized (basicMBeanServerConnectionFactory) {
                    if (!this.failed && object == this.getJMXConnector()) {
                        this.failed = true;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.emitter.sendNotification(notification);
            }
        }
    }
}

