/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.agent.SnmpMibAgent;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpMibTree {
    private SnmpMibAgent defaultAgent = null;
    private TreeNode root = new TreeNode(-1L, null);

    public boolean isMibReferenced(SnmpMibAgent snmpMibAgent) {
        return this.root.isMibReferenced(snmpMibAgent);
    }

    public void setDefaultAgent(SnmpMibAgent snmpMibAgent) {
        this.defaultAgent = snmpMibAgent;
        this.root.agent = snmpMibAgent;
    }

    public SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    public void register(SnmpMibAgent snmpMibAgent) {
        this.root.registerNode(snmpMibAgent);
    }

    public void register(SnmpMibAgent snmpMibAgent, long[] lArray) {
        this.root.registerNode(lArray, 0, snmpMibAgent);
    }

    public SnmpMibAgent getAgentMib(SnmpOid snmpOid) {
        TreeNode treeNode = this.root.retrieveMatchingBranch(snmpOid.longValue(), 0);
        if (treeNode == null) {
            return this.defaultAgent;
        }
        if (treeNode.getAgentMib() == null) {
            return this.defaultAgent;
        }
        return treeNode.getAgentMib();
    }

    public void unregister(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) {
        for (int i = 0; i < snmpOidArray.length; ++i) {
            long[] lArray = snmpOidArray[i].longValue();
            TreeNode treeNode = this.root.retrieveMatchingBranch(lArray, 0);
            if (treeNode == null) continue;
            treeNode.removeAgent(snmpMibAgent);
        }
    }

    public void unregister(SnmpMibAgent snmpMibAgent) {
        this.root.removeAgentFully(snmpMibAgent);
    }

    final class TreeNode {
        private Vector children = new Vector();
        long nodeValue;
        protected SnmpMibAgent agent;
        private TreeNode parent;

        void registerNode(SnmpMibAgent snmpMibAgent) {
            long[] lArray = snmpMibAgent.getRootOid();
            this.registerNode(lArray, 0, snmpMibAgent);
        }

        TreeNode retrieveMatchingBranch(long[] lArray, int n) {
            TreeNode treeNode = this.retrieveChild(lArray, n);
            if (treeNode == null) {
                return this;
            }
            if (this.children.size() == 0) {
                return treeNode;
            }
            if (n + 1 == lArray.length) {
                return treeNode;
            }
            TreeNode treeNode2 = treeNode.retrieveMatchingBranch(lArray, n + 1);
            return treeNode2.agent == null ? this : treeNode2;
        }

        SnmpMibAgent getAgentMib() {
            return this.agent;
        }

        private TreeNode(long l, TreeNode treeNode) {
            this.nodeValue = l;
            this.parent = treeNode;
        }

        private boolean isMibReferenced(SnmpMibAgent snmpMibAgent) {
            if (this.agent == snmpMibAgent) {
                return true;
            }
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (!treeNode.isMibReferenced(snmpMibAgent)) continue;
                return true;
            }
            return false;
        }

        private void removeAgentFully(SnmpMibAgent snmpMibAgent) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                treeNode.removeAgentFully(snmpMibAgent);
            }
            this.removeAgent(snmpMibAgent);
        }

        private void removeAgent(SnmpMibAgent snmpMibAgent) {
            if (this.agent != snmpMibAgent) {
                return;
            }
            this.agent = null;
        }

        private void setAgent(SnmpMibAgent snmpMibAgent) {
            this.agent = snmpMibAgent;
        }

        private void registerNode(long[] lArray, int n, SnmpMibAgent snmpMibAgent) {
            if (n >= lArray.length) {
                return;
            }
            TreeNode treeNode = this.retrieveChild(lArray, n);
            if (treeNode == null) {
                long l = lArray[n];
                treeNode = new TreeNode(l, this);
                this.children.addElement(treeNode);
            }
            if (n == lArray.length - 1) {
                treeNode.setAgent(snmpMibAgent);
            } else {
                treeNode.registerNode(lArray, n + 1, snmpMibAgent);
            }
        }

        private TreeNode retrieveChild(long[] lArray, int n) {
            long l = lArray[n];
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = (TreeNode)enumeration.nextElement();
                if (!treeNode.match(l)) continue;
                return treeNode;
            }
            return null;
        }

        private final boolean match(long l) {
            return this.nodeValue == l;
        }
    }
}

