/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclEntryImpl
implements AclEntry,
Serializable {
    private static final long serialVersionUID = 356147207463306787L;
    private Principal princ = null;
    private boolean neg = false;
    private Vector permList = null;
    private Vector commList = null;

    private AclEntryImpl(AclEntryImpl aclEntryImpl) throws UnknownHostException {
        this.setPrincipal(aclEntryImpl.getPrincipal());
        this.permList = new Vector();
        this.commList = new Vector();
        Enumeration enumeration = aclEntryImpl.communities();
        while (enumeration.hasMoreElements()) {
            this.addCommunity((String)enumeration.nextElement());
        }
        enumeration = aclEntryImpl.permissions();
        while (enumeration.hasMoreElements()) {
            this.addPermission((Permission)enumeration.nextElement());
        }
        if (aclEntryImpl.isNegative()) {
            this.setNegativePermissions();
        }
    }

    public AclEntryImpl() {
        this.princ = null;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public AclEntryImpl(Principal principal) throws UnknownHostException {
        this.princ = principal;
        this.permList = new Vector();
        this.commList = new Vector();
    }

    public Object clone() {
        AclEntryImpl aclEntryImpl;
        try {
            aclEntryImpl = new AclEntryImpl(this);
        }
        catch (UnknownHostException unknownHostException) {
            aclEntryImpl = null;
        }
        return aclEntryImpl;
    }

    public boolean isNegative() {
        return this.neg;
    }

    public boolean addPermission(Permission permission) {
        if (this.permList.contains(permission)) {
            return false;
        }
        this.permList.addElement(permission);
        return true;
    }

    public boolean removePermission(Permission permission) {
        if (!this.permList.contains(permission)) {
            return false;
        }
        this.permList.removeElement(permission);
        return true;
    }

    public boolean checkPermission(Permission permission) {
        return this.permList.contains(permission);
    }

    public Enumeration permissions() {
        return this.permList.elements();
    }

    public void setNegativePermissions() {
        this.neg = true;
    }

    public Principal getPrincipal() {
        return this.princ;
    }

    public boolean setPrincipal(Principal principal) {
        if (this.princ != null) {
            return false;
        }
        this.princ = principal;
        return true;
    }

    public String toString() {
        return "AclEntry:" + ((Object)this.princ).toString();
    }

    public Enumeration communities() {
        return this.commList.elements();
    }

    public boolean addCommunity(String string) {
        if (this.commList.contains(string)) {
            return false;
        }
        this.commList.addElement(string);
        return true;
    }

    public boolean removeCommunity(String string) {
        if (!this.commList.contains(string)) {
            return false;
        }
        this.commList.removeElement(string);
        return true;
    }

    public boolean checkCommunity(String string) {
        return this.commList.contains(string);
    }
}

