/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpSession;

class SnmpSessionProvider {
    private SnmpSession fixSession;
    private SnmpSession session;
    private int peerVersion;
    private String dbgTag;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSessionProvider");

    public SnmpSessionProvider(SnmpPeer snmpPeer, SnmpSession snmpSession) {
        block2: {
            this.fixSession = null;
            this.session = null;
            this.peerVersion = 0;
            this.dbgTag = "SnmpSessionProvider";
            try {
                this.peerVersion = snmpPeer.getParams().getProtocolVersion();
                this.session = snmpSession;
                SnmpEngine snmpEngine = snmpSession.getEngine();
                snmpSession.setDefaultPeer(snmpPeer);
                snmpSession.snmpOptions.setPduFixedOnError(false);
                this.fixSession = new SnmpSession(snmpEngine, "Fixed error Snmp session", null);
                this.fixSession.setDefaultPeer(snmpPeer);
                this.fixSession.snmpOptions.setPduFixedOnError(true);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (!logger.finestOn()) break block2;
                logger.finest("SnmpSessionProvider", snmpStatusException);
            }
        }
    }

    SnmpSession getSession(int n) {
        if (logger.finestOn()) {
            logger.finest("getSession", "Manager protocol : " + n + "\nPeer protocol :" + this.peerVersion);
        }
        if (this.peerVersion == n) {
            return this.session;
        }
        if (this.peerVersion == 0) {
            if (logger.finestOn()) {
                logger.finest("getSession", "Return fixed session");
            }
            return this.fixSession;
        }
        return this.session;
    }

    SnmpSession getDefaultSession() {
        return this.session;
    }

    public synchronized void hideInvalidResponseError(boolean bl) {
        this.session.hideInvalidResponseError(bl);
        this.fixSession.hideInvalidResponseError(bl);
    }

    public synchronized boolean isInvalidResponseErrorHidden() {
        return this.session.isInvalidResponseErrorHidden();
    }
}

