/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.manager.MultiplexRequest;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpSendServer
extends Thread
implements Runnable {
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSendServer");
    private boolean tryMultiplexing = false;
    private int intervalRange = 5000;
    private Vector readyPool;
    private Vector assortedReqList = new Vector();
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpSendServer");
        this.snmpq = snmpQManager;
        this.start();
    }

    public final synchronized void activateMultiplex(boolean bl) {
        this.tryMultiplexing = bl;
    }

    public final synchronized boolean multiplex() {
        return this.tryMultiplexing;
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (logger.finerOn()) {
            logger.finer("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in send server");
                logger.finest("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (logger.finestOn()) {
                    logger.finest("run", "Exiting... Fatal error");
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Out of memory");
                continue;
            }
            catch (Error error) {
                if (logger.finestOn()) {
                    logger.finest("run", error);
                }
                throw error;
            }
            break;
        }
    }

    void fireRequest(SnmpRequest snmpRequest) {
        if (snmpRequest != null && snmpRequest.inProgress()) {
            if (logger.finerOn()) {
                logger.finer("fireRequest", "Firing request directly. -> " + snmpRequest.getRequestId());
            }
            snmpRequest.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            SnmpRequest snmpRequest = (SnmpRequest)vector.lastElement();
            if (snmpRequest != null && snmpRequest.inProgress()) {
                this.fireRequest(snmpRequest);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (logger.finerOn()) {
                logger.finer("prepareAndSendRequest", "Blocking for requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (logger.finestOn()) {
            logger.finest("prepareAndSendRequest", "Requests from a previous block left unprocessed. Will try again");
        }
        if (logger.finerOn()) {
            logger.finer("prepareAndSendRequest", "List of requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (!this.multiplex() || this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpRequest snmpRequest = (SnmpRequest)this.readyPool.lastElement();
                if (snmpRequest != null && snmpRequest.inProgress()) {
                    if (snmpRequest.allowMultiplex()) {
                        this.addToAssortedList(snmpRequest);
                    } else {
                        this.fireRequest(snmpRequest);
                    }
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.fireAssortedRequests();
            this.readyPool.removeAllElements();
        }
    }

    void fireAssortedRequests() {
        if (logger.finerOn()) {
            logger.finer("fireAssortedRequests", "Firing Assorted requests");
        }
        while (!this.assortedReqList.isEmpty()) {
            SimilarRequestList similarRequestList = (SimilarRequestList)this.assortedReqList.lastElement();
            similarRequestList.action();
            this.assortedReqList.removeElementAt(this.assortedReqList.size() - 1);
        }
    }

    void addToAssortedList(SnmpRequest snmpRequest) {
        SimilarRequestList similarRequestList;
        if (this.assortedReqList.isEmpty()) {
            SimilarRequestList similarRequestList2 = new SimilarRequestList(snmpRequest);
            this.assortedReqList.addElement(similarRequestList2);
            return;
        }
        Enumeration enumeration = this.assortedReqList.elements();
        while (enumeration.hasMoreElements()) {
            similarRequestList = (SimilarRequestList)enumeration.nextElement();
            if (!similarRequestList.belongsHere(snmpRequest)) continue;
            similarRequestList.addElement(snmpRequest);
            return;
        }
        similarRequestList = new SimilarRequestList(snmpRequest);
        this.assortedReqList.addElement(similarRequestList);
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        stringBuffer.append("RequestId/Options -> ");
        while (enumeration.hasMoreElements()) {
            object = (SnmpRequest)enumeration.nextElement();
            stringBuffer.append(((SnmpRequest)object).getRequestId() + "/" + ((SnmpRequest)object).getOptions() + " ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }

    private void takeAnap(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final class SimilarRequestList
    extends Vector {
        private static final long serialVersionUID = 7868956577078005552L;
        SnmpPeer _peer;
        SnmpSession _session;
        int _cmd;
        MultiplexRequest _currentMuxReq;

        SimilarRequestList(SnmpRequest snmpRequest) {
            this._peer = snmpRequest.getPeer();
            this._session = snmpRequest.getSnmpSession();
            this._cmd = snmpRequest.getCommand();
            this.addElement(snmpRequest);
        }

        public SnmpPeer getPeer() {
            return this._peer;
        }

        public SnmpSession getSession() {
            return this._session;
        }

        public int getCommand() {
            return this._cmd;
        }

        public boolean belongsHere(SnmpRequest snmpRequest) {
            if (this._cmd != snmpRequest.getCommand()) {
                return false;
            }
            return this._peer.equals(snmpRequest.getPeer()) && this._session.isEquivalent(snmpRequest.getSnmpSession());
        }

        public String describe() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this._peer.toString() + " -> ");
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(((SnmpRequest)this.elementData[i]).getRequestId() + " ");
            }
            return stringBuffer.toString();
        }

        void fireRequestDirect(SnmpRequest snmpRequest) {
            if (snmpRequest != null && snmpRequest.inProgress()) {
                if (logger.finerOn()) {
                    logger.finer("fireRequestDirect", "Firing request directly. -> " + snmpRequest.getRequestId());
                }
                snmpRequest.action();
            }
        }

        public void action() {
            if (logger.finerOn()) {
                logger.finer("action", "List of requests directed to peer : " + this.describe());
            }
            while (!this.isEmpty()) {
                SnmpRequest snmpRequest;
                if (this._currentMuxReq == null) {
                    if (this.size() < 2) {
                        this.fireRequestDirect((SnmpRequest)this.firstElement());
                        this.removeAllElements();
                        break;
                    }
                    this._currentMuxReq = new MultiplexRequest(this.getPeer(), this.getSession(), this.getCommand());
                }
                if (this._currentMuxReq.addRequest(snmpRequest = (SnmpRequest)this.lastElement())) {
                    --this.elementCount;
                    continue;
                }
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
            if (this._currentMuxReq != null) {
                this._currentMuxReq.action();
                this._currentMuxReq = null;
            }
        }
    }
}

