/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.management.snmp.SnmpEngineId;

public class SnmpUsmEnginePeer {
    SnmpEngineId authoritativeEngineId = null;
    private int authoritativeEngineBoots = 0;
    private int authoritativeEngineTime = 0;
    private long startTime = 0L;
    private int lastReceivedEngineTime = 0;

    SnmpUsmEnginePeer(SnmpEngineId snmpEngineId) {
        this.authoritativeEngineId = snmpEngineId;
    }

    public SnmpEngineId getAuthoritativeEngineId() {
        return this.authoritativeEngineId;
    }

    public int getAuthoritativeEngineBoots() {
        return this.authoritativeEngineBoots;
    }

    public synchronized int getAuthoritativeEngineTime() {
        if (this.authoritativeEngineTime == 0) {
            return 0;
        }
        long l = System.currentTimeMillis() / 1000L - this.startTime;
        if (l > Integer.MAX_VALUE) {
            this.startTime = System.currentTimeMillis() / 1000L;
            if (this.authoritativeEngineBoots != Integer.MAX_VALUE) {
                this.setAuthoritativeEngineBoots(this.authoritativeEngineBoots + 1);
            }
        }
        return this.authoritativeEngineTime + (int)(System.currentTimeMillis() / 1000L - this.startTime);
    }

    public synchronized int getAuthoritativeLastReceivedEngineTime() {
        return this.lastReceivedEngineTime;
    }

    public synchronized void reset() {
        this.setAuthoritativeEngineBoots(0);
        this.setAuthoritativeEngineTime(0);
        this.setAuthoritativeEngineLastReceivedTime(0);
    }

    synchronized void setAuthoritativeEngineBoots(int n) {
        this.authoritativeEngineBoots = n;
    }

    synchronized void setAuthoritativeEngineTime(int n) {
        this.startTime = System.currentTimeMillis() / 1000L;
        this.authoritativeEngineTime = n;
    }

    synchronized void setAuthoritativeEngineLastReceivedTime(int n) {
        this.lastReceivedEngineTime = n;
    }
}

