/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmImpl;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class SnmpUsmHmacAlgorithm
extends SnmpUsmAlgorithmImpl
implements SnmpUsmAuthAlgorithm {
    String mdName = null;
    MessageDigest innerMD = null;
    MessageDigest md = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmHmacAlgorithm");
    String dbgTag = "SnmpUsmHmacAlgorithm";

    protected SnmpUsmHmacAlgorithm(String string, String string2) {
        super(string);
        this.mdName = string2;
        try {
            this.innerMD = MessageDigest.getInstance(string2);
            this.md = MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (logger.finestOn()) {
                logger.finest("SnmpUsmHmacAlgorithm", noSuchAlgorithmException);
            }
            throw new IllegalArgumentException("No such algorithm: " + noSuchAlgorithmException);
        }
    }

    abstract int getBlockSize();

    abstract int getKeySize();

    public abstract int getDeltaSize();

    abstract int getPasswordToKeySize();

    public byte[] sign(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        int n3 = byArray.length;
        int n4 = this.getBlockSize();
        if (n3 > n4) {
            this.md.reset();
            this.md.update(byArray);
            byArray = this.md.digest();
            n3 = byArray.length;
        }
        byArray4 = new byte[n4];
        byArray5 = new byte[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            while (n2 < byArray.length) {
                byArray4[n2] = byArray[n2];
                byArray5[n2] = byArray[n2];
                ++n2;
            }
            byArray4[n2] = 0;
            byArray5[n2] = 0;
        }
        n2 = 0;
        while (n2 < 64) {
            int n5 = n2;
            byArray4[n5] = (byte)(byArray4[n5] ^ 0x36);
            int n6 = n2++;
            byArray5[n6] = (byte)(byArray5[n6] ^ 0x5C);
        }
        this.innerMD.reset();
        this.innerMD.update(byArray4);
        this.innerMD.update(byArray2, 0, n);
        byArray3 = this.innerMD.digest();
        this.md.reset();
        this.md.update(byArray5);
        this.md.update(byArray3);
        byArray3 = this.md.digest();
        byte[] byArray6 = new byte[12];
        for (int i = 0; i < 12; ++i) {
            byArray6[i] = byArray3[i];
        }
        return byArray6;
    }

    public boolean verify(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        int n2 = byArray3.length;
        byte[] byArray4 = this.sign(byArray, byArray2, n);
        int n3 = byArray4.length;
        if (n2 != n3) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray3[i] == byArray4[i]) continue;
            return false;
        }
        return true;
    }

    public String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = byArray;
        for (int i = 0; i < 16; ++i) {
            int n = byArray2[i] >>> 4 & 0xF;
            stringBuffer.append("0123456789ABCDEF".charAt(n));
            n = byArray2[i] & 0xF;
            stringBuffer.append("0123456789ABCDEF".charAt(n));
        }
        return stringBuffer.toString();
    }

    public byte[] password_to_key(String string) {
        int n = 0;
        this.md.reset();
        n = this.getPasswordToKeySize();
        return this.password_to_key(this.md, string, n);
    }

    public byte[] localizeAuthKey(byte[] byArray, SnmpEngineId snmpEngineId) {
        this.md.reset();
        this.md.update(byArray);
        this.md.update(snmpEngineId.getBytes());
        this.md.update(byArray);
        return this.md.digest();
    }

    public byte[] localizePrivKey(byte[] byArray, SnmpEngineId snmpEngineId, int n) {
        byte[] byArray2 = this.localizeAuthKey(byArray, snmpEngineId);
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = byArray2[i];
        }
        return byArray3;
    }

    public byte[] calculateAuthDelta(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.calculateDelta(byArray, byArray2, byArray3, this.getDeltaSize());
    }

    public byte[] calculatePrivDelta(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        return this.calculateDelta(byArray, byArray2, byArray3, n);
    }

    private byte[] calculateDelta(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        int n2;
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[n];
        int n3 = 0;
        if (byArray2.length > n) {
            byArray4 = new byte[byArray.length];
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray4[n3] = byArray[n3];
            }
            n2 = (n - 1) / n;
            for (n3 = 0; n3 < n2; ++n3) {
                this.md.reset();
                this.md.update(byArray4);
                this.md.update(byArray3);
                byArray4 = this.md.digest();
                for (int i = n3 * n; i < n * n3 + n; ++i) {
                    byArray5[i] = byArray4[i];
                    int n4 = i;
                    byArray5[n4] = (byte)(byArray5[n4] ^ byArray2[i]);
                }
            }
        } else {
            byArray4 = byArray;
        }
        this.md.reset();
        this.md.update(byArray4);
        this.md.update(byArray3);
        byArray4 = this.md.digest();
        for (n2 = n3 * n; n2 < n; ++n2) {
            byArray5[n2] = byArray4[n2];
            int n5 = n2;
            byArray5[n5] = (byte)(byArray5[n5] ^ byArray2[n2]);
        }
        return byArray5;
    }

    public byte[] calculateNewAuthKey(byte[] byArray, byte[] byArray2) {
        return this.calculateNewKey(byArray, byArray2, this.getDeltaSize());
    }

    public byte[] calculateNewPrivKey(byte[] byArray, byte[] byArray2, int n) {
        return this.calculateNewKey(byArray, byArray2, n);
    }

    private byte[] calculateNewKey(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[byArray.length];
        int n3 = 0;
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        for (n3 = 0; n3 < n; ++n3) {
            byArray5[n3] = byArray2[n3];
            byArray6[n3] = byArray2[n3 + n];
        }
        n3 = 0;
        if (byArray4.length > n) {
            n2 = (n - 1) / n;
            byArray3 = new byte[byArray.length];
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray3[n3] = byArray[n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.md.reset();
                this.md.update(byArray3);
                this.md.update(byArray5);
                byArray3 = this.md.digest();
                for (int i = n3 * n; i < n * n3 + n; ++i) {
                    byArray4[i] = byArray3[i];
                    int n4 = i;
                    byArray4[n4] = (byte)(byArray4[n4] ^ byArray6[i]);
                }
            }
        } else {
            byArray3 = byArray;
        }
        this.md.reset();
        this.md.update(byArray3);
        this.md.update(byArray5);
        byArray3 = this.md.digest();
        for (n2 = n3 * n; n2 < n; ++n2) {
            byArray4[n2] = byArray3[n2];
            int n5 = n2;
            byArray4[n5] = (byte)(byArray4[n5] ^ byArray6[n2]);
        }
        return byArray4;
    }

    private byte[] password_to_key(MessageDigest messageDigest, String string, int n) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = string.getBytes();
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < 0x100000; i += 64) {
            for (int j = 0; j < 64; ++j) {
                byArray[j] = byArray2[n3++ % n2];
            }
            messageDigest.update(byArray, 0, 64);
        }
        return messageDigest.digest();
    }
}

