/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.runtime.ejbproxy;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.ClassGenerationException;
import it.imolinfo.jbi4ejb.exception.EJBDeployException;
import it.imolinfo.jbi4ejb.exception.EJBInvokeException;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbSOAPExtensionsUtils;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.EJBClasses;
import it.imolinfo.jbi4ejb.webservice.generator.EJBUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.rmi.RMISecurityManager;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.codehaus.xfire.gen.Wsdl11Generator;
import org.omg.CORBA.Any;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.ObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EJBProxyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EJBProxyUtils.class);

    private EJBProxyUtils() {
    }

    public static EJBClasses createEJBClasses(File wsdlFile, Properties classesId, File tempDir, List<String> jarFilesName, String remoteInterfaceName, String portTypeName) throws EJBDeployException {
        if (!wsdlFile.exists()) {
            String msg = "no WSDL exists: " + wsdlFile;
            throw new EJBDeployException(msg);
        }
        File tempWSDLFile = Jbi4EjbSOAPExtensionsUtils.addSoapElements(wsdlFile);
        File sourceDir = new File(tempDir, "src");
        sourceDir.mkdir();
        LOG.debug("Generating classes from WSDL: " + tempWSDLFile.getAbsolutePath() + " in directory:" + sourceDir.getAbsolutePath());
        Wsdl11Generator gen = new Wsdl11Generator();
        gen.setWsdl(tempWSDLFile.getAbsolutePath());
        gen.setBinding("jaxb");
        gen.setOverwrite(true);
        gen.setOutputDirectory(sourceDir.getAbsolutePath());
        try {
            gen.setExplicitAnnotation(true);
            gen.generate();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        tempWSDLFile.delete();
        File classesDir = new File(tempDir, "classes");
        List<String> sources = it.imolinfo.jbi4ejb.webservice.generator.Util.findJavaSources(sourceDir.getAbsolutePath(), null);
        try {
            it.imolinfo.jbi4ejb.webservice.generator.Util.compileJavaClasses(sourceDir.getAbsolutePath(), classesDir.getAbsolutePath(), sources, jarFilesName, null);
        }
        catch (ClassGenerationException ex) {
            LOG.error(ex.getMessage());
            throw new EJBDeployException(ex);
        }
        String remoteInterfaceClassName = remoteInterfaceName;
        if (remoteInterfaceClassName == null) {
            remoteInterfaceClassName = EJBProxyUtils.findRemoteInterfaceCompleteClassName(classesDir.getAbsolutePath(), portTypeName);
        }
        Enumeration<java.lang.Object> classesToSerialize = classesId.keys();
        while (classesToSerialize.hasMoreElements()) {
            LOG.debug("Adding uid in class: " + classesToSerialize);
            String classToSer = (String)classesToSerialize.nextElement();
            java.lang.Object serNumber = classesId.get(classToSer);
            Long uid = null;
            uid = serNumber instanceof String ? new Long((String)serNumber) : (Long)serNumber;
            String classFileName = classesDir.getAbsolutePath() + File.separatorChar + classToSer.replace('.', File.separatorChar) + ".class";
            try {
                LOG.debug("Insert uid: " + uid + "in class: " + classFileName);
                it.imolinfo.jbi4ejb.webservice.generator.Util.tweakSerializableDecoration(classFileName, uid);
            }
            catch (ClassGenerationException e) {
                LOG.error(e.getMessage());
                throw new EJBDeployException(e);
            }
        }
        try {
            EJBUtils.tweakRemoteInterfaceGeneratedFromWSDL(remoteInterfaceClassName, classesDir.getAbsolutePath());
        }
        catch (ClassGenerationException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        try {
            it.imolinfo.jbi4ejb.webservice.generator.Util.tweakInterfaceClasses(remoteInterfaceClassName, classesDir.getAbsolutePath());
        }
        catch (ClassGenerationException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        EJBUtils.createStub(classesDir.getAbsolutePath(), remoteInterfaceClassName, jarFilesName);
        return new EJBClasses(classesDir.getAbsolutePath(), remoteInterfaceClassName);
    }

    public static String createEJBClasses(String wsdlPath, String remoteInterfaceClassName, String portTypeName, Properties classesId, List<String> jarFilesName) throws EJBDeployException {
        File tempDir;
        try {
            tempDir = EJBUtils.createTempDir();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        File wsdlFile = new File(wsdlPath);
        if (!wsdlFile.exists()) {
            String msg = "no WSDL exists: " + wsdlFile;
            throw new EJBDeployException(msg);
        }
        EJBClasses ejbClasses = EJBProxyUtils.createEJBClasses(wsdlFile, classesId, tempDir, jarFilesName, remoteInterfaceClassName, portTypeName);
        return ejbClasses.getEjbClassesPath();
    }

    public static java.lang.Object createStatelessEJBFromCorbaName(String corbaname, String remoteInterfaceName, ClassLoader ejbClassLoader, ORB orb) throws EJBDeployException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ejbClassLoader);
        Object home = orb.string_to_object(corbaname);
        if (home == null) {
            String msg = "Null object retrieved with corbaname: " + corbaname;
            throw new EJBDeployException(msg);
        }
        java.lang.Object remoteObjectBean = EJBProxyUtils.getEJBFromCorbaHomeObject(home, orb, remoteInterfaceName, ejbClassLoader);
        Thread.currentThread().setContextClassLoader(previousClassLoader);
        return remoteObjectBean;
    }

    public static java.lang.Object createStatelessEJBFromJNDI(String jndiName, Properties jndiParams, String remoteInterfaceName, ClassLoader ejbClassLoader) throws EJBDeployException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ejbClassLoader);
        InitialContext jndiContext = null;
        try {
            jndiContext = jndiParams == null ? new InitialContext() : new InitialContext(jndiParams);
        }
        catch (NamingException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        LOG.debug("jndiContext retrieved:" + jndiContext);
        ObjectImpl home = null;
        try {
            home = (ObjectImpl)jndiContext.lookup(jndiName);
        }
        catch (NamingException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        LOG.info("Home object found: " + home);
        ORB orb = home._orb();
        LOG.info("ORB found: " + orb);
        java.lang.Object remoteObjectBean = EJBProxyUtils.getEJBFromCorbaHomeObject((Object)home, orb, remoteInterfaceName, ejbClassLoader);
        Thread.currentThread().setContextClassLoader(previousClassLoader);
        return remoteObjectBean;
    }

    public static ObjectImpl createStatelessHomeFromJNDI(String jndiName, Properties jndiParams, String remoteInterfaceName, ClassLoader ejbClassLoader) throws EJBDeployException {
        InitialContext jndiContext = null;
        try {
            jndiContext = jndiParams == null ? new InitialContext() : new InitialContext(jndiParams);
        }
        catch (NamingException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        LOG.debug("jndiContext retrieved:" + jndiContext);
        ObjectImpl home = null;
        try {
            home = (ObjectImpl)jndiContext.lookup(jndiName);
        }
        catch (NamingException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        LOG.info("Home object found: " + home);
        return home;
    }

    public static java.lang.Object getEJBFromCorbaHomeObject(Object home, ORB orb, String remoteInterfaceName, ClassLoader ejbClassLoader) throws EJBDeployException {
        Any result = orb.create_any();
        NamedValue resultVal = orb.create_named_value("result", result, 2);
        Request createRequest = home._create_request(null, "create", orb.create_list(0), resultVal);
        String interfaceName = EJBProxyUtils.getInterfaceName(remoteInterfaceName);
        String interfaceId = EJBProxyUtils.getInterfaceId(remoteInterfaceName);
        TypeCode remoteInterfaceType = orb.create_interface_tc(interfaceId, interfaceName);
        createRequest.set_return_type(remoteInterfaceType);
        createRequest.invoke();
        result = createRequest.return_value();
        Object reference = result.extract_Object();
        Class<?> remoteClass = null;
        try {
            remoteClass = ejbClassLoader.loadClass(remoteInterfaceName);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        LOG.debug("Remote class: " + remoteClass);
        java.lang.Object remoteObjectBean = PortableRemoteObject.narrow((java.lang.Object)reference, remoteClass);
        return remoteObjectBean;
    }

    public static Class getInterfaceClass(String remoteInterfaceClassName, String wsdlPath, List<String> jarFilesName) throws EJBDeployException {
        File tempDir;
        try {
            tempDir = EJBUtils.createTempDir();
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        File wsdlFile = new File(wsdlPath);
        if (!wsdlFile.exists()) {
            String msg = "no WSDL exists: " + wsdlFile;
            throw new EJBDeployException(msg);
        }
        File sourceDir = new File(tempDir, "src");
        sourceDir.mkdir();
        Wsdl11Generator gen = new Wsdl11Generator();
        gen.setWsdl(wsdlFile.getAbsolutePath());
        gen.setOutputDirectory(sourceDir.getAbsolutePath());
        try {
            gen.generate();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        File classesDir = new File(tempDir, "classes");
        List<String> sources = it.imolinfo.jbi4ejb.webservice.generator.Util.findJavaSources(sourceDir.getAbsolutePath(), null);
        try {
            it.imolinfo.jbi4ejb.webservice.generator.Util.compileJavaClasses(sourceDir.getAbsolutePath(), classesDir.getAbsolutePath(), sources, jarFilesName, null);
        }
        catch (ClassGenerationException ex) {
            LOG.error(ex.getMessage());
            throw new EJBDeployException(ex);
        }
        try {
            it.imolinfo.jbi4ejb.webservice.generator.Util.tweakInterfaceClasses(remoteInterfaceClassName, classesDir.getAbsolutePath());
        }
        catch (ClassGenerationException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        URLClassLoader ejbClassesClassLoader = null;
        try {
            ejbClassesClassLoader = it.imolinfo.jbi4ejb.webservice.generator.Util.getURLClassLoader(classesDir.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        Class<?> myRemoteClass = null;
        try {
            myRemoteClass = ejbClassesClassLoader.loadClass(remoteInterfaceClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        return myRemoteClass;
    }

    public static java.lang.Object createStatelessEJBUsingRMIClassLoader(String corbaname, String remoteInterfaceName, Class myRemoteInterfaceClass, ORB orb) throws EJBDeployException {
        if (System.getProperty("java.security.policy") != null) {
            LOG.debug("Using security policy: " + System.getProperty("java.security.policy"));
        }
        RMISecurityManager rmiSecurityManager = new RMISecurityManager();
        System.setSecurityManager(rmiSecurityManager);
        Object ejbHome = orb.string_to_object(corbaname);
        LOG.debug("ejbHome: " + ejbHome);
        LOG.debug("ejbHome.class: " + ejbHome.getClass());
        Any result = orb.create_any();
        LOG.debug("result: " + result);
        NamedValue resultVal = orb.create_named_value("result", result, 2);
        Request createRequest = ejbHome._create_request(null, "create", orb.create_list(0), resultVal);
        String interfaceName = EJBProxyUtils.getInterfaceName(remoteInterfaceName);
        String interfaceId = EJBProxyUtils.getInterfaceId(remoteInterfaceName);
        TypeCode remoteInterfaceType = orb.create_interface_tc(interfaceId, interfaceName);
        createRequest.set_return_type(remoteInterfaceType);
        createRequest.invoke();
        result = createRequest.return_value();
        Object reference = result.extract_Object();
        LOG.debug("reference.class: " + reference.getClass());
        LOG.debug("GetCodebase: " + Util.getCodebase(ejbHome.getClass()));
        java.lang.Object remoteObjectBean = PortableRemoteObject.narrow((java.lang.Object)reference, (Class)myRemoteInterfaceClass);
        LOG.debug("remoteObjectBean found: " + remoteObjectBean);
        return remoteObjectBean;
    }

    public static String getInterfaceId(String completeClassName) {
        String id = "RMI:" + completeClassName + ":0000000000000000";
        return id;
    }

    public static String getInterfaceName(String completeClassName) {
        int lastDot = completeClassName.lastIndexOf(".");
        String className = completeClassName.substring(lastDot + 1, completeClassName.length());
        return className;
    }

    public static java.lang.Object invokeMethod(java.lang.Object remoteBean, Method method, java.lang.Object[] params, ClassLoader ejbClassLoader, ORB orb) throws EJBInvokeException, IllegalAccessException, InvocationTargetException {
        LOG.info("Invoking using ORB class: " + orb.getClass().getName());
        if (remoteBean == null) {
            String msg = "The bean is null";
            LOG.debug(msg);
            throw new EJBInvokeException(msg);
        }
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ejbClassLoader);
        java.lang.Object returnObj = method.invoke(remoteBean, params);
        Thread.currentThread().setContextClassLoader(previousClassLoader);
        return returnObj;
    }

    public static java.lang.Object invokeMethod(java.lang.Object remoteBean, String methodName, java.lang.Object[] params, ClassLoader ejbClassLoader, ORB orb) throws EJBInvokeException, IllegalAccessException, InvocationTargetException {
        Method method = EJBProxyUtils.getMethodFromName(remoteBean, methodName, params);
        return EJBProxyUtils.invokeMethod(remoteBean, method, params, ejbClassLoader, orb);
    }

    public static Method getMethodFromName(java.lang.Object remoteBean, String methodName, java.lang.Object[] params) throws EJBInvokeException {
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            parameterTypes[i] = params[i].getClass();
        }
        Method method = null;
        try {
            Class<?> objClass = remoteBean.getClass();
            method = objClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            LOG.error(e.getMessage());
            throw new EJBInvokeException(e);
        }
        return method;
    }

    public static String findRemoteInterfaceCompleteClassName(String sourcesDir, String className) throws EJBDeployException {
        LOG.debug("Looking for class: " + className + " in directory: " + sourcesDir);
        List<File> files = it.imolinfo.jbi4ejb.webservice.generator.Util.findFilesFromSourceDirectory(sourcesDir, className + ".class");
        if (files.size() != 1) {
            String msg = "Found: " + files.size() + " java sources with name: " + className + " in directoty: " + sourcesDir;
            LOG.error(msg);
            throw new EJBDeployException(msg);
        }
        LOG.debug("Found class: " + files.get(0).getAbsolutePath());
        LOG.debug("The sources directory is: " + sourcesDir);
        File myClassFile = files.get(0);
        String myClassFileAbsolutePath = myClassFile.getAbsolutePath();
        String relativeFileNamePath = myClassFileAbsolutePath.substring(sourcesDir.length() + 1, myClassFileAbsolutePath.length());
        relativeFileNamePath = relativeFileNamePath.replace(File.separatorChar, '.');
        relativeFileNamePath = relativeFileNamePath.substring(0, relativeFileNamePath.length() - ".class".length());
        LOG.debug("The remote interface class name is: " + relativeFileNamePath);
        return relativeFileNamePath;
    }
}

