/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.runtime.ejbproxy;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.EJBInvokeException;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.EJBProxyUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.omg.CORBA.ORB;

public class StatelessEJBProxy {
    private static final Logger LOG = LoggerFactory.getLogger(StatelessEJBProxy.class);
    private String remoteInterfaceClassName = null;
    private Object remoteBean = null;
    private ClassLoader ejbInvokeClassLoader = null;
    private ORB orb = null;
    private Class myRemoteInterface = null;

    private StatelessEJBProxy() {
    }

    public StatelessEJBProxy(String remoteInterfaceClassName, Object remoteBean, ClassLoader ejbInvokeClassLoader, ORB orb) {
        this.remoteInterfaceClassName = remoteInterfaceClassName;
        this.remoteBean = remoteBean;
        this.ejbInvokeClassLoader = ejbInvokeClassLoader;
        this.orb = orb;
    }

    public Object invokeMethod(String methodName, Object[] params) throws EJBInvokeException, IllegalAccessException, InvocationTargetException {
        if (LOG.isDebugEnabled()) {
            StringBuffer paramsString = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                paramsString.append("[" + params[i] + "]");
            }
            String msg = "EJB Invocation: interface:[" + this.remoteInterfaceClassName + "], method:[" + methodName + "]" + "params:" + paramsString;
            LOG.debug(msg);
        }
        return EJBProxyUtils.invokeMethod(this.remoteBean, methodName, params, this.ejbInvokeClassLoader, this.orb);
    }

    public Object invokeMethod(Method method, Object[] params) throws EJBInvokeException, IllegalAccessException, InvocationTargetException {
        if (LOG.isDebugEnabled()) {
            StringBuffer paramsString = new StringBuffer();
            for (int i = 0; i < params.length; ++i) {
                paramsString.append("[" + params[i] + "]");
            }
            String msg = "EJB Invocation: interface:[" + this.remoteInterfaceClassName + "], method:[" + method.getName() + "]" + "params:" + paramsString;
            LOG.debug(msg);
        }
        return EJBProxyUtils.invokeMethod(this.remoteBean, method, params, this.ejbInvokeClassLoader, this.orb);
    }

    public ORB getOrb() {
        return this.orb;
    }

    public void setRemoteInterfaceClass(Class myRemoteInterFace) {
        this.myRemoteInterface = myRemoteInterFace;
    }

    public Class getRemoteInterfaceClass() {
        return this.myRemoteInterface;
    }

    public String getRemoteInterfaceClassName() {
        return this.remoteInterfaceClassName;
    }

    public ClassLoader getEjbInvokeClassLoader() {
        return this.ejbInvokeClassLoader;
    }
}

