/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ini4j.AbstractBeanInvocationHandler;
import org.ini4j.Convert;
import org.ini4j.IniHandler;
import org.ini4j.IniParser;
import org.ini4j.InvalidIniFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ini
extends LinkedHashMap<String, Section> {
    private static final String OPERATOR = " = ";
    private static final char SUBST_CHAR = '$';
    private static final String SUBST_BEGIN = "${";
    private static final int SUBST_BEGIN_LEN = "${".length();
    private static final String SUBST_END = "}";
    private static final int SUBST_END_LEN = "}".length();
    private static final char SUBST_ESCAPE = '\\';
    private static final char SUBST_SEPARATOR = '/';
    private static final String SUBST_PROPERTY = "@prop";
    private static final String SUBST_ENVIRONMENT = "@env";
    private Map<Class, Object> _beans;

    public Ini() {
    }

    public Ini(Reader input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Ini(InputStream input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Ini(URL input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Section add(String name) {
        Section s = new Section(name);
        this.put(name, s);
        return s;
    }

    public Section remove(Section section) {
        return (Section)this.remove(section.getName());
    }

    public void store(OutputStream output) throws IOException {
        this.store(new OutputStreamWriter(output));
    }

    public void store(Writer output) throws IOException {
        PrintWriter pr = new PrintWriter(output);
        for (Section s : this.values()) {
            pr.print('[');
            pr.print(Convert.escape(s.getName()));
            pr.println(']');
            for (Map.Entry e : s.entrySet()) {
                pr.print(Convert.escape((String)e.getKey()));
                pr.print(OPERATOR);
                pr.println(Convert.escape((String)e.getValue()));
            }
            pr.println();
        }
        pr.flush();
    }

    public void load(InputStream input) throws IOException, InvalidIniFormatException {
        this.load(new InputStreamReader(input));
    }

    public void load(Reader input) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parse(input, (IniHandler)builder);
    }

    public void load(URL input) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parse(input, (IniHandler)builder);
    }

    public void storeToXML(OutputStream output) throws IOException {
        this.storeToXML(new OutputStreamWriter(output));
    }

    public void storeToXML(Writer output) throws IOException {
        PrintWriter pr = new PrintWriter(output);
        pr.println("<ini version='1.0'>");
        for (Section s : this.values()) {
            pr.print(" <section key='");
            pr.print(s.getName());
            pr.println("'>");
            for (Map.Entry e : s.entrySet()) {
                pr.print("  <option key='");
                pr.print((String)e.getKey());
                pr.print("' value='");
                pr.print((String)e.getValue());
                pr.println("'/>");
            }
            pr.println(" </section>");
        }
        pr.println("</ini>");
        pr.flush();
    }

    public void loadFromXML(InputStream input) throws IOException, InvalidIniFormatException {
        this.loadFromXML(new InputStreamReader(input));
    }

    public void loadFromXML(Reader input) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parseXML(input, (IniHandler)builder);
    }

    public void loadFromXML(URL input) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance().parseXML(input, (IniHandler)builder);
    }

    public <T> T to(Class<T> clazz) {
        Object bean;
        if (this._beans == null) {
            this._beans = new HashMap<Class, Object>();
            bean = null;
        } else {
            bean = this._beans.get(clazz);
        }
        if (bean == null) {
            bean = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new BeanInvocationHandler());
            this._beans.put(clazz, bean);
        }
        return clazz.cast(bean);
    }

    protected void resolve(StringBuilder buffer, Section owner) {
        int begin = -1;
        int end = -1;
        int i = buffer.indexOf(SUBST_BEGIN);
        while (i >= 0 && i + 2 <= buffer.length()) {
            if (i == 0 || buffer.charAt(i - 1) != '\\') {
                begin = i;
                end = buffer.indexOf(SUBST_END, i);
                if (end < 0) break;
                if (begin >= 0 && end > 0) {
                    String var = buffer.substring(begin + SUBST_BEGIN_LEN, end);
                    String group = null;
                    int sep = var.indexOf(47);
                    String value = null;
                    if (sep > 0) {
                        group = var.substring(0, sep);
                        var = var.substring(sep + 1);
                    }
                    if (var != null) {
                        if (group == null) {
                            value = owner.fetch(var);
                        } else if (SUBST_ENVIRONMENT.equals(group)) {
                            value = System.getenv(var);
                        } else if (SUBST_PROPERTY.equals(group)) {
                            value = System.getProperty(var);
                        } else {
                            owner = (Section)this.get(group);
                            if (owner != null) {
                                value = owner.fetch(var);
                            }
                        }
                    }
                    if (value != null) {
                        buffer.replace(begin, end + SUBST_END_LEN, value);
                    }
                }
            }
            i = buffer.indexOf(SUBST_BEGIN, i + 1);
        }
    }

    class Builder
    implements IniHandler {
        private Section currentSection;

        Builder() {
        }

        public void startIni() {
        }

        public void endIni() {
        }

        public void startSection(String sectionName) {
            Section s = (Section)Ini.this.get(sectionName);
            this.currentSection = s != null ? s : Ini.this.add(sectionName);
        }

        public void endSection() {
            this.currentSection = null;
        }

        public void handleOption(String name, String value) {
            this.currentSection.put(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BeanInvocationHandler
    extends AbstractBeanInvocationHandler {
        private Map<String, Object> _sectionBeans = new HashMap<String, Object>();

        BeanInvocationHandler() {
        }

        @Override
        protected Object getPropertySpi(String property, Class<?> clazz) {
            Section section;
            Object o = this._sectionBeans.get(property);
            if (o == null && (section = (Section)Ini.this.get(property)) != null) {
                o = section.to(clazz);
                this._sectionBeans.put(property, o);
            }
            return o;
        }

        @Override
        protected void setPropertySpi(String property, Object value, Class<?> clazz) {
            throw new UnsupportedOperationException("read only bean");
        }

        @Override
        protected boolean hasPropertySpi(String property) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Section
    extends LinkedHashMap<String, String> {
        private String _name;
        private Map<Class, Object> _beans;

        public Section(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public synchronized <T> T to(Class<T> clazz) {
            Object bean;
            if (this._beans == null) {
                this._beans = new HashMap<Class, Object>();
                bean = null;
            } else {
                bean = this._beans.get(clazz);
            }
            if (bean == null) {
                bean = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new BeanInvocationHandler());
                this._beans.put(clazz, bean);
            }
            return clazz.cast(bean);
        }

        public String fetch(Object key) {
            String value = (String)this.get(key);
            if (value != null && value.indexOf(36) >= 0) {
                StringBuilder buffer = new StringBuilder(value);
                Ini.this.resolve(buffer, this);
                value = buffer.toString();
            }
            return value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BeanInvocationHandler
        extends AbstractBeanInvocationHandler {
            BeanInvocationHandler() {
            }

            @Override
            protected Object getPropertySpi(String property, Class<?> clazz) {
                return Section.this.fetch(property);
            }

            @Override
            protected void setPropertySpi(String property, Object value, Class<?> clazz) {
                Section.this.put(property, value.toString());
            }

            @Override
            protected boolean hasPropertySpi(String property) {
                return Section.this.containsKey(property);
            }
        }
    }
}

