/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.swing.colorchooser.NamedColor;
import org.netbeans.swing.colorchooser.Palette;
import org.netbeans.swing.colorchooser.PredefinedPalette;

class RecentColors
implements Palette {
    private Palette palette;
    private boolean changed = true;
    Stack stack = new Stack();
    public static final String INNER_DELIMITER = "^$";
    public static final String OUTER_DELIMITER = "!*";
    static Map namedMap = null;
    private static RecentColors defaultInstance = null;

    private RecentColors() {
    }

    private Palette getWrapped() {
        if (this.changed || this.palette == null) {
            this.palette = this.createPalette();
            this.changed = false;
        }
        return this.palette;
    }

    public Color getColorAt(int n, int n2) {
        return this.getWrapped().getColorAt(n, n2);
    }

    public String getDisplayName() {
        try {
            return ResourceBundle.getBundle("org.netbeans.swing.colorchooser.Bundle").getString("recent");
        }
        catch (MissingResourceException missingResourceException) {
            return "Recent colors";
        }
    }

    public Dimension getSize() {
        Dimension dimension = ((PredefinedPalette)this.getWrapped()).calcSize();
        return dimension;
    }

    public void paintTo(Graphics graphics) {
        this.getWrapped().paintTo(graphics);
    }

    public String getNameAt(int n, int n2) {
        return this.getWrapped().getNameAt(n, n2);
    }

    void add(Color color) {
        if (color instanceof RecentColor) {
            return;
        }
        if (this.stack.indexOf(color) == -1) {
            String string = color instanceof PredefinedPalette.BasicNamedColor ? ((PredefinedPalette.BasicNamedColor)color).getDisplayName() : null;
            String string2 = color instanceof PredefinedPalette.BasicNamedColor ? ((PredefinedPalette.BasicNamedColor)color).toString() : null;
            RecentColor recentColor = new RecentColor(string, color.getRed(), color.getGreen(), color.getBlue(), string2);
            this.stack.push(recentColor);
            this.changed = true;
            this.palette = null;
            if (color instanceof NamedColor) {
                RecentColors.addToNameCache((NamedColor)color);
            }
            this.saveToPrefs();
        }
    }

    public void saveToPrefs() {
        Preferences preferences = this.getPreferences();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Stack stack = new Stack();
        stack.addAll(this.stack);
        while (!stack.isEmpty() && n < 64) {
            ++n;
            Color color = (Color)stack.pop();
            if (color instanceof DummyColor) break;
            String string = "null";
            if (color instanceof PredefinedPalette.BasicNamedColor) {
                PredefinedPalette.BasicNamedColor basicNamedColor = (PredefinedPalette.BasicNamedColor)color;
                string = basicNamedColor.getDisplayName();
            }
            if (string == "null") {
                string = null;
            }
            stringBuffer.append(string);
            stringBuffer.append(INNER_DELIMITER);
            stringBuffer.append(color.getRed());
            stringBuffer.append(INNER_DELIMITER);
            stringBuffer.append(color.getGreen());
            stringBuffer.append(INNER_DELIMITER);
            stringBuffer.append(color.getBlue());
            stringBuffer.append(INNER_DELIMITER);
            if (color instanceof PredefinedPalette.BasicNamedColor) {
                stringBuffer.append(color.toString());
            } else {
                stringBuffer.append('x');
            }
            stringBuffer.append(OUTER_DELIMITER);
        }
        preferences.put("recentColors", stringBuffer.toString());
    }

    static NamedColor findNamedColor(Color color) {
        if (namedMap == null) {
            return null;
        }
        NamedColor namedColor = (NamedColor)namedMap.get(new Integer(color.getRGB()));
        return namedColor;
    }

    static void addToNameCache(NamedColor namedColor) {
        if (namedMap == null) {
            namedMap = new HashMap(40);
        }
        namedMap.put(new Integer(namedColor.getRGB()), namedColor);
    }

    private Preferences getPreferences() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        return preferences.node("1.5");
    }

    public void loadFromPrefs() {
        Preferences preferences = this.getPreferences();
        String string = preferences.get("recentColors", null);
        this.stack = new Stack();
        Object[] objectArray = new Color[64];
        Arrays.fill(objectArray, new DummyColor());
        try {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, OUTER_DELIMITER);
                for (int i = 63; stringTokenizer.hasMoreTokens() && i >= 0; --i) {
                    String string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, INNER_DELIMITER);
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string3 = stringTokenizer2.nextToken();
                        if ("null".equals(string3)) {
                            string3 = null;
                        }
                        int n = Integer.parseInt(stringTokenizer2.nextToken());
                        int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                        int n3 = Integer.parseInt(stringTokenizer2.nextToken());
                        String string4 = stringTokenizer2.nextToken();
                        objectArray[i] = "x".equals(string4) ? new RecentColor(string3, n, n2, n3) : new RecentColor(string3, n, n2, n3, string4);
                        RecentColors.addToNameCache((NamedColor)objectArray[i]);
                    }
                }
            }
            this.stack.addAll(Arrays.asList(objectArray));
        }
        catch (Exception exception) {
            System.err.println("Error loading color preferences");
            exception.printStackTrace();
        }
    }

    private Palette createPalette() {
        NamedColor[] namedColorArray = this.stack.toArray(new PredefinedPalette.BasicNamedColor[0]);
        return new PredefinedPalette("", namedColorArray);
    }

    public static final RecentColors getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new RecentColors();
            defaultInstance.loadFromPrefs();
        }
        return defaultInstance;
    }

    private class DummyColor
    extends RecentColor {
        public DummyColor() {
            super(null, 0, 0, 0);
        }

        public String getDisplayName() {
            return null;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private class RecentColor
    extends PredefinedPalette.BasicNamedColor {
        String displayName;
        String toString;

        public RecentColor(String string, int n, int n2, int n3) {
            super(string, n, n2, n3);
            this.toString = null;
            this.displayName = string;
        }

        public RecentColor(String string, int n, int n2, int n3, String string2) {
            this(string, n, n2, n3);
            this.displayName = string;
            this.toString = string2;
        }

        public int compareTo(Object object) {
            return RecentColors.this.stack.indexOf(object) - RecentColors.this.stack.indexOf(this);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object object) {
            if (object instanceof Color) {
                Color color = (Color)object;
                return color.getRGB() == this.getRGB();
            }
            return false;
        }

        public int hashCode() {
            return this.getRGB();
        }

        public String toString() {
            if (this.toString != null) {
                return this.toString;
            }
            return "new java.awt.Color(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + ")";
        }
    }
}

