/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.MemberInfoObfuscator;

public class MemberInfoNameCollector
implements MemberInfoVisitor {
    private boolean allowAggressiveOverloading;
    private Map descriptorMap;

    public MemberInfoNameCollector(boolean bl, Map map) {
        this.allowAggressiveOverloading = bl;
        this.descriptorMap = map;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.collectName(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.collectName(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.collectName(libraryClassFile, libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.collectName(libraryClassFile, libraryMethodInfo);
    }

    private void collectName(ClassFile classFile, MemberInfo memberInfo) {
        String string = memberInfo.getName(classFile);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        String string2 = MemberInfoObfuscator.newMemberName(memberInfo);
        if (string2 != null) {
            Map map;
            String string3 = memberInfo.getDescriptor(classFile);
            if (!this.allowAggressiveOverloading) {
                string3 = string3.substring(0, string3.indexOf(41) + 1);
            }
            if ((map = MemberInfoObfuscator.retrieveNameMap(this.descriptorMap, string3)).get(string2) == null || MemberInfoObfuscator.hasFixedNewMemberName(memberInfo)) {
                map.put(string2, string);
            }
        }
    }
}

