/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.shrink.UsageMarker;

public class ClassFileShrinker
implements ClassFileVisitor,
MemberInfoVisitor,
AttrInfoVisitor {
    private UsageMarker usageMarker;
    private ConstantPoolRemapper constantPoolRemapper;
    private int[] cpIndexMap;

    public ClassFileShrinker(UsageMarker usageMarker, int n) {
        this.usageMarker = usageMarker;
        this.constantPoolRemapper = new ConstantPoolRemapper(n);
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.u2interfacesCount = this.shrinkCpIndexArray(programClassFile.constantPool, programClassFile.u2interfaces, programClassFile.u2interfacesCount);
        programClassFile.u2constantPoolCount = this.shrinkConstantPool(programClassFile.constantPool, programClassFile.u2constantPoolCount);
        programClassFile.u2fieldsCount = this.shrinkArray(programClassFile.fields, programClassFile.u2fieldsCount);
        programClassFile.u2methodsCount = this.shrinkArray(programClassFile.methods, programClassFile.u2methodsCount);
        programClassFile.u2attributesCount = this.shrinkArray(programClassFile.attributes, programClassFile.u2attributesCount);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
        this.constantPoolRemapper.setCpIndexMap(this.cpIndexMap);
        this.constantPoolRemapper.visitProgramClassFile(programClassFile);
        programClassFile.subClasses = this.shrinkToNewArray(programClassFile.subClasses);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        libraryClassFile.subClasses = this.shrinkToNewArray(libraryClassFile.subClasses);
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        programMemberInfo.u2attributesCount = this.shrinkArray(programMemberInfo.attributes, programMemberInfo.u2attributesCount);
        programMemberInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        innerClassesAttrInfo.u2numberOfClasses = this.shrinkArray(innerClassesAttrInfo.classes, innerClassesAttrInfo.u2numberOfClasses);
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        if (enclosingMethodAttrInfo.referencedMethodInfo != null && !this.usageMarker.isUsed(enclosingMethodAttrInfo.referencedMethodInfo)) {
            enclosingMethodAttrInfo.u2nameAndTypeIndex = 0;
            enclosingMethodAttrInfo.referencedMethodInfo = null;
        }
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.u2attributesCount = this.shrinkArray(codeAttrInfo.attributes, codeAttrInfo.u2attributesCount);
    }

    private int shrinkConstantPool(CpInfo[] cpInfoArray, int n) {
        int n2;
        if (this.cpIndexMap == null || this.cpIndexMap.length < n) {
            this.cpIndexMap = new int[n];
        }
        int n3 = 1;
        boolean bl = false;
        for (n2 = 1; n2 < n; ++n2) {
            this.cpIndexMap[n2] = n3;
            CpInfo cpInfo = cpInfoArray[n2];
            if (cpInfo != null) {
                bl = this.usageMarker.isUsed(cpInfo);
            }
            if (!bl) continue;
            cpInfoArray[n3++] = cpInfo;
        }
        for (n2 = n3; n2 < n; ++n2) {
            cpInfoArray[n2] = null;
        }
        return n3;
    }

    private int shrinkCpIndexArray(CpInfo[] cpInfoArray, int[] nArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.usageMarker.isUsed(cpInfoArray[nArray[n2]])) continue;
            nArray[n3++] = nArray[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            nArray[n2] = 0;
        }
        return n3;
    }

    private ClassFile[] shrinkToNewArray(ClassFile[] classFileArray) {
        if (classFileArray == null) {
            return null;
        }
        int n = this.shrinkArray(classFileArray, classFileArray.length);
        if (n == 0) {
            return null;
        }
        if (n == classFileArray.length) {
            return classFileArray;
        }
        ClassFile[] classFileArray2 = new ClassFile[n];
        System.arraycopy(classFileArray, 0, classFileArray2, 0, n);
        return classFileArray2;
    }

    private int shrinkArray(VisitorAccepter[] visitorAccepterArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!this.usageMarker.isUsed(visitorAccepterArray[n2])) continue;
            visitorAccepterArray[n3++] = visitorAccepterArray[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            visitorAccepterArray[n2] = null;
        }
        return n3;
    }
}

