/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.CollectionScanner;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.WebdavFileSet;
import org.apache.webdav.ant.taskdefs.WebdavMatchingTask;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.PropPatchMethod;

public class Proppatch
extends WebdavMatchingTask {
    private String locktoken = null;
    private List toSet = new ArrayList();
    private List toRemove = new ArrayList();
    private int count = 0;

    public void execute() throws BuildException {
        this.validate();
        try {
            if (!this.getFileSets().hasNext()) {
                this.log(this.getUrl().getURI(), 2);
                this.proppatch(this.getUrl(), this.getUrl().getURI());
            } else {
                this.log("at: " + this.getUrl(), this.ifVerbose());
                if (!this.getUrl().getPath().endsWith("/")) {
                    this.getUrl().setPath(this.getUrl().getPath() + "/");
                }
                Iterator i = this.getFileSets();
                while (i.hasNext()) {
                    this.proppatch((WebdavFileSet)i.next());
                }
                this.log("Properties set on " + this.count + (this.count == 1 ? " resource" : " resources") + " at " + this.getUrl(), this.count > 0 ? 2 : this.ifVerbose());
            }
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Can't proppatch!", e);
        }
    }

    protected void validate() {
        super.validate();
        Iterator i = this.toSet.iterator();
        while (i.hasNext()) {
            Set a = (Set)i.next();
            if (a.name != null) continue;
            throw new BuildException("Add must have name attribute.");
        }
        i = this.toRemove.iterator();
        while (i.hasNext()) {
            Remove r = (Remove)i.next();
            if (r.name != null) continue;
            throw new BuildException("Remove must have name attribute.");
        }
    }

    protected void proppatch(HttpURL url, String logName) throws IOException, HttpException {
        this.log(logName, this.ifVerbose());
        PropPatchMethod propPatch = new PropPatchMethod(url.getURI());
        if (this.locktoken != null) {
            Utils.generateIfHeader((HttpMethod)propPatch, this.locktoken);
        }
        int c = 1;
        Iterator i = this.toRemove.iterator();
        while (i.hasNext()) {
            Remove r = (Remove)i.next();
            propPatch.addPropertyToRemove(r.name, r.abbrev != null ? r.abbrev : "NS" + c++, r.namespace);
        }
        i = this.toSet.iterator();
        while (i.hasNext()) {
            Set a = (Set)i.next();
            propPatch.addPropertyToSet(a.name, a.getValue(), a.abbrev != null ? a.abbrev : "NS" + c++, a.namespace);
        }
        int status = this.getHttpClient().executeMethod((HttpMethod)propPatch);
        ++this.count;
        switch (status) {
            case 200: {
                break;
            }
            case 207: {
                Enumeration e = propPatch.getResponses();
                while (e.hasMoreElements()) {
                    ResponseEntity response = (ResponseEntity)e.nextElement();
                    if (response.getStatusCode() <= 400) continue;
                    throw Utils.makeBuildException("Error while PROPPATCH", propPatch.getResponses());
                }
                break;
            }
            default: {
                HttpException ex = new HttpException();
                ex.setReasonCode(status);
                throw ex;
            }
        }
    }

    protected void proppatch(WebdavFileSet fileSet) throws IOException, HttpException {
        CollectionScanner scanner = fileSet.getCollectionScanner(this.getProject(), this.getHttpClient(), this.getUrl());
        HttpURL baseUrl = scanner.getBaseURL();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            HttpURL url = Utils.createHttpURL(baseUrl, files[i]);
            this.proppatch(url, files[i]);
        }
        String[] colls = scanner.getIncludedDirectories();
        for (int i = 0; i < colls.length; ++i) {
            HttpURL url = Utils.createHttpURL(baseUrl, colls[i]);
            this.proppatch(url, colls[i]);
        }
    }

    public void setLocktoken(String token) {
        this.locktoken = token;
        if (!this.locktoken.startsWith("opaquelocktoken:")) {
            throw new BuildException("Invalid locktoken: " + token);
        }
    }

    public Set createSet() {
        Set add = new Set();
        this.toSet.add(add);
        return add;
    }

    public Remove createRemove() {
        Remove remove = new Remove();
        this.toRemove.add(remove);
        return remove;
    }

    public static class Remove {
        String name = "DAV:";
        String namespace;
        String abbrev = null;

        Remove() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setNamespaceprefix(String pfx) {
            this.abbrev = pfx;
        }
    }

    public class Set {
        String name = null;
        String namespace = "DAV:";
        String abbrev = null;
        String value = null;
        StringBuffer text = null;

        Set() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setNamespaceprefix(String pfx) {
            this.abbrev = pfx;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void addText(String text) {
            if (this.value != null) {
                throw new BuildException("Only one of nested text or value attribute is allowed.");
            }
            if (this.text == null) {
                this.text = new StringBuffer();
            }
            this.text.append(Proppatch.this.getProject().replaceProperties(text));
        }

        String getValue() {
            if (this.value != null) {
                return this.value;
            }
            if (this.text != null) {
                return this.text.toString();
            }
            throw new BuildException("Either one of nested text or value attribute must be set.");
        }
    }
}

