/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.parameter.AltRep;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.DelegatedFrom;
import net.fortuna.ical4j.model.parameter.DelegatedTo;
import net.fortuna.ical4j.model.parameter.Dir;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FbType;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Language;
import net.fortuna.ical4j.model.parameter.Member;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Range;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.SentBy;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;

public final class ParameterFactoryImpl
implements ParameterFactory {
    private static ParameterFactoryImpl instance = new ParameterFactoryImpl();
    private Map factories = new HashMap();

    private ParameterFactoryImpl() {
        this.factories.put("ALTREP", this.createAltRepFactory());
        this.factories.put("CN", this.createCnFactory());
        this.factories.put("CUTYPE", this.createCuTypeFactory());
        this.factories.put("DELEGATED-FROM", this.createDelegatedFromFactory());
        this.factories.put("DELEGATED-TO", this.createDelegatedToFactory());
        this.factories.put("DIR", this.createDirFactory());
        this.factories.put("ENCODING", this.createEncodingFactory());
        this.factories.put("FMTTYPE", this.createFmtTypeFactory());
        this.factories.put("FBTYPE", this.createFbTypeFactory());
        this.factories.put("LANGUAGE", this.createLanguageFactory());
        this.factories.put("MEMBER", this.createMemberFactory());
        this.factories.put("PARTSTAT", this.createPartStatFactory());
        this.factories.put("RANGE", this.createRangeFactory());
        this.factories.put("RELATED", this.createRelatedFactory());
        this.factories.put("RELTYPE", this.createRelTypeFactory());
        this.factories.put("ROLE", this.createRoleFactory());
        this.factories.put("RSVP", this.createRsvpFactory());
        this.factories.put("SENT-BY", this.createSentByFactory());
        this.factories.put("TZID", this.createTzIdFactory());
        this.factories.put("VALUE", this.createValueFactory());
    }

    private ParameterFactory createAltRepFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new AltRep(value);
            }
        };
    }

    private ParameterFactory createCnFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new Cn(value);
            }
        };
    }

    private ParameterFactory createCuTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                CuType parameter = new CuType(value);
                if (CuType.INDIVIDUAL.equals(parameter)) {
                    return CuType.INDIVIDUAL;
                }
                if (CuType.GROUP.equals(parameter)) {
                    return CuType.GROUP;
                }
                if (CuType.RESOURCE.equals(parameter)) {
                    return CuType.RESOURCE;
                }
                if (CuType.ROOM.equals(parameter)) {
                    return CuType.ROOM;
                }
                if (CuType.UNKNOWN.equals(parameter)) {
                    return CuType.UNKNOWN;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createDelegatedFromFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new DelegatedFrom(value);
            }
        };
    }

    private ParameterFactory createDelegatedToFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new DelegatedTo(value);
            }
        };
    }

    private ParameterFactory createDirFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new Dir(value);
            }
        };
    }

    private ParameterFactory createEncodingFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                Encoding parameter = new Encoding(value);
                if (Encoding.EIGHT_BIT.equals(parameter)) {
                    return Encoding.EIGHT_BIT;
                }
                if (Encoding.BASE64.equals(parameter)) {
                    return Encoding.BASE64;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createFmtTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new FmtType(value);
            }
        };
    }

    private ParameterFactory createFbTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                FbType parameter = new FbType(value);
                if (FbType.FREE.equals(parameter)) {
                    return FbType.FREE;
                }
                if (FbType.BUSY.equals(parameter)) {
                    return FbType.BUSY;
                }
                if (FbType.BUSY_TENTATIVE.equals(parameter)) {
                    return FbType.BUSY_TENTATIVE;
                }
                if (FbType.BUSY_UNAVAILABLE.equals(parameter)) {
                    return FbType.BUSY_UNAVAILABLE;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createLanguageFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new Language(value);
            }
        };
    }

    private ParameterFactory createMemberFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new Member(value);
            }
        };
    }

    private ParameterFactory createPartStatFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                PartStat parameter = new PartStat(value);
                if (PartStat.NEEDS_ACTION.equals(parameter)) {
                    return PartStat.NEEDS_ACTION;
                }
                if (PartStat.ACCEPTED.equals(parameter)) {
                    return PartStat.ACCEPTED;
                }
                if (PartStat.DECLINED.equals(parameter)) {
                    return PartStat.DECLINED;
                }
                if (PartStat.TENTATIVE.equals(parameter)) {
                    return PartStat.TENTATIVE;
                }
                if (PartStat.DELEGATED.equals(parameter)) {
                    return PartStat.DELEGATED;
                }
                if (PartStat.COMPLETED.equals(parameter)) {
                    return PartStat.COMPLETED;
                }
                if (PartStat.IN_PROCESS.equals(parameter)) {
                    return PartStat.IN_PROCESS;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createRangeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                Range parameter = new Range(value);
                if (Range.THISANDFUTURE.equals(parameter)) {
                    return Range.THISANDFUTURE;
                }
                if (Range.THISANDPRIOR.equals(parameter)) {
                    return Range.THISANDPRIOR;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createRelatedFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                Related parameter = new Related(value);
                if (Related.START.equals(parameter)) {
                    return Related.START;
                }
                if (Related.END.equals(parameter)) {
                    return Related.END;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createRelTypeFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                RelType parameter = new RelType(value);
                if (RelType.PARENT.equals(parameter)) {
                    return RelType.PARENT;
                }
                if (RelType.CHILD.equals(parameter)) {
                    return RelType.CHILD;
                }
                if (RelType.SIBLING.equals(parameter)) {
                    return RelType.SIBLING;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createRoleFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                Role parameter = new Role(value);
                if (Role.CHAIR.equals(parameter)) {
                    return Role.CHAIR;
                }
                if (Role.REQ_PARTICIPANT.equals(parameter)) {
                    return Role.REQ_PARTICIPANT;
                }
                if (Role.OPT_PARTICIPANT.equals(parameter)) {
                    return Role.OPT_PARTICIPANT;
                }
                if (Role.NON_PARTICIPANT.equals(parameter)) {
                    return Role.NON_PARTICIPANT;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createRsvpFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                Rsvp parameter = new Rsvp(value);
                if (Rsvp.TRUE.equals(parameter)) {
                    return Rsvp.TRUE;
                }
                if (Rsvp.FALSE.equals(parameter)) {
                    return Rsvp.FALSE;
                }
                return parameter;
            }
        };
    }

    private ParameterFactory createSentByFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new SentBy(value);
            }
        };
    }

    private ParameterFactory createTzIdFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                return new TzId(value);
            }
        };
    }

    private ParameterFactory createValueFactory() {
        return new ParameterFactory(){

            public Parameter createParameter(String name, String value) throws URISyntaxException {
                Value parameter = new Value(value);
                if (Value.BINARY.equals(parameter)) {
                    return Value.BINARY;
                }
                if (Value.BOOLEAN.equals(parameter)) {
                    return Value.BOOLEAN;
                }
                if (Value.CAL_ADDRESS.equals(parameter)) {
                    return Value.CAL_ADDRESS;
                }
                if (Value.DATE.equals(parameter)) {
                    return Value.DATE;
                }
                if (Value.DATE_TIME.equals(parameter)) {
                    return Value.DATE_TIME;
                }
                if (Value.DURATION.equals(parameter)) {
                    return Value.DURATION;
                }
                if (Value.FLOAT.equals(parameter)) {
                    return Value.FLOAT;
                }
                if (Value.INTEGER.equals(parameter)) {
                    return Value.INTEGER;
                }
                if (Value.PERIOD.equals(parameter)) {
                    return Value.PERIOD;
                }
                if (Value.RECUR.equals(parameter)) {
                    return Value.RECUR;
                }
                if (Value.TEXT.equals(parameter)) {
                    return Value.TEXT;
                }
                if (Value.TIME.equals(parameter)) {
                    return Value.TIME;
                }
                if (Value.URI.equals(parameter)) {
                    return Value.URI;
                }
                if (Value.UTC_OFFSET.equals(parameter)) {
                    return Value.UTC_OFFSET;
                }
                return parameter;
            }
        };
    }

    public static ParameterFactoryImpl getInstance() {
        return instance;
    }

    public Parameter createParameter(String name, String value) throws URISyntaxException {
        ParameterFactory factory = (ParameterFactory)this.factories.get(name);
        if (factory != null) {
            return factory.createParameter(name, value);
        }
        if (this.isExperimentalName(name)) {
            return new XParameter(name, value);
        }
        throw new IllegalArgumentException("Invalid parameter name: " + name);
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith("X-") && name.length() > "X-".length();
    }
}

