/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.util.PropertyValidator;

public class VAlarm
extends CalendarComponent {
    private static final long serialVersionUID = -8193965477414653802L;

    public VAlarm() {
        super("VALARM");
    }

    public VAlarm(PropertyList properties) {
        super("VALARM", properties);
    }

    public VAlarm(DateTime trigger) {
        this();
        this.getProperties().add(new Trigger(trigger));
    }

    public VAlarm(Dur trigger) {
        this();
        this.getProperties().add(new Trigger(trigger));
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("ACTION", this.getProperties());
        PropertyValidator.getInstance().assertOne("TRIGGER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("REPEAT", this.getProperties());
        try {
            PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
            PropertyValidator.getInstance().assertNone("REPEAT", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertOne("DURATION", this.getProperties());
            PropertyValidator.getInstance().assertOne("REPEAT", this.getProperties());
        }
        Action action = this.getAction();
        if (Action.AUDIO.equals(action)) {
            this.validateAudio();
        } else if (Action.DISPLAY.equals(action)) {
            this.validateDisplay();
        } else if (Action.EMAIL.equals(action)) {
            this.validateEmail();
        } else if (Action.PROCEDURE.equals(action)) {
            this.validateProcedure();
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    private void validateAudio() throws ValidationException {
        PropertyValidator.getInstance().assertOneOrLess("ATTACH", this.getProperties());
    }

    private void validateDisplay() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DESCRIPTION", this.getProperties());
    }

    private void validateEmail() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOne("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", this.getProperties());
    }

    private void validateProcedure() throws ValidationException {
        PropertyValidator.getInstance().assertOne("ATTACH", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
    }

    public final Action getAction() {
        return (Action)this.getProperty("ACTION");
    }

    public final Trigger getTrigger() {
        return (Trigger)this.getProperty("TRIGGER");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final Repeat getRepeat() {
        return (Repeat)this.getProperty("REPEAT");
    }

    public final Attach getAttachment() {
        return (Attach)this.getProperty("ATTACH");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }
}

