/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Iso8601;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Dates;
import net.fortuna.ical4j.util.PropertyValidator;

public class VEvent
extends CalendarComponent {
    private static final long serialVersionUID = 2547948989200697335L;
    private ComponentList alarms;

    public VEvent() {
        super("VEVENT");
        this.alarms = new ComponentList();
        this.getProperties().add(new DtStamp());
    }

    public VEvent(PropertyList properties) {
        super("VEVENT", properties);
        this.alarms = new ComponentList();
    }

    public VEvent(PropertyList properties, ComponentList alarms) {
        super("VEVENT", properties);
        this.alarms = alarms;
    }

    public VEvent(Date start, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Date end, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new DtEnd(end));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Dur duration, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Duration(duration));
        this.getProperties().add(new Summary(summary));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        b.append(this.getProperties());
        b.append(this.getAlarms());
        b.append("END");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (component instanceof VAlarm) continue;
            throw new ValidationException("Component [" + component.getName() + "] may not occur in VEVENT");
        }
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        Status status = (Status)this.getProperty("STATUS");
        if (!(status == null || Status.VEVENT_TENTATIVE.equals(status) || Status.VEVENT_CONFIRMED.equals(status) || Status.VEVENT_CANCELLED.equals(status))) {
            throw new ValidationException("Status property [" + status.toString() + "] is not applicable for VEVENT");
        }
        try {
            PropertyValidator.getInstance().assertNone("DTEND", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        }
        if (this.getProperty("DTEND") != null) {
            Parameter value;
            DtStart start = (DtStart)this.getProperty("DTSTART");
            DtEnd end = (DtEnd)this.getProperty("DTEND");
            if (start != null && (value = start.getParameter("VALUE")) != null && !value.equals(end.getParameter("VALUE"))) {
                throw new ValidationException("Property [DTEND] must have the same [VALUE] as [DTSTART]");
            }
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd) {
        return this.getConsumedTime(rangeStart, rangeEnd, true);
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd, boolean normalise) {
        PeriodList periods = new PeriodList();
        if (Transp.TRANSPARENT.equals(this.getProperty("TRANSP"))) {
            return periods;
        }
        DtStart start = (DtStart)this.getProperty("DTSTART");
        DtEnd end = (DtEnd)this.getProperty("DTEND");
        Duration duration = (Duration)this.getProperty("DURATION");
        if (start == null || duration == null && end == null) {
            return periods;
        }
        Dur rDuration = duration == null ? new Dur(start.getDate(), end.getDate()) : duration.getDuration();
        DateTime adjustedRangeStart = new DateTime(rangeStart);
        ((Iso8601)adjustedRangeStart).setTime(rDuration.negate().getTime(rangeStart).getTime());
        PropertyList rDates = this.getProperties("RDATE");
        Iterator i = rDates.iterator();
        while (i.hasNext()) {
            RDate rdate = (RDate)i.next();
            if (!Value.PERIOD.equals(rdate.getParameter("VALUE"))) continue;
            Iterator j = rdate.getPeriods().iterator();
            while (j.hasNext()) {
                Period period = (Period)j.next();
                if (!period.getStart().before(rangeEnd) || !period.getEnd().after(rangeStart)) continue;
                periods.add(period);
            }
        }
        PropertyList rRules = this.getProperties("RRULE");
        Iterator i2 = rRules.iterator();
        while (i2.hasNext()) {
            RRule rrule = (RRule)i2.next();
            DateList startDates = rrule.getRecur().getDates(start.getDate(), adjustedRangeStart, rangeEnd, (Value)start.getParameter("VALUE"));
            for (int j = 0; j < startDates.size(); ++j) {
                Date startDate = (Date)startDates.get(j);
                periods.add(new Period(new DateTime(startDate), rDuration));
            }
        }
        if (start.getDate().before(rangeEnd)) {
            Period period;
            if (end != null && end.getDate().after(rangeStart)) {
                periods.add(new Period(new DateTime(start.getDate()), new DateTime(end.getDate())));
            } else if (duration != null && (period = new Period(new DateTime(start.getDate()), duration.getDuration())).getEnd().after(rangeStart)) {
                periods.add(period);
            }
        }
        PropertyList exDates = this.getProperties("EXDATE");
        Iterator i3 = exDates.iterator();
        while (i3.hasNext()) {
            ExDate exDate = (ExDate)i3.next();
            Iterator j = periods.iterator();
            while (j.hasNext()) {
                Period period = (Period)j.next();
                if (!exDate.getDates().contains(period.getStart()) && !exDate.getDates().contains(new Date(period.getStart()))) continue;
                j.remove();
            }
        }
        PropertyList exRules = this.getProperties("EXRULE");
        PeriodList exPeriods = new PeriodList();
        Iterator i4 = exRules.iterator();
        while (i4.hasNext()) {
            ExRule exrule = (ExRule)i4.next();
            DateList startDates = exrule.getRecur().getDates(start.getDate(), rangeStart, rangeEnd, (Value)start.getParameter("VALUE"));
            Iterator j = startDates.iterator();
            while (j.hasNext()) {
                Date startDate = (Date)j.next();
                exPeriods.add(new Period(new DateTime(startDate), rDuration));
            }
        }
        if (!exPeriods.isEmpty()) {
            periods = periods.subtract(exPeriods);
        }
        if (!periods.isEmpty() && normalise) {
            return periods.normalise();
        }
        return periods;
    }

    public final Clazz getClassification() {
        return (Clazz)this.getProperty("CLASS");
    }

    public final Created getCreated() {
        return (Created)this.getProperty("CREATED");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final Geo getGeographicPos() {
        return (Geo)this.getProperty("GEO");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final Location getLocation() {
        return (Location)this.getProperty("LOCATION");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final Priority getPriority() {
        return (Priority)this.getProperty("PRIORITY");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Sequence getSequence() {
        return (Sequence)this.getProperty("SEQUENCE");
    }

    public final Status getStatus() {
        return (Status)this.getProperty("STATUS");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }

    public final Transp getTransparency() {
        return (Transp)this.getProperty("TRANSP");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final RecurrenceId getRecurrenceId() {
        return (RecurrenceId)this.getProperty("RECURRENCE-ID");
    }

    public final DtEnd getEndDate() {
        return this.getEndDate(true);
    }

    public final DtEnd getEndDate(boolean deriveFromDuration) {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtEnd == null && deriveFromDuration && this.getDuration() != null) {
            DtStart dtStart = this.getStartDate();
            Duration vEventDuration = this.getDuration();
            dtEnd = new DtEnd(Dates.getInstance(vEventDuration.getDuration().getTime(dtStart.getDate()), (Value)dtStart.getParameter("VALUE")));
            if (dtStart.isUtc()) {
                dtEnd.setUtc(true);
            }
        }
        return dtEnd;
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }
}

