/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.el;

import org.netbeans.microedition.databinding.el.Logger;

public class Coercions {
    private static final Integer ZERO = new Integer(0);
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    private static String coerceObjectToString(Object pValue, Logger pLogger) {
        if (pValue == null) {
            return "";
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        try {
            return pValue.toString();
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError("toString", exc, pValue.getClass().getName());
            }
            return "";
        }
    }

    public static Object coerceObjectToPrimitiveNumber(Object pValue, Class pClass, Logger pLogger) {
        if (pValue == null || "".equals(pValue)) {
            return Coercions.coerceNumberToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue instanceof Character) {
            char val = ((Character)pValue).charValue();
            return Coercions.coerceNumberToPrimitiveNumber(new Short((short)val), pClass);
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingError()) {
                pLogger.logError("boolean2number", pValue, pClass.getName());
            }
            return Coercions.coerceNumberToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue.getClass() == pClass) {
            return pValue;
        }
        if (Coercions.isInstanceOfNumber(pValue)) {
            return Coercions.coerceNumberToPrimitiveNumber(pValue, pClass);
        }
        if (pValue instanceof String) {
            try {
                return Coercions.coerceStringToPrimitiveNumber((String)pValue, pClass);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError("string2number", (String)pValue, pClass.getName());
                }
                return Coercions.coerceNumberToPrimitiveNumber(ZERO, pClass);
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError("2number", pValue.getClass().getName(), pClass.getName());
        }
        return Coercions.coerceLongToPrimitiveNumber(0L, pClass);
    }

    static Object coerceLongToPrimitiveNumber(long pValue, Class pClass) {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)pValue);
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)pValue);
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)pValue);
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(pValue);
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(pValue);
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(pValue);
        }
        return ZERO;
    }

    private static Object coerceNumberToPrimitiveNumber(Object pValue, Class pClass) {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(Coercions.byteValue(pValue));
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(Coercions.shortValue(pValue));
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(Coercions.intValue(pValue));
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(Coercions.longValue(pValue));
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(Coercions.floatValue(pValue));
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(Coercions.doubleValue(pValue));
        }
        return ZERO;
    }

    private static Object coerceStringToPrimitiveNumber(String pValue, Class pClass) {
        if (pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte(Byte.parseByte(pValue));
        }
        if (pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(Short.parseShort(pValue));
        }
        if (pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(Integer.parseInt(pValue));
        }
        if (pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(Long.parseLong(pValue));
        }
        if (pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(Float.parseFloat(pValue));
        }
        if (pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(Double.parseDouble(pValue));
        }
        return new Integer(0);
    }

    public static Boolean coerceObjectToBoolean(Object pValue, Logger pLogger) {
        if (pValue == null || "".equals(pValue)) {
            return Boolean.FALSE;
        }
        if (pValue instanceof Boolean) {
            return (Boolean)pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            return "true".equalsIgnoreCase(str) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError("2boolean", pValue.getClass().getName());
        }
        return Boolean.TRUE;
    }

    private static double operateArithm(double left, double right, int operator) {
        switch (operator) {
            case 43: {
                return left + right;
            }
            case 45: {
                return left - right;
            }
            case 42: {
                return left * right;
            }
        }
        throw new IllegalStateException();
    }

    private static long operateArithm(long left, long right, int operator) {
        switch (operator) {
            case 43: {
                return left + right;
            }
            case 45: {
                return left - right;
            }
            case 42: {
                return left * right;
            }
        }
        throw new IllegalStateException();
    }

    public static Object applyArithmeticOperator(Object pLeft, Object pRight, int pOperator, Logger pLogger) {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning("arithOpNull", String.valueOf(pOperator));
            }
            return ZERO;
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pLeft) || Coercions.isFloatingPointString(pRight)) {
            double left = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            double right = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            return new Double(Coercions.operateArithm(left, right, pOperator));
        }
        long left = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
        long right = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
        return new Long(Coercions.operateArithm(left, right, pOperator));
    }

    private static boolean operateRelational(String left, String right, int operator) {
        switch (operator) {
            case 60: {
                return left.compareTo(right) < 0;
            }
            case 62: {
                return left.compareTo(right) > 0;
            }
            case 108: {
                return left.compareTo(right) >= 0;
            }
            case 103: {
                return left.compareTo(right) <= 0;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean operateRelational(long left, long right, int operator) {
        switch (operator) {
            case 60: {
                return left < right;
            }
            case 62: {
                return left > right;
            }
            case 108: {
                return left >= right;
            }
            case 103: {
                return left <= right;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean operateRelational(double left, double right, int operator) {
        switch (operator) {
            case 60: {
                return left < right;
            }
            case 62: {
                return left > right;
            }
            case 108: {
                return left >= right;
            }
            case 103: {
                return left <= right;
            }
        }
        throw new IllegalStateException();
    }

    public static Boolean applyRelationalOperator(Object pLeft, Object pRight, int pOperator, Logger pLogger) {
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double left = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            double right = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            return Coercions.operateRelational(left, right, pOperator) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long left = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
            long right = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
            return Coercions.operateRelational(left, right, pOperator) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String right;
            String left = Coercions.coerceObjectToString(pLeft, pLogger);
            return Coercions.operateRelational(left, right = Coercions.coerceObjectToString(pRight, pLogger), pOperator) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    private static Boolean operateEquality(boolean value, int operator) {
        switch (operator) {
            case 61: {
                return value ? Boolean.TRUE : Boolean.FALSE;
            }
            case 33: {
                return !value ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw new IllegalStateException();
    }

    public static Boolean applyEqualityOperator(Object pLeft, Object pRight, int pOperator, Logger pLogger) {
        if (pLeft == pRight) {
            return Coercions.operateEquality(true, pOperator);
        }
        if (pLeft == null || pRight == null) {
            return Coercions.operateEquality(false, pOperator);
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double left = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            double right = Coercions.doubleValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double, pLogger));
            return Coercions.operateEquality(left == right, pOperator);
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long left = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pLeft, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
            long right = Coercions.longValue(Coercions.coerceObjectToPrimitiveNumber(pRight, class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long, pLogger));
            return Coercions.operateEquality(left == right, pOperator);
        }
        if (pLeft instanceof Boolean || pRight instanceof Boolean) {
            boolean right;
            boolean left = Coercions.coerceObjectToBoolean(pLeft, pLogger);
            return Coercions.operateEquality(left == (right = Coercions.coerceObjectToBoolean(pRight, pLogger).booleanValue()), pOperator);
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceObjectToString(pLeft, pLogger);
            String right = Coercions.coerceObjectToString(pRight, pLogger);
            return Coercions.operateEquality(left.equals(right), pOperator);
        }
        try {
            return Coercions.operateEquality(pLeft.equals(pRight), pOperator);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                // empty if block
            }
            return Boolean.FALSE;
        }
    }

    private static boolean isInstanceOfNumber(Object object) {
        return object != null && (Coercions.isIntegerType(object.getClass()) || Coercions.isFloatingPointType(object.getClass()));
    }

    private static byte byteValue(Object object) {
        return (byte)Coercions.intValue(object);
    }

    private static short shortValue(Object object) {
        return (short)Coercions.intValue(object);
    }

    private static int intValue(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Float) {
            return (int)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (int)((Double)object).doubleValue();
        }
        return 0;
    }

    public static long longValue(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Float) {
            return (long)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (long)((Double)object).doubleValue();
        }
        return 0L;
    }

    private static float floatValue(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (float)((Double)object).doubleValue();
        }
        return 0.0f;
    }

    public static double doubleValue(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return 0.0;
    }

    public static boolean isFloatingPointType(Object pObject) {
        return pObject != null && Coercions.isFloatingPointType(pObject.getClass());
    }

    private static boolean isFloatingPointType(Class pClass) {
        return pClass == (class$java$lang$Float == null ? (class$java$lang$Float = Coercions.class$("java.lang.Float")) : class$java$lang$Float) || pClass == (class$java$lang$Double == null ? (class$java$lang$Double = Coercions.class$("java.lang.Double")) : class$java$lang$Double);
    }

    public static boolean isFloatingPointString(Object pObject) {
        if (pObject instanceof String) {
            String str = (String)pObject;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch != '.' && ch != 'e' && ch != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isIntegerType(Object pObject) {
        return pObject != null && Coercions.isIntegerType(pObject.getClass());
    }

    private static boolean isIntegerType(Class pClass) {
        return pClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = Coercions.class$("java.lang.Byte")) : class$java$lang$Byte) || pClass == (class$java$lang$Short == null ? (class$java$lang$Short = Coercions.class$("java.lang.Short")) : class$java$lang$Short) || pClass == (class$java$lang$Character == null ? (class$java$lang$Character = Coercions.class$("java.lang.Character")) : class$java$lang$Character) || pClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = Coercions.class$("java.lang.Integer")) : class$java$lang$Integer) || pClass == (class$java$lang$Long == null ? (class$java$lang$Long = Coercions.class$("java.lang.Long")) : class$java$lang$Long);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

