/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mashup.engine.impl;

import com.sun.mashup.engine.EDMProcessDefinition;
import com.sun.mashup.engine.MashupEngine;
import com.sun.rowset.WebRowSetImpl;
import com.sun.sql.framework.jdbc.DBConnectionParameters;
import com.sun.sql.framework.utils.ScEncrypt;
import com.sun.sql.framework.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MashupEngineImpl
implements MashupEngine {
    private static final String LOG_CATEGORY = MashupEngineImpl.class.getName();
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("PASSWORD\\ *=\\ *'([^']*)'");
    private static final Pattern USERNAME_PATTERN = Pattern.compile("USERNAME\\ *=\\ *'([^']*)'");
    private EDMProcessDefinition mashupDefinition = null;
    private String displayName = null;

    public MashupEngineImpl(EDMProcessDefinition mashupDef) {
        this.mashupDefinition = mashupDef;
    }

    public final ResultSet exec() {
        String managerName = "MashupEngine";
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            this.createDBLinks(conn);
            this.mashupDefinition.syncQueries();
            this.dropTableQueries(conn);
            this.createTableQueries(conn);
            rs = this.selectData(conn);
            if (this.displayName != null) {
                managerName = managerName + this.displayName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    private String decryptDbLinkSql(String rawSql) {
        String processedSql = rawSql;
        String userName = null;
        String encryptedPassword = null;
        String password = null;
        Matcher matcher = USERNAME_PATTERN.matcher(rawSql);
        if (matcher.find() && !StringUtil.isNullString(userName = matcher.group(1)) && (matcher = PASSWORD_PATTERN.matcher(rawSql)).find()) {
            encryptedPassword = matcher.group(1);
            try {
                if (!StringUtil.isNullString(encryptedPassword)) {
                    password = ScEncrypt.decrypt(userName, encryptedPassword);
                    processedSql = matcher.replaceFirst("PASSWORD='" + StringUtil.escapeJavaRegexpChars(password) + "'");
                }
                if (!StringUtil.isNullString(userName)) {
                    matcher = USERNAME_PATTERN.matcher(processedSql);
                    processedSql = matcher.replaceFirst("USERNAME='" + StringUtil.escapeJavaRegexpChars(userName) + "'");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return processedSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(List queries, Connection con) throws SQLException {
        Statement stmt = null;
        String sql = null;
        try {
            stmt = con.createStatement();
            ListIterator iter = queries.listIterator();
            while (iter.hasNext()) {
                sql = (String)iter.next();
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    private void createDBLinks(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        LinkedList<String> decryptedSql = new LinkedList<String>();
        ListIterator<String> dbIter = this.mashupDefinition.getDbLinks().listIterator();
        while (dbIter.hasNext()) {
            String sql = (String)dbIter.next();
            if (StringUtil.isNullString(sql)) continue;
            decryptedSql.add(this.decryptDbLinkSql(sql));
        }
        this.executeBatch(decryptedSql, conn);
    }

    private void dropTableQueries(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        this.executeBatch(this.mashupDefinition.getDropTableQueries(), conn);
    }

    private void createTableQueries(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        this.executeBatch(this.mashupDefinition.getCreateTableQueries(), conn);
    }

    private ResultSet selectData(Connection conn) throws SQLException {
        System.out.println("selectData called");
        if (conn == null) {
            System.out.println("conn is null");
            return null;
        }
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            System.out.println("trying to execute query = " + this.mashupDefinition.getDataMashupQuery().trim());
            rs = stmt.executeQuery(this.mashupDefinition.getDataMashupQuery().trim());
            System.out.println("successfully executed");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String theDisplayName) {
        this.displayName = theDisplayName;
    }

    public void setMashupDefinition(EDMProcessDefinition def) {
        this.mashupDefinition = def;
    }

    public EDMProcessDefinition getMashupDefinition() {
        return this.mashupDefinition;
    }

    public void start() {
    }

    public void stopMashupEngine() {
    }

    protected Connection getConnection() throws Exception {
        DBConnectionParameters dbConDefn = this.mashupDefinition.getDBConnectionParams();
        Connection con = null;
        Object driver = null;
        try {
            Driver originalDriver = (Driver)Class.forName(dbConDefn.getDriverClass()).newInstance();
            DriverManager.registerDriver(originalDriver);
            con = DriverManager.getConnection(dbConDefn.getConnectionURL());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return con;
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        EDMProcessDefinition processDef = new EDMProcessDefinition(f);
        MashupEngineImpl engine = new MashupEngineImpl(processDef);
        ResultSet rs = engine.exec();
        System.out.println(rs.toString());
        try {
            WebRowSetImpl ws = new WebRowSetImpl();
            ws.populate(rs);
            ws.writeXml(System.out);
            String col1 = ws.getString(0);
            String col2 = ws.getString(1);
            System.out.println("col1 = " + col1 + "col2 = " + col2);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

