/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Messages;
import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.MBeanNames;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class BaseBootstrap
implements Bootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(BaseBootstrap.class);
    private static final Messages MESSAGES = Messages.getMessages(BaseBootstrap.class);
    private InstallationContext context;
    private ObjectName mbeanName;

    public final ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    protected Object getExtensionMBean() throws Exception {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        MBeanNames names = this.context.getContext().getMBeanNames();
        return names.createCustomComponentMBeanName("bootstrap");
    }

    public final void init(InstallationContext installContext) throws JBIException {
        try {
            LOG.debug("Initializing bootstrap");
            this.context = installContext;
            this.doInit();
            LOG.debug("Bootstrap initialized");
        }
        catch (JBIException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw e;
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            LOG.error("CIC001005_Init_error", args, e);
            throw new JBIException(MESSAGES.getString("CIC001005_Init_error", args), (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        Object mbean = this.getExtensionMBean();
        if (mbean != null) {
            this.mbeanName = this.createExtensionMBeanName();
            MBeanServer server = this.context.getContext().getMBeanServer();
            if (server == null) {
                throw new JBIException(MESSAGES.getString("CIC001006_Null_mBeanServer", new Object[0]));
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
            server.registerMBean(mbean, this.mbeanName);
        }
    }

    public final void cleanUp() throws JBIException {
        try {
            LOG.debug("Cleaning up bootstrap");
            this.doCleanUp();
            LOG.debug("Bootstrap cleaned up");
        }
        catch (JBIException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw e;
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            LOG.error("CIC001007_Clean_up_error", args, e);
            throw new JBIException(MESSAGES.getString("CIC001007_Clean_up_error", args), (Throwable)e);
        }
    }

    protected void doCleanUp() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getContext().getMBeanServer();
            if (server == null) {
                throw new JBIException(MESSAGES.getString("CIC001006_Null_mBeanServer", new Object[0]));
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
    }

    public final void onInstall() throws JBIException {
        try {
            LOG.debug("Bootstrap onInstall");
            this.doOnInstall();
            LOG.debug("Bootstrap onInstall done");
        }
        catch (JBIException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw e;
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            LOG.error("CIC001008_On_install_error", args, e);
            throw new JBIException(MESSAGES.getString("CIC001008_On_install_error", args), (Throwable)e);
        }
    }

    protected void doOnInstall() throws Exception {
    }

    public final void onUninstall() throws JBIException {
        try {
            LOG.debug("Bootstrap onUninstall");
            this.doOnUninstall();
            LOG.debug("Bootstrap onUninstall done");
        }
        catch (JBIException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw e;
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            LOG.error("CIC001009_On_uninstall_error", args, e);
            throw new JBIException(MESSAGES.getString("CIC001009_On_uninstall_error", args), (Throwable)e);
        }
    }

    protected void doOnUninstall() throws Exception {
    }
}

