/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Jbi4cicsEndpoint;
import it.imolinfo.jbi4cics.jbi.Messages;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.xbean.AbstractXBeanDeployer;

public final class Jbi4cicsDeployer
extends AbstractXBeanDeployer {
    private static final String TASK = "deploy";
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4cicsDeployer.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4cicsDeployer.class);
    private String suRootPath;

    public Jbi4cicsDeployer(BaseComponent component) {
        super((ServiceMixComponent)component);
    }

    public ServiceUnit deploy(String suName, String suRootPath) throws DeploymentException {
        this.suRootPath = suRootPath;
        return super.deploy(suName, suRootPath);
    }

    protected void validate(Endpoint endpoint) throws DeploymentException {
        if (!(endpoint instanceof Jbi4cicsEndpoint)) {
            throw this.failure(TASK, MESSAGES.getString("CIC001010_No_jbi4cics_endpoint", new Object[0]), null);
        }
        Jbi4cicsEndpoint cicsEndpoint = (Jbi4cicsEndpoint)endpoint;
        String fileName = cicsEndpoint.getCopyCobolFileName();
        cicsEndpoint.setCopyCobol(this.readFile(this.suRootPath + File.separator + fileName));
        fileName = cicsEndpoint.getOutputCopyCobolFileName();
        if (fileName != null && fileName.length() > 0) {
            cicsEndpoint.setOutputCopyCobol(this.readFile(this.suRootPath + File.separator + fileName));
        }
        try {
            cicsEndpoint.registerService();
        }
        catch (Exception e) {
            Object[] args = new Object[]{e.getLocalizedMessage()};
            LOG.error("CIC001012_Error_registering_endpoint", args, e);
            throw this.failure(TASK, MESSAGES.getString("CIC001012_Error_registering_endpoint", args), e);
        }
    }

    private String readFile(String fileName) throws DeploymentException {
        File file = new File(fileName);
        char[] buf = new char[(int)file.length()];
        FileReader reader = null;
        try {
            int count;
            int offset = 0;
            reader = new FileReader(file);
            while ((offset += (count = reader.read(buf, offset, buf.length - offset))) < buf.length) {
            }
        }
        catch (IOException e) {
            throw this.createFailure(fileName, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw this.createFailure(fileName, e);
                }
            }
        }
        return new String(buf);
    }

    private DeploymentException createFailure(String fileName, IOException ioe) {
        Object[] args = new Object[]{fileName, ioe.getLocalizedMessage()};
        String errorMsg = MESSAGES.getString("CIC001011_Error_reading_copy_file", args);
        LOG.error("CIC001011_Error_reading_copy_file", args, ioe);
        return this.failure(TASK, errorMsg, ioe);
    }
}

