/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi.processor.wsdl11wrapper;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.processor.wsdl11wrapper.WrapperProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.codehaus.xfire.util.STAXUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WrapperUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WrapperUtil.class);
    public static final String WRAPPER_DEFAULT_NAMESPACE_PREFIX = "jbi";
    public static final String WRAPPER_DEFAULT_NAMESPACE = "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper";
    public static final String WRAPPER_MESSAGE = "jbi:message";
    public static final String WRAPPER_ATTRIBUTE_VERSION = "version";
    public static final String WRAPPER_ATTRIBUTE_VERSION_VALUE = "1.0";
    public static final String WRAPPER_ATTRIBUTE_TYPE = "type";
    public static final String WRAPPER_ATTRIBUTE_NAME = "name";
    public static final String WRAPPER_PART = "jbi:part";

    public static Element createJBIMessageWrapper(Document normalDoc, QName type, String name) {
        Element msgWrapper = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_MESSAGE);
        msgWrapper.setAttribute(WRAPPER_ATTRIBUTE_VERSION, WRAPPER_ATTRIBUTE_VERSION_VALUE);
        String prefix = type.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            prefix = "msgns";
        }
        msgWrapper.setAttribute(WRAPPER_ATTRIBUTE_TYPE, prefix + ":" + type.getLocalPart());
        msgWrapper.setAttribute("xmlns:" + prefix, type.getNamespaceURI());
        if (name != null) {
            msgWrapper.setAttribute(WRAPPER_ATTRIBUTE_NAME, name);
        }
        return msgWrapper;
    }

    public static Element createJBIWrappedPart(Document normalDoc, Node part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            wrapperElem.appendChild(part);
        }
        return wrapperElem;
    }

    public static Element createJBIWrappedPart(Document normalDoc, NodeList part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            int noOfNodes = part.getLength();
            for (int nodeCount = 0; nodeCount < noOfNodes; ++nodeCount) {
                wrapperElem.appendChild(part.item(nodeCount));
            }
        }
        return wrapperElem;
    }

    public static Element importJBIWrappedPart(Document normalDoc, Node part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            Node importedPartNode = normalDoc.importNode(part, true);
            wrapperElem.appendChild(importedPartNode);
        }
        return wrapperElem;
    }

    public static Element importJBIWrappedPart(Document normalDoc, NodeList part) {
        Element wrapperElem = normalDoc.createElementNS(WRAPPER_DEFAULT_NAMESPACE, WRAPPER_PART);
        if (part != null) {
            int noOfNodes = part.getLength();
            for (int nodeCount = 0; nodeCount < noOfNodes; ++nodeCount) {
                Node aNode = part.item(nodeCount);
                if (aNode == null) continue;
                Node importedPartNode = normalDoc.importNode(aNode, true);
                wrapperElem.appendChild(importedPartNode);
            }
        }
        return wrapperElem;
    }

    public static boolean isMessageWrapped(Document doc) {
        String nsURI;
        Element jbiMessageWrapper;
        boolean wrapperDetected = false;
        if (doc != null && (jbiMessageWrapper = doc.getDocumentElement()) != null && (nsURI = jbiMessageWrapper.getNamespaceURI()) != null && nsURI.equals(WRAPPER_DEFAULT_NAMESPACE)) {
            wrapperDetected = true;
        }
        return wrapperDetected;
    }

    public static Source jbiMessageWrapper(String msgContent, QName qName, String name) throws WrapperProcessingException {
        Document msgDoc;
        DocumentBuilder mBuilder;
        if (qName == null) {
            throw new WrapperProcessingException("messageqName is null");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.isNamespaceAware();
            mBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new WrapperProcessingException(ex.getMessage(), ex);
        }
        Document normalDoc = mBuilder.newDocument();
        Object normalRoot = null;
        Element jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper(normalDoc, qName, name);
        normalDoc.appendChild(jbiMessageWrapper);
        try {
            msgDoc = mBuilder.parse(new InputSource(new StringReader(msgContent)));
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new WrapperProcessingException(ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new WrapperProcessingException(ex.getMessage(), ex);
        }
        Element jbiMessagePart = WrapperUtil.importJBIWrappedPart(normalDoc, msgDoc.getDocumentElement());
        jbiMessageWrapper.appendChild(jbiMessagePart);
        try {
            LOG.debug(WrapperUtil.toXml(normalDoc, "UTF-8", false));
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), ex);
            throw new WrapperProcessingException(ex.getMessage(), ex);
        }
        return new StringSource(WrapperUtil.toXml(normalDoc, "UTF-8", false));
    }

    public static String toXml(Node node, String encoding, boolean omitXMLDeclaration) throws WrapperProcessingException {
        String ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("encoding", encoding);
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
            trans.transform(new DOMSource(node), new StreamResult(baos));
            ret = baos.toString(encoding);
        }
        catch (TransformerException ex) {
            LOG.warn(ex.getMessage(), ex);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new WrapperProcessingException(ex.getMessage(), ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            LOG.error(ex.getMessage(), ex);
            new WrapperProcessingException(ex.getMessage(), ex);
        }
        return ret;
    }

    public static boolean isMessageWrapped(XMLStreamReader docReader) throws WrapperProcessingException {
        boolean wrapperDetected = false;
        if (docReader != null) {
            try {
                String nsURI = docReader.getNamespaceURI();
                if (nsURI != null && nsURI.equals(WRAPPER_DEFAULT_NAMESPACE)) {
                    wrapperDetected = true;
                }
            }
            catch (IllegalStateException illex) {
                LOG.warn("CIC001201_IO_exception", new Object[]{illex.getMessage()}, illex);
            }
        }
        return wrapperDetected;
    }

    public static XMLStreamReader unWrapMessage(XMLStreamReader docReader) throws WrapperProcessingException {
        XMLStreamReader unwrappedReader;
        DocumentBuilder mBuilder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.isNamespaceAware();
            mBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new WrapperProcessingException(ex);
        }
        Document wrappedDoc = mBuilder.newDocument();
        try {
            STAXUtils.readDocElements((Node)wrappedDoc, (XMLStreamReader)docReader, (boolean)true);
        }
        catch (XMLStreamException ex) {
            LOG.error(ex.getMessage(), ex);
            throw new WrapperProcessingException(ex.getMessage(), ex);
        }
        Document returnedDoc = mBuilder.newDocument();
        Element jbiMessageWrapper = wrappedDoc.getDocumentElement();
        NodeList childNodes = jbiMessageWrapper.getChildNodes();
        for (int childCount = 0; childCount < childNodes.getLength(); ++childCount) {
            Node currNode = childNodes.item(childCount);
            if (currNode.getNodeType() != 1) continue;
            Element jbiPartWrapper = (Element)currNode;
            NodeList partChildNodes = jbiPartWrapper.getChildNodes();
            for (int i = 0; i < partChildNodes.getLength(); ++i) {
                Node partChildNode = partChildNodes.item(i);
                Node importedElement = returnedDoc.importNode(partChildNode, true);
                returnedDoc.appendChild(importedElement);
            }
        }
        try {
            LOG.debug(WrapperUtil.toXml(returnedDoc, "UTF-8", false));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WrapperProcessingException(ex);
        }
        XMLInputFactory saxFactory = XMLInputFactory.newInstance();
        try {
            String xml = WrapperUtil.toXml(returnedDoc, "UTF-8", false);
            unwrappedReader = saxFactory.createXMLStreamReader(new StringReader(xml));
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            throw new WrapperProcessingException(ex);
        }
        return unwrappedReader;
    }
}

