/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi.wsdl;

import com.ibm.wsdl.util.xml.DOMUtils;
import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsAddress;
import java.io.PrintWriter;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;

public class Jbi4CicsAddressSerializer
implements ExtensionSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CicsAddressSerializer.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4CicsAddressSerializer.class);

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String prefix = null;
        try {
            prefix = DOMUtils.getPrefix((String)"uri://schemas.imola.it/jbi/wsdl-extensions/cics/", (Definition)def);
        }
        catch (WSDLException ex) {
            LOG.warn("CIC001300_Jbi4cics_namespace_not_found", "uri://schemas.imola.it/jbi/wsdl-extensions/cics/");
        }
        if (prefix == null) {
            prefix = "imolacics";
            def.addNamespace("imolacics", "uri://schemas.imola.it/jbi/wsdl-extensions/cics/");
        }
        prefix = prefix + ":";
        LOG.debug("prefix found: " + prefix);
        if (extension instanceof Jbi4CicsAddress) {
            Jbi4CicsAddress jbi4CicsAddress = (Jbi4CicsAddress)extension;
            pw.print("<" + prefix + "address");
            if (jbi4CicsAddress.getUsername() == null) {
                LOG.error("CIC001301_Invalid_username");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001301_Invalid_username", new Object[0]));
            }
            DOMUtils.printAttribute((String)"username", (String)jbi4CicsAddress.getUsername(), (PrintWriter)pw);
            if (jbi4CicsAddress.getPassword() == null) {
                LOG.error("CIC001302_Invalid_password");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001302_Invalid_password", new Object[0]));
            }
            DOMUtils.printAttribute((String)"password", (String)jbi4CicsAddress.getPassword(), (PrintWriter)pw);
            if (!jbi4CicsAddress.getConnectionType().equals("CICS") && !jbi4CicsAddress.getConnectionType().equals("DUMMY")) {
                LOG.error("CIC001303_Invalid_connection_type");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001303_Invalid_connection_type", new Object[0]));
            }
            DOMUtils.printAttribute((String)"connectionType", (String)jbi4CicsAddress.getConnectionType(), (PrintWriter)pw);
            if (jbi4CicsAddress.getJNDIConnectionName() == null) {
                LOG.error("CIC001304_Invalid_jndi_connection_name");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001304_Invalid_jndi_connection_name", new Object[0]));
            }
            DOMUtils.printAttribute((String)"JNDIConnectionName", (String)jbi4CicsAddress.getJNDIConnectionName(), (PrintWriter)pw);
            if (jbi4CicsAddress.getProgramName() == null) {
                LOG.error("CIC001305_Invalid_program_name");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001305_Invalid_program_name", new Object[0]));
            }
            DOMUtils.printAttribute((String)"programName", (String)jbi4CicsAddress.getProgramName(), (PrintWriter)pw);
            if (jbi4CicsAddress.getTransactionName() == null) {
                LOG.error("CIC001306_Invalid_transaction_name");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001306_Invalid_transaction_name", new Object[0]));
            }
            DOMUtils.printAttribute((String)"transactionName", (String)jbi4CicsAddress.getTransactionName(), (PrintWriter)pw);
            if (!jbi4CicsAddress.getTpn().toString().equals("true") && !jbi4CicsAddress.getTpn().toString().equals("false")) {
                LOG.error("CIC001307_Invalid_tpn");
                throw new WSDLException("INVALID_WSDL", MESSAGES.getString("CIC001307_Invalid_tpn", new Object[0]));
            }
            DOMUtils.printAttribute((String)"tpn", (String)jbi4CicsAddress.getTpn().toString(), (PrintWriter)pw);
            pw.print(">\n");
            pw.print("</" + prefix + "address" + ">\n");
        } else {
            LOG.warn("CIC001308_Invalid_extension_element", "address");
        }
    }
}

