/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.messageformat.jdbc;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.jdbc.util.DisconnectedCallableStatement;
import it.imolinfo.jbi4cics.connection.jdbc.util.DisconnectedPreparedStatement;
import it.imolinfo.jbi4cics.connection.jdbc.util.DisconnectedStatementFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.messageformat.MessageFormatter;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcBeanMappingDescriptor;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcOutputMessage;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcParameterDescriptor;
import it.imolinfo.jbi4cics.messageformat.jdbc.JdbcStatementDescriptor;
import it.imolinfo.jbi4cics.messageformat.jdbc.ResultSetMappingDescriptor;
import it.imolinfo.jbi4cics.service.ServiceContext;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.ConvertingWrapDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.beanutils.WrapDynaBean;

public class JdbcFormatter
implements MessageFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcFormatter.class);
    private static final Messages MESSAGES = Messages.getMessages(JdbcFormatter.class);

    public void mapInputBeanToInputMessage(ServiceContext serviceContext) throws FormatException {
        Object inputBean = serviceContext.getInputBean();
        if (!(serviceContext.getInputMappingDescriptor() instanceof JdbcStatementDescriptor)) {
            LOG.error("CIC001801_Jdbc_statement_descriptor_not_found", serviceContext.getInputMappingDescriptor().getClass());
            throw new FormatException(MESSAGES.getString("CIC001801_Jdbc_statement_descriptor_not_found", serviceContext.getInputMappingDescriptor().getClass()));
        }
        JdbcStatementDescriptor jdbcStatementDescriptor = (JdbcStatementDescriptor)serviceContext.getInputMappingDescriptor();
        DisconnectedPreparedStatement statement = null;
        switch (jdbcStatementDescriptor.getStatementType()) {
            case 0: {
                statement = DisconnectedStatementFactory.prepareDisconnectedStatement(jdbcStatementDescriptor.getSql());
                break;
            }
            case 1: {
                statement = DisconnectedStatementFactory.prepareDisconnectedCall(jdbcStatementDescriptor.getSql());
                break;
            }
            default: {
                throw new FormatException(MESSAGES.getString("CIC001802_Unrecognized_statement_type", jdbcStatementDescriptor.getStatementType()));
            }
        }
        Map<String, Integer> propertyNameParameterIndexMap = jdbcStatementDescriptor.getPropertyNameParameterIndexMap();
        WrapDynaBean dynaBean = new WrapDynaBean(inputBean);
        Iterator<String> i = propertyNameParameterIndexMap.keySet().iterator();
        while (i.hasNext()) {
            try {
                String propertyName = i.next();
                int parameterIndex = propertyNameParameterIndexMap.get(propertyName);
                JdbcParameterDescriptor jdbcParameterDescriptor = jdbcStatementDescriptor.getParameter(parameterIndex);
                Object value = dynaBean.get(propertyName);
                if (jdbcStatementDescriptor.getStatementType() == 1) {
                    ((CallableStatement)((Object)statement)).registerOutParameter(parameterIndex, jdbcParameterDescriptor.getSqlType());
                }
                statement.setObject(parameterIndex, value);
            }
            catch (SQLException e) {
                throw new FormatException(e);
            }
        }
        LOG.debug("created statement: " + statement);
        serviceContext.setInputMessage(statement);
    }

    public void mapOutputMessageToOutputBean(ServiceContext serviceContext) throws FormatException {
        Object outputMessage = serviceContext.getOutputMessage();
        if (!(serviceContext.getOutputMappingDescriptor() instanceof JdbcBeanMappingDescriptor)) {
            LOG.error("CIC001803_Jdbc_bean_mapping_descriptor_not_found", serviceContext.getOutputMappingDescriptor().getClass());
            throw new FormatException(MESSAGES.getString("CIC001803_Jdbc_bean_mapping_descriptor_not_found", serviceContext.getOutputMappingDescriptor().getClass()));
        }
        JdbcBeanMappingDescriptor jdbcBeanMappingDescriptor = (JdbcBeanMappingDescriptor)serviceContext.getOutputMappingDescriptor();
        JdbcStatementDescriptor jdbcStatementDescriptor = jdbcBeanMappingDescriptor.getJdbcStatementDescriptor();
        ResultSetMappingDescriptor resultSetMappingDescriptor = jdbcBeanMappingDescriptor.getResultSetMappingDescriptor();
        if (!(outputMessage instanceof JdbcOutputMessage)) {
            LOG.error("CIC001804_Jdbc_output_message_not_found", outputMessage.getClass());
            throw new FormatException(MESSAGES.getString("CIC001804_Jdbc_output_message_not_found", outputMessage.getClass()));
        }
        JdbcOutputMessage jdbcOutputMessage = (JdbcOutputMessage)outputMessage;
        ConvertingWrapDynaBean wrappedOutputParameterBean = null;
        try {
            Object beanInstance = jdbcStatementDescriptor.getBeanClass().newInstance();
            wrappedOutputParameterBean = new ConvertingWrapDynaBean(beanInstance);
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getMessage(), e);
            throw new FormatException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            LOG.error(e.getMessage(), e);
            throw new FormatException(e.getMessage(), e);
        }
        if (jdbcStatementDescriptor.getStatementType() == 1) {
            Map<String, Integer> propertyNameParameterIndexMap = jdbcStatementDescriptor.getPropertyNameParameterIndexMap();
            DisconnectedCallableStatement disconnectedCallableStatement = (DisconnectedCallableStatement)jdbcOutputMessage.getDisconnectedSatetement();
            Iterator i = propertyNameParameterIndexMap.keySet().iterator();
            while (i.hasNext()) {
                try {
                    String propertyName = i.next();
                    int parameterIndex = propertyNameParameterIndexMap.get(propertyName);
                    JdbcParameterDescriptor jdbcParameterDescriptor = jdbcStatementDescriptor.getParameter(parameterIndex);
                    if (jdbcParameterDescriptor.getInOutType() != 2 && jdbcParameterDescriptor.getInOutType() != 1) continue;
                    Object value = disconnectedCallableStatement.getObject(parameterIndex);
                    wrappedOutputParameterBean.set(propertyName, value);
                }
                catch (SQLException e) {
                    LOG.error(e.getMessage(), e);
                    throw new FormatException(e.getMessage(), e);
                }
            }
        }
        if (jdbcStatementDescriptor.getSqlType() == 1) {
            ArrayList<Object> outputResultSetBeanList = new ArrayList<Object>();
            try {
                ResultSetDynaClass resultSetDynaClass = new ResultSetDynaClass(jdbcOutputMessage.getResultSet(), true);
                for (DynaBean rowDynaBean : resultSetDynaClass) {
                    ConvertingWrapDynaBean wrappedOutputResultSetBean = null;
                    try {
                        Object beanInstance = resultSetMappingDescriptor.getBeanClass().newInstance();
                        wrappedOutputResultSetBean = new ConvertingWrapDynaBean(beanInstance);
                    }
                    catch (IllegalAccessException e) {
                        LOG.error(e.getMessage(), e);
                        throw new FormatException(e.getMessage(), e);
                    }
                    catch (InstantiationException e) {
                        LOG.error(e.getMessage(), e);
                        throw new FormatException(e.getMessage(), e);
                    }
                    Map<String, String> columnNamePropertyNameMap = resultSetMappingDescriptor.getColumnNamePropertyNameMap();
                    for (String columnName : columnNamePropertyNameMap.keySet()) {
                        String propertyName = columnNamePropertyNameMap.get(columnName);
                        Object value = rowDynaBean.get(columnName.toLowerCase());
                        wrappedOutputResultSetBean.set(propertyName, value);
                    }
                    outputResultSetBeanList.add(wrappedOutputResultSetBean.getInstance());
                }
            }
            catch (SQLException e) {
                LOG.error(e.getMessage(), e);
                throw new FormatException(e.getMessage(), e);
            }
            wrappedOutputParameterBean.set(jdbcBeanMappingDescriptor.getResultSetPropertyName(), outputResultSetBeanList);
        }
        serviceContext.setOutputBean(wrappedOutputParameterBean.getInstance());
    }
}

