/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.custom.runtime.provider.Delim;
import com.sun.encoder.custom.runtime.provider.Nodes;
import com.sun.encoder.custom.runtime.provider.NodesFactory;
import com.sun.encoder.custom.runtime.provider.OtdDelim;
import com.sun.encoder.runtime.CoderFactory;
import com.sun.encoder.runtime.MarshalException;
import com.sun.encoder.runtime.OtdOutputStream;
import com.sun.encoder.runtime.StringCoder;
import com.sun.encoder.runtime.provider.Misc;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BudOutput
implements ContentHandler {
    private static final int INITIAL_SIZE = 1000;
    public PrintStream mDebug = null;
    private final Nodes mNodes;
    private final OtdDelim mOtdel;
    private int mKeep = 0;
    private OtdOutputStream mOut = null;
    private byte[] mEmb = null;
    private final boolean[] mSlotSeen;
    private byte[] mBuf = null;
    private int mFix = 0;
    private int mPos = 0;
    private int mTop = 0;
    private int mSize = 0;
    private long mOff = 0L;
    private long mEnd = -1L;
    private byte[] mPadBytes = new byte[]{32};
    private final Stack<Context> mContextStack = new Stack();
    private Context mContext = null;
    private int mTransLevel = -1;
    private StringCoder mEncoder;

    public BudOutput(Nodes nodes, OtdDelim otdel) {
        this.mNodes = nodes;
        this.mOtdel = otdel;
        this.mSlotSeen = otdel.mSlots == null || otdel.mSlots.length == 0 ? null : new boolean[otdel.mSlots.length];
    }

    public void keep(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.mKeep = size;
    }

    private void initSlotSeen() {
        if (this.mSlotSeen != null) {
            int i = this.mSlotSeen.length;
            while (i-- > 0) {
                this.mSlotSeen[i] = false;
            }
        }
        if (this.mOtdel.mSlotsLength > 0) {
            this.mEmb = new byte[this.mOtdel.mSlotsLength];
        }
    }

    private void room(int n) {
        int total = this.mPos + n;
        if (total > this.mSize) {
            int size2 = this.mSize * 3 / 2;
            if (size2 < total) {
                size2 = total;
            }
            byte[] b2 = new byte[size2];
            if (this.mBuf != null) {
                System.arraycopy(this.mBuf, 0, b2, 0, this.mSize);
            }
            this.mSize = size2;
            this.mBuf = b2;
        }
    }

    public void raw(byte[] data, int offset, int length) {
        if (data != null) {
            if (0L <= this.mEnd && this.mEnd < this.mOff + (long)this.mPos + (long)length) {
                throw new MarshalException("truncation by parent");
            }
            this.room(length);
            System.arraycopy(data, offset, this.mBuf, this.mPos, length);
            this.mPos += length;
        }
    }

    public void raw(byte[] data) {
        this.raw(data, 0, data.length);
    }

    public void raw(Delim delim) {
        if (delim.embedded()) {
            Delim.Slot slot = this.mOtdel.mSlots[delim.mSlot];
            if (!this.mSlotSeen[delim.mSlot]) {
                if (this.mOff + (long)this.mFix < slot.mOffset + (long)slot.mLength) {
                    throw new MarshalException("emitting embedded delimiter [" + slot.mOffset + ":" + slot.mLength + "] at " + (this.mOff + (long)this.mFix) + ", before its defining data");
                }
                this.mSlotSeen[delim.mSlot] = true;
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ - emitting embedded " + delim.mSlot + ": " + slot.mOffset + ", " + slot.mLength + "; slice " + (slot.mOffset - this.mOtdel.mSlotsOffset) + ", " + slot.mLength + " of <" + Misc.printable((byte[])this.mEmb) + "> ]");
            }
            this.raw(this.mEmb, (int)(slot.mOffset - this.mOtdel.mSlotsOffset), slot.mLength);
        } else {
            this.raw(delim.mData);
        }
    }

    private void raw(byte[] data, int count, byte[] pads) {
        int len;
        if (pads == null) {
            pads = this.mPadBytes;
        }
        if (count < 1) {
            this.raw(data);
            return;
        }
        if (data == null) {
            data = new byte[]{};
        }
        if ((len = data.length) > count) {
            len = count;
        }
        if (0L <= this.mEnd && this.mEnd < this.mOff + (long)this.mPos + (long)len) {
            throw new MarshalException("truncation by parent");
        }
        this.room(count);
        System.arraycopy(data, 0, this.mBuf, this.mPos, len);
        this.mPos += len;
        int pi = 0;
        for (int i = len; i < count; ++i) {
            this.mBuf[this.mPos++] = pads[pi++];
            if (pi < pads.length) continue;
            pi = 0;
        }
        if (pi != 0) {
            throw new MarshalException("padding sequence truncated");
        }
    }

    public void flush() throws IOException {
        if (this.mFix > 0) {
            if (this.mOut == null) {
                throw new RuntimeException("no output stream");
            }
            if (this.mDebug != null) {
                this.mDebug.println("[ flush " + this.mFix + " bytes, offset=" + this.mOff + " ]");
            }
            this.mOut.write(this.mBuf, 0, this.mFix);
            this.mOff += (long)this.mFix;
            if (this.mFix < this.mPos) {
                int i = 0;
                while (this.mFix < this.mPos) {
                    this.mBuf[i] = this.mBuf[this.mFix++];
                    ++i;
                }
            }
            this.mPos -= this.mFix;
            this.mFix = 0;
        }
    }

    public void commit() throws IOException {
        if (this.mEmb != null) {
            int size = this.mPos;
            long from = 0L;
            long into = this.mOff - this.mOtdel.mSlotsOffset;
            if (into < (long)this.mOtdel.mSlotsLength && 0L <= into + (long)size) {
                if (into < 0L) {
                    size = (int)((long)size + into);
                    from -= into;
                    into = 0L;
                }
                if ((long)this.mOtdel.mSlotsLength < into + (long)size) {
                    size = (int)((long)this.mOtdel.mSlotsLength - into);
                }
                if (this.mDebug != null) {
                    this.mDebug.println("[ - truly embed: from=" + from + ", into=" + into + ", size=" + size + " ]");
                }
                while (size-- > 0) {
                    this.mEmb[(int)into++] = this.mBuf[(int)from++];
                }
            }
        }
        if ((this.mFix = this.mPos) >= this.mKeep && this.mKeep > 0) {
            this.flush();
        }
    }

    public void rollback(long limit) {
        if (this.mOff + (long)this.mPos < limit) {
            throw new RuntimeException("invalid limit " + limit + ", past offset/cursor " + this.mOff + "/" + this.mPos);
        }
        this.mPos = Math.max(this.mFix, (int)(limit - this.mOff));
    }

    public void rollback() {
        this.mPos = this.mFix;
    }

    public long at() throws IOException {
        this.commit();
        return this.mOff + (long)this.mPos;
    }

    public void pad(int n, byte[] pads) {
        if (pads == null) {
            pads = this.mPadBytes;
        }
        if (n > 0) {
            this.room(n);
            int pi = 0;
            while (n-- > 0) {
                this.mBuf[this.mPos++] = pads[pi++];
                if (pi < pads.length) continue;
                pi = 0;
            }
            if (pi != 0) {
                throw new MarshalException("padding sequence truncated");
            }
            if (this.mTop < this.mPos) {
                this.mTop = this.mPos;
            }
        }
    }

    public void pad(int from, int n, byte[] pads) {
        this.pad(from + n - this.mPos, pads);
    }

    public void clear() {
        this.mSize = 0;
        this.mTop = 0;
        this.mFix = 0;
        this.mPos = 0;
        this.mBuf = null;
    }

    public byte[] content() {
        byte[] out = new byte[this.mFix];
        if (this.mFix > 0) {
            System.arraycopy(this.mBuf, 0, out, 0, this.mFix);
        }
        if (this.mDebug != null) {
            this.mDebug.println("[ content (" + this.mFix + " bytes) = " + Misc.printable((byte[])out));
        }
        this.clear();
        return out;
    }

    public int getOffset() {
        return this.mPos;
    }

    public void setOffset(int pos) {
        this.mPos = pos;
    }

    public StringCoder getEncoder() {
        return this.mEncoder;
    }

    public void setEncoder(StringCoder encoder) {
        this.mEncoder = encoder;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (this.mDebug != null) {
            if (this.mOut != null) {
                this.mDebug.println("[ render to OTD stream ]");
            } else {
                this.mDebug.println("[ render to byte[] ]");
            }
        }
        this.mContextStack.clear();
        this.mContext = new Context();
        this.mContext.mNodeIndex = this.mNodes.getRoot();
        this.mContext.mChildIndex = -1;
        this.mContext.mRepeatIndex = -1;
        this.mContext.mNode = null;
        this.mContext.mParentNode = null;
        this.mContext.mDelimLevel = null;
        this.mContext.mPlain = null;
        this.mContext.mArray = null;
        this.mContext.mHasContent = false;
        this.mContext.mOpen = false;
        this.mTop = 0;
        this.mFix = 0;
        this.mPos = 0;
        this.room(1000);
        if (this.mOut != null) {
            try {
                this.mOut.begin();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        } else {
            this.mKeep = 0;
        }
        this.initSlotSeen();
    }

    public void endDocument() throws SAXException {
        if (this.mOut != null) {
            try {
                this.flush();
                this.mOut.end();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.mContext.mOpen && this.mContext.mNode != null && this.mContext.mNode.isTrans()) {
            ++this.mTransLevel;
            return;
        }
        int prevChildIndex = this.mContext.mOpen ? -1 : this.mContext.mChildIndex;
        if (!this.match(uri, localName)) {
            throw new SAXException("Element {" + uri + "}" + localName + " is not expected.");
        }
        if (this.mContext.mParentNode != null) {
            for (int i = prevChildIndex + 1; i >= 0 && i < this.mContext.mChildIndex; ++i) {
                Nodes.Node node = this.mNodes.get(this.mContext.mParentNode.mSub[i]);
                if (!node.isDelim() && !node.isArray()) continue;
                if (this.mContext.mDelimLevel == null) {
                    throw new SAXException("no delimiter available");
                }
                if (this.mContext.mPlain == null) {
                    throw new SAXException("no plain delimiter here");
                }
                if (this.mContext.mPlain.mLieu >= 2) {
                    this.raw(this.mContext.mPlain);
                }
                try {
                    this.commit();
                    continue;
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
        if (this.mContext.mNode.isTrans()) {
            this.mTransLevel = 0;
            return;
        }
        if (this.mContext.mNode.isDelim() || this.mContext.mNode.isArray()) {
            if (this.mContext.mDelimLevel == null) {
                throw new SAXException("no delimiter available");
            }
            if (this.mContext.mPlain == null) {
                throw new SAXException("no plain delimiter here");
            }
            if (this.mContext.mNode.isArray() && this.mContext.mArray == null) {
                throw new SAXException("no array delimiter here");
            }
        }
        if (this.mContext.mNode.mRepeat) {
            if (this.mContext.mNodeIndex == this.mNodes.getRoot()) {
                throw new SAXException("repeated root");
            }
            if (this.mContext.mNode.mMaxOcc != -1 && this.mContext.mRepeatIndex > this.mContext.mNode.mMaxOcc) {
                throw new SAXException("Too many elements: {" + uri + "}" + localName);
            }
            if (this.mContext.mNode.isArray() && this.mContext.mRepeatIndex > 0) {
                if (this.mDebug != null) {
                    this.mDebug.println("[ - separate child " + this.mContext.mChildIndex + ", occur=" + this.mContext.mRepeatIndex + " ]");
                }
                this.rollback();
                this.raw(this.mContext.mArray);
                try {
                    this.commit();
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        } else {
            if (this.mContext.mRepeatIndex > 0) {
                throw new SAXException("Too many elements: {" + uri + "}" + localName);
            }
            if (this.mContext.mNode.isSimple() && this.mContext.mNodeIndex == this.mNodes.getRoot()) {
                throw new SAXException("simple root");
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.mContext.mOpen) {
            Nodes.Node node;
            int subCount = this.mContext.mParentNode.mSub.length;
            for (int i = this.mContext.mChildIndex + 1; i < subCount - 1; ++i) {
                node = this.mNodes.get(this.mContext.mParentNode.mSub[i]);
                if (!node.isDelim() && !node.isArray()) continue;
                if (this.mContext.mDelimLevel == null) {
                    throw new SAXException("no delimiter available");
                }
                if (this.mContext.mPlain == null) {
                    throw new SAXException("no plain delimiter here");
                }
                if (this.mContext.mPlain.mLieu < 2) continue;
                this.raw(this.mContext.mPlain);
                try {
                    this.commit();
                    continue;
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
            if (this.mContext.mChildIndex < subCount - 1 && ((node = this.mNodes.get(this.mContext.mParentNode.mSub[subCount - 1])).isDelim() || node.isArray())) {
                this.rollback();
                this.raw(this.mContext.mPlain);
                if (this.mContext.mPlain.mTerm >= 2) {
                    try {
                        this.commit();
                    }
                    catch (IOException e) {
                        throw new SAXException(e);
                    }
                }
            }
            this.mContext = this.mContextStack.pop();
        } else if (this.mContext.mNode != null && this.mContext.mNode.isTrans()) {
            if (this.mTransLevel > 0) {
                --this.mTransLevel;
                return;
            }
            this.mTransLevel = -1;
        }
        this.mContext.mOpen = false;
        if (this.mContext.mNode.isDelim() || this.mContext.mNode.isArray()) {
            this.rollback();
            this.raw(this.mContext.mPlain);
            if (this.mContext.mPlain.mTerm >= 2 || !this.mContext.mHasContent && this.mContext.mChildIndex + 1 < this.mContext.mParentNode.mSub.length) {
                try {
                    this.commit();
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        byte[] b;
        if (!this.mContext.mNode.isSimple() || !this.mContext.mOpen) {
            return;
        }
        if (this.mEncoder == null) {
            this.mEncoder = CoderFactory.getCoder((String)"iso-8859-1");
        }
        if ((b = this.mEncoder.encode(new String(ch, start, length))) == null) {
            return;
        }
        if (this.mContext.mNode.mType == 3) {
            this.raw(b, this.mContext.mNode.mLength, null);
        } else {
            this.raw(b);
        }
        try {
            this.commit();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        for (int i = this.mContextStack.size() - 1; i >= 0; --i) {
            ((Context)this.mContextStack.get((int)i)).mHasContent = true;
        }
        this.mContext.mHasContent = true;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public OtdOutputStream getOutputStream() {
        return this.mOut;
    }

    public void setOutputStream(OtdOutputStream out) {
        this.mOut = out;
    }

    public int getKeep() {
        return this.mKeep;
    }

    public void setKeep(int keep) {
        this.mKeep = keep;
    }

    private boolean match(String namespace, String localName) throws SAXException {
        if (namespace == null) {
            namespace = "";
        }
        if (!this.mContext.mOpen) {
            if (this.mContext.mNode != null) {
                if (localName.equals(this.mContext.mNode.mName) && namespace.equals(this.mContext.mNode.mNamespace)) {
                    ++this.mContext.mRepeatIndex;
                    this.mContext.mOpen = true;
                    this.mContext.mHasContent = false;
                    return true;
                }
                if (this.mContext.mParentNode.isAlter()) {
                    return false;
                }
                for (int i = this.mContext.mChildIndex + 1; i < this.mContext.mParentNode.mSub.length; ++i) {
                    Nodes.Node node = this.mNodes.get(this.mContext.mParentNode.mSub[i]);
                    if (!localName.equals(node.mName) || !namespace.equals(node.mNamespace)) continue;
                    this.mContext.mNodeIndex = this.mContext.mParentNode.mSub[i];
                    this.mContext.mChildIndex = i;
                    this.mContext.mRepeatIndex = 0;
                    this.mContext.mNode = node;
                    this.mContext.mOpen = true;
                    this.mContext.mHasContent = false;
                    if (node.mLevel != null) {
                        this.mContext.mDelimLevel = node.mLevel;
                        this.mContext.mPlain = node.mLevel.mPlain >= 0 ? this.mOtdel.get(node.mLevel.mPlain) : null;
                        this.mContext.mArray = node.mLevel.mArray >= 0 ? this.mOtdel.get(node.mLevel.mArray) : null;
                    }
                    return true;
                }
            } else {
                Nodes.Node node = this.mNodes.get(this.mNodes.getRoot());
                if (localName.equals(node.mName) && namespace.equals(node.mNamespace)) {
                    this.mContext.mNode = node;
                    this.mContext.mDelimLevel = node.mLevel;
                    if (this.mContext.mDelimLevel.mPlain >= 0) {
                        this.mContext.mPlain = this.mOtdel.get(this.mContext.mDelimLevel.mPlain);
                    }
                    if (this.mContext.mDelimLevel.mArray >= 0) {
                        this.mContext.mArray = this.mOtdel.get(this.mContext.mDelimLevel.mArray);
                    }
                    this.mContext.mNodeIndex = this.mNodes.getRoot();
                    this.mContext.mChildIndex = 0;
                    this.mContext.mRepeatIndex = 0;
                    this.mContext.mOpen = true;
                    this.mContext.mHasContent = false;
                    return true;
                }
            }
            return false;
        }
        if (this.mContext.mNode.isSimple()) {
            return false;
        }
        for (int i = 0; i < this.mContext.mNode.mSub.length; ++i) {
            Nodes.Node node = this.mNodes.get(this.mContext.mNode.mSub[i]);
            if (!localName.equals(node.mName) || !namespace.equals(node.mNamespace)) continue;
            Context newCtxt = new Context();
            newCtxt.mDelimLevel = node.mLevel;
            if (newCtxt.mDelimLevel == null) {
                if (this.mContext.mNode.isDelim() || this.mContext.mNode.isArray()) {
                    newCtxt.mDelimLevel = this.mContext.mDelimLevel.mNext;
                    if (newCtxt.mDelimLevel.mPlain >= 0) {
                        newCtxt.mPlain = this.mOtdel.get(newCtxt.mDelimLevel.mPlain);
                    }
                    if (newCtxt.mDelimLevel.mArray >= 0) {
                        newCtxt.mArray = this.mOtdel.get(newCtxt.mDelimLevel.mArray);
                    }
                } else {
                    newCtxt.mDelimLevel = this.mContext.mDelimLevel;
                    newCtxt.mPlain = this.mContext.mPlain;
                    newCtxt.mArray = this.mContext.mArray;
                }
            } else {
                if (newCtxt.mDelimLevel.mPlain >= 0) {
                    newCtxt.mPlain = this.mOtdel.get(newCtxt.mDelimLevel.mPlain);
                }
                if (newCtxt.mDelimLevel.mArray >= 0) {
                    newCtxt.mArray = this.mOtdel.get(newCtxt.mDelimLevel.mArray);
                }
            }
            this.mContext.mHasContent = true;
            newCtxt.mNode = node;
            newCtxt.mParentNode = this.mContext.mNode;
            newCtxt.mNodeIndex = this.mContext.mNode.mSub[i];
            newCtxt.mChildIndex = i;
            newCtxt.mRepeatIndex = 0;
            newCtxt.mOpen = true;
            newCtxt.mHasContent = false;
            this.mContextStack.push(this.mContext);
            this.mContext = newCtxt;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            System.out.println("[ start ]");
            File encoderBase = new File(System.getProperty("ENCODER_SHAREDLIBRARY"));
            File xsdFile = new File(encoderBase, "custom/xsdextension/ud1sample.xsd");
            QName rootElementName = new QName("http://xml.netbeans.org/schema/ud1sample", "root");
            Nodes nodes = NodesFactory.loadFromXSD(xsdFile, rootElementName);
            nodes.verify();
            BudOutput out = new BudOutput(nodes, nodes.mDelim);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamSource streamSource = new StreamSource(new File(encoderBase, "custom/xsdextension/ud1sampledecoded.xml"));
            SAXResult saxResult = new SAXResult(out);
            transformer.transform(streamSource, saxResult);
            byte[] data = out.content();
            System.out.println("Buffer is: " + Misc.printable((byte[])data));
            System.out.println("Should be: \"a,b|0123456789abcde0123456789\"");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static class Context {
        public int mNodeIndex;
        public int mChildIndex;
        public int mRepeatIndex;
        public Nodes.Node mNode;
        public Nodes.Node mParentNode;
        public OtdDelim.DelimLevel mDelimLevel;
        public Delim mPlain;
        public Delim mArray;
        public boolean mHasContent;
        public boolean mOpen;

        private Context() {
        }
    }
}

