/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.engine.DiskDatabase;
import org.axiondb.engine.MemoryDatabase;
import org.axiondb.jdbc.AxionConnection;
import org.axiondb.tools.BatchSqlCommandRunner;

public class Databases {
    public static final Databases INSTANCE = new Databases();
    private static HashMap _map = new HashMap();
    private static final String RUN_ON_STARTUP_PREFIX = "axiondb.database.";
    private static final String RUN_ON_STARTUP_SUFFIX = ".runonstartup";
    private static Logger _log = Logger.getLogger(Databases.class.getName());

    private Databases() {
    }

    public static synchronized Database getOrCreateDatabase(String name, File dir) throws AxionException {
        Database db = (Database)_map.get(name = name.toUpperCase());
        if (null == db) {
            db = null == dir ? new MemoryDatabase(name) : new DiskDatabase(name, dir);
            try {
                Databases.runOnStartup(db);
            }
            catch (Exception e) {
                _log.log(Level.FINE, "Exception while executing startup script for \"" + name + "\".", e);
                throw new AxionException(e);
            }
            _map.put(name, db);
        }
        return db;
    }

    public static synchronized void forgetDatabase(String name) {
        name = name.toUpperCase();
        _map.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnStartup(Database db) throws SQLException, IOException {
        String startupScriptName = null;
        try {
            startupScriptName = System.getProperty(RUN_ON_STARTUP_PREFIX + db.getName().toLowerCase() + RUN_ON_STARTUP_SUFFIX);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (null != startupScriptName) {
            File startupScriptFile;
            InputStream scriptStream = INSTANCE.getClass().getClassLoader().getResourceAsStream(startupScriptName);
            if (null == scriptStream && (startupScriptFile = new File(startupScriptName)).exists()) {
                scriptStream = new FileInputStream(startupScriptFile);
            }
            if (null != scriptStream) {
                AxionConnection conn = null;
                BatchSqlCommandRunner runner = null;
                try {
                    conn = new AxionConnection(db);
                    conn.setAutoCommit(false);
                    runner = new BatchSqlCommandRunner(conn);
                    runner.runCommands(scriptStream);
                    conn.commit();
                }
                finally {
                    try {
                        runner.close();
                    }
                    catch (Exception e) {}
                    try {
                        conn.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

