/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.Database;
import org.axiondb.ExternalTable;
import org.axiondb.ExternalTableLoader;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.engine.tables.DelimitedFlatfileTableLoader;
import org.axiondb.engine.tables.ExternalAxionDBTableLoader;
import org.axiondb.engine.tables.ExternalDatabaseTableLoader;
import org.axiondb.engine.tables.FixedWidthFlatfileTableLoader;
import org.axiondb.engine.tables.RSSTableLoader;
import org.axiondb.engine.tables.SpreadsheetTableLoader;
import org.axiondb.engine.tables.TaggedEBCDICTableLoader;
import org.axiondb.engine.tables.WebRowSetTableLoader;
import org.axiondb.engine.tables.WebTableLoader;
import org.axiondb.engine.tables.XMLTableLoader;

public class ExternalTableFactory
implements TableFactory {
    public static final String TYPE_DELIMITED = "DELIMITED";
    public static final String TYPE_FIXEDWIDTH = "FIXEDWIDTH";
    public static final String TYPE_WEBROWSET = "WEBROWSET";
    public static final String TYPE_XML = "XML";
    public static final String TYPE_WEB = "WEB";
    public static final String TYPE_SPREADSHEET = "SPREADSHEET";
    public static final String TYPE_RSS = "RSS";
    public static final String TYPE_TAGGEDEBCDIC = "TAGGEDEBCDIC";
    public static final String TYPE_REMOTE = "REMOTE";
    public static final String TYPE_REMOTE_AXION = "REMOTE_AXION";
    public static final HashMap EXTERNAL_LOADERS = new HashMap(4);

    public Table createTable(Database database, String name) throws AxionException {
        throw new AxionException("Unsupported method - use overloaded method to supply external properties and column metadata.");
    }

    public ExternalTable createTable(Database database, String name, Properties props, List columns) throws AxionException {
        ExternalTableLoader loader;
        this.assertValidProperty(props);
        String type = props.getProperty("LOADTYPE");
        String vendor = props.getProperty("VENDOR");
        if (vendor != null && vendor.trim().length() != 0) {
            type = type + "_" + vendor;
        }
        if ((loader = (ExternalTableLoader)EXTERNAL_LOADERS.get(type.toUpperCase())) != null) {
            ExternalTable table = loader.createExternalTable(database, name);
            if (columns == null || columns.isEmpty()) {
                throw new AxionException("Must supply List of Column instances to populate column metadata");
            }
            Iterator iter = columns.iterator();
            while (iter.hasNext()) {
                table.addColumn((Column)iter.next());
            }
            table.loadExternalTable(props);
            return table;
        }
        throw new AxionException("Unknown external table type: " + type);
    }

    public void assertValidProperty(Properties props) throws AxionException {
        if (props == null || props.isEmpty() || props.get("LOADTYPE") == null) {
            throw new AxionException("LOADTYPE property required in organization clause.");
        }
    }

    static {
        EXTERNAL_LOADERS.put(TYPE_DELIMITED, new DelimitedFlatfileTableLoader());
        EXTERNAL_LOADERS.put(TYPE_FIXEDWIDTH, new FixedWidthFlatfileTableLoader());
        EXTERNAL_LOADERS.put(TYPE_WEBROWSET, new WebRowSetTableLoader());
        EXTERNAL_LOADERS.put(TYPE_XML, new XMLTableLoader());
        EXTERNAL_LOADERS.put(TYPE_WEB, new WebTableLoader());
        EXTERNAL_LOADERS.put(TYPE_RSS, new RSSTableLoader());
        EXTERNAL_LOADERS.put(TYPE_SPREADSHEET, new SpreadsheetTableLoader());
        EXTERNAL_LOADERS.put(TYPE_TAGGEDEBCDIC, new TaggedEBCDICTableLoader());
        EXTERNAL_LOADERS.put(TYPE_REMOTE, new ExternalDatabaseTableLoader());
        EXTERNAL_LOADERS.put(TYPE_REMOTE_AXION, new ExternalAxionDBTableLoader());
    }
}

