/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseRegExpFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BooleanType;
import org.axiondb.types.StringType;

public class MatchesFunction
extends BaseRegExpFunction
implements ScalarFunction,
FunctionFactory {
    protected static final DataType ARG_TYPE = new StringType();
    protected static final DataType RETURN_TYPE = new BooleanType();

    public MatchesFunction() {
        super("MATCHES");
    }

    public ConcreteFunction makeNewInstance() {
        return new MatchesFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        String compare = this.getStringFromArg(this.getArgument(0), row);
        String pattern = this.getStringFromArg(this.getArgument(1), row);
        if (null == pattern || null == compare) {
            return null;
        }
        try {
            Pattern regex = this.compile(pattern);
            return regex.matcher(compare).find() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (PatternSyntaxException e) {
            throw new AxionException(e, 2220102);
        }
    }

    private String getStringFromArg(Selectable sel, RowDecorator row) throws AxionException {
        return (String)ARG_TYPE.convert(sel.evaluate(row));
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }
}

