/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.IntegerType;
import org.axiondb.types.StringType;

public class SubstringFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();
    private static final DataType INT_TYPE = new IntegerType();

    public SubstringFunction() {
        super("SUBSTRING");
    }

    public ConcreteFunction makeNewInstance() {
        return new SubstringFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        int m = 0;
        int n = 0;
        Object sel = this.getArgument(0).evaluate(row);
        String str = (String)RETURN_TYPE.convert(sel);
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        Selectable sel1 = this.getArgument(1);
        Object val1 = sel1.evaluate(row);
        Integer int1 = (Integer)INT_TYPE.convert(val1);
        m = int1;
        if (m < 0) {
            m = strLen + m;
        } else if (m != 0) {
            --m;
        }
        if (m > strLen) {
            return null;
        }
        if (this.getArgumentCount() == 3) {
            Selectable sel2 = this.getArgument(2);
            Object val2 = sel2.evaluate(row);
            Integer int2 = (Integer)INT_TYPE.convert(val2);
            n = int2;
            if (n < 1) {
                return null;
            }
            if (n > strLen - m) {
                n = strLen - m;
            }
        }
        if (this.getArgumentCount() == 3) {
            return str.substring(m, n + m);
        }
        return str.substring(m);
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 2;
    }
}

