/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecoratorIterator;
import org.axiondb.Selectable;
import org.axiondb.functions.AggregateFunction;
import org.axiondb.functions.BaseAggregateFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.types.BigDecimalType;

public class SumFunction
extends BaseAggregateFunction
implements AggregateFunction,
FunctionFactory {
    private DataType _targetType = null;
    private static final DataType BIG_DECIMAL_TYPE = new BigDecimalType();

    public SumFunction() {
        super("SUM");
    }

    public ConcreteFunction makeNewInstance() {
        return new SumFunction();
    }

    public final DataType getDataType() {
        return this._targetType == null ? BIG_DECIMAL_TYPE : this._targetType;
    }

    public final Object evaluate(RowDecoratorIterator rows) throws AxionException {
        Selectable sel = this.getArgument(0);
        this._targetType = sel.getDataType();
        this.setDistinct();
        double rowCount = 0.0;
        BigDecimal sum = null;
        while (rows.hasNext()) {
            Object val = this._targetType.convert(sel.evaluate(rows.next()));
            if (null == val || !this.acceptable(val)) continue;
            rowCount += 1.0;
            sum = this.evaluate(sum, this._targetType.toBigDecimal(val));
        }
        return null != sum ? sum : null;
    }

    protected BigDecimal evaluate(BigDecimal src, BigDecimal val) {
        return null == src ? val : src.add(val);
    }
}

