/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.axiondb.io.AxionInputStream;

public class BufferedDataInputStream
extends DataInputStream {
    public BufferedDataInputStream(AxionInputStream in) throws IOException {
        this(in, 4096);
    }

    public BufferedDataInputStream(AxionInputStream in, int bufferSize) throws IOException {
        super(new Buffer(new PositionCache(in), bufferSize));
    }

    public long getPos() throws IOException {
        return ((Buffer)this.in).getPos();
    }

    public void seek(long desired) throws IOException {
        ((Buffer)this.in).seek(desired);
    }

    private static class PositionCache
    extends FilterInputStream {
        long position;

        public PositionCache(AxionInputStream in) throws IOException {
            super(in);
            this.position = in.getPos();
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            this.position += (long)result;
            return result;
        }

        public void seek(long desired) throws IOException {
            ((AxionInputStream)this.in).seek(desired);
            this.position = desired;
        }
    }

    private static class Buffer
    extends BufferedInputStream {
        public Buffer(PositionCache in, int bufferSize) throws IOException {
            super(in, bufferSize);
        }

        public long getPos() throws IOException {
            return ((PositionCache)this.in).getPos() - (long)(this.count - this.pos);
        }

        public int read() throws IOException {
            if (this.pos >= this.count) {
                return super.read();
            }
            return this.buf[this.pos++] & 0xFF;
        }

        public synchronized void reset() throws IOException {
            this.count = 0;
            this.pos = 0;
        }

        public void seek(long desired) throws IOException {
            long current = this.getPos();
            long start = current - (long)this.pos;
            if (desired >= start && desired < start + (long)this.count) {
                this.pos = (int)((long)this.pos + (desired - current));
            } else {
                this.count = 0;
                this.pos = 0;
                ((PositionCache)this.in).seek(desired);
            }
        }
    }
}

