/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.axiondb.Database;
import org.axiondb.jdbc.AxionConnection;
import org.axiondb.jdbc.AxionResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionDatabaseMetaData
implements DatabaseMetaData {
    private AxionConnection _connection = null;
    private Database _db = null;
    private static final String AXION_VERSION = "1.0M3-dev";
    private static final int DB_MAJOR_VERSION = 0;
    private static final int DB_MINOR_VERSION = 3;

    public AxionDatabaseMetaData(AxionConnection conn, Database db) {
        this._connection = conn;
        this._db = db;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "AxionDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return AXION_VERSION;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Axion JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return AXION_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 3;
    }

    @Override
    public String getUserName() throws SQLException {
        return null;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._db.isReadOnly();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connection;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    @Override
    public String getURL() throws SQLException {
        return this._connection.getURL();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 8: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Statement stmt = this._connection.createStatement();
        String where = "";
        StringBuffer buf = new StringBuffer();
        if (null != catalog) {
            buf.append("TABLE_CAT = '").append(catalog.toUpperCase()).append("'");
        }
        if (null != schemaPattern && !"%".equals(schemaPattern)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("TABLE_SCHEM LIKE '").append(schemaPattern.toUpperCase()).append("'");
        }
        if (null != tableNamePattern && !"%".equals(tableNamePattern)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("TABLE_NAME LIKE '").append(tableNamePattern.toUpperCase()).append("'");
        }
        if (null != columnNamePattern && !"%".equals(columnNamePattern)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("COLUMN_NAME LIKE '").append(columnNamePattern.toUpperCase()).append("'");
        }
        if (buf.length() > 0) {
            where = "WHERE " + buf.toString();
        }
        ResultSet rset = stmt.executeQuery("select TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE, REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, SCOPE_CATALOG, SCOPE_SCHEMA, SCOPE_TABLE, SOURCE_DATA_TYPE from AXION_COLUMNS " + where + " order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION");
        return rset;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Statement stmt = this._connection.createStatement();
        String where = "";
        StringBuffer buf = new StringBuffer();
        if (null != catalog) {
            buf.append("TABLE_CAT = '").append(catalog.toUpperCase()).append("'");
        }
        if (null != schemaPattern && !"%".equals(schemaPattern)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("TABLE_SCHEM LIKE '").append(schemaPattern.toUpperCase()).append("'");
        }
        if (null != tableNamePattern && !"%".equals(tableNamePattern)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("TABLE_NAME LIKE '").append(tableNamePattern.toUpperCase()).append("'");
        }
        if (null != types) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("(");
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    buf.append(" OR ");
                }
                buf.append(this.getTableTypePredicate(types[i]));
            }
            buf.append(")");
        }
        if (buf.length() != 0) {
            where = "WHERE " + buf.toString();
        }
        ResultSet rset = stmt.executeQuery("select TABLE_CAT, TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, REMARKS from AXION_TABLES " + where + " order by TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        return rset;
    }

    private String getTableTypePredicate(String jdbcTableType) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("TABLE_TYPE ");
        if ("TABLE".equals(jdbcTableType)) {
            buf.insert(0, "(");
            buf.append("LIKE '%TABLE' AND TABLE_TYPE <> 'SYSTEM TABLE'");
            buf.append(")");
        } else {
            buf.append("= '").append(jdbcTableType).append("'");
        }
        return buf.toString();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select TABLE_SCHEM from AXION_SCHEMATA ORDER BY TABLE_SCHEM");
        return rset;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select TABLE_CAT from AXION_CATALOGS ORDER BY TABLE_CAT");
        return rset;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select TABLE_TYPE from AXION_TABLE_TYPES order by TABLE_TYPE");
        return rset;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE, FIXED_PREC_SCALE, AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, SQL_DATA_TYPE, SQL_DATETIME_SUB, NUM_PREC_RADIX from AXION_TYPES order by DATA_TYPE");
        return rset;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (this.supportsResultSetType(type)) {
            switch (concurrency) {
                case 1007: 
                case 1008: {
                    return true;
                }
            }
            throw new SQLException("Unknown ResultSet concurrency value: " + concurrency);
        }
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1005: {
                return true;
            }
            case 1004: {
                return false;
            }
        }
        throw new SQLException("Unknown ResultSet type: " + type);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select 1 where 1 != 1");
        return rset;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Statement stmt = this._connection.createStatement();
        String where = "";
        StringBuffer buf = new StringBuffer();
        if (null != catalog) {
            buf.append("TABLE_CAT = '").append(catalog).append("'");
        }
        if (null != schema && !"%".equals(schema)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("TABLE_SCHEM LIKE '").append(schema).append("'");
        }
        if (null != table && !"%".equals(table)) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("TABLE_NAME LIKE '").append(table).append("'");
        }
        if (unique) {
            if (buf.length() != 0) {
                buf.append(" AND ");
            }
            buf.append("NON_UNIQUE = false");
        }
        if (buf.length() != 0) {
            where = "WHERE " + buf.toString();
        }
        ResultSet rset = stmt.executeQuery("select TABLE_CAT, TABLE_SCHEM, TABLE_NAME, NON_UNIQUE, INDEX_QUALIFIER, INDEX_NAME, TYPE, ORDINAL_POSITION, COLUMN_NAME, ASC_OR_DESC, CARDINALITY, PAGES, FILTER_CONDITION from AXION_INDEX_INFO " + where + " order by NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION");
        return rset;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw new SQLException("getNumericFunctions() is not supported");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw new SQLException("getSystemFunctions() is not supported");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new SQLException("getSQLKeywords() is not supported");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw new SQLException("getSearchStringEscape() is not supported");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw new SQLException("getStringFunctions() is not supported");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw new SQLException("getTimeDateFunctions() is not supported");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw new SQLException("getExtraNameCharacters() is not supported");
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        throw new SQLException("getSchemaTerm() is not supported");
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new SQLException("getProcedureTerm() is not supported");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        throw new SQLException("getCatalogTerm() is not supported");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLException("isCatalogAtStart() is not supported");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        throw new SQLException("getCatalogSeparator() is not supported");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select 1 where 1 != 1");
        return rset;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("getProcedureColumns() is not supported");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select 1 where 1 != 1");
        return rset;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select 1 where 1 != 1");
        return rset;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLException("getBestRowIdentifier() is not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("getVersionColumns() is not supported");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        Statement stmt = this._connection.createStatement();
        ResultSet rset = stmt.executeQuery("select 1 where 1 != 1");
        return rset;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("getExportedKeys() is not supported");
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLException("getCrossReference() is not supported");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.supportsResultSetType(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw new SQLException("Unknown ResultSet type: " + type);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw new SQLException("Unknown ResultSet type: " + type);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new SQLException("getUDTs() is not supported");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 3;
    }

    @Override
    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        return AxionResultSet.createEmptyResultSet(null);
    }

    @Override
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        return AxionResultSet.createEmptyResultSet(null);
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsResultSetHoldability(int code) throws SQLException {
        return 2 == code;
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new UnsupportedOperationException("getAttributes is currently not supported");
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new SQLException("getSQLStateType is currently not supported");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("locatorsUpdateCopy is currently not supported");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Unsupported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Unsupported.");
    }
}

