/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.parser.AxionDateTimeFormatParserConstants;
import org.axiondb.parser.AxionDateTimeFormatParserTokenManager;
import org.axiondb.parser.ParseException;
import org.axiondb.parser.SimpleCharStream;
import org.axiondb.parser.Token;
import org.axiondb.parser.TokenMgrError;

public class AxionDateTimeFormatParser
implements AxionDateTimeFormatParserConstants {
    private static Logger _log = Logger.getLogger(AxionDateTimeFormatParser.class.getName());
    public AxionDateTimeFormatParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    public AxionDateTimeFormatParser() {
        this(new StringReader(""));
        _log.log(Level.FINE, "Created new date/time format parser");
    }

    public String parseDateTimeFormatToJava(String dtPattern) throws AxionException {
        this.ReInit(new StringReader(dtPattern));
        try {
            return this.convertToJavaFormat();
        }
        catch (TokenMgrError e) {
            throw new AxionException(22007);
        }
        catch (ParseException ex) {
            throw new AxionException(22007);
        }
    }

    private void assertTokenImageNotInSet(String image, Set existingTokens) throws ParseException {
        if (existingTokens.contains(image.toLowerCase())) {
            throw new ParseException("Duplicate token " + image + " found in parsed string.");
        }
        existingTokens.add(image.toLowerCase());
    }

    public final String convertToJavaFormat() throws ParseException {
        StringBuffer buf = new StringBuffer(50);
        HashSet existingTokens = new HashSet();
        Token t = null;
        block42: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    t = this.jj_consume_token(2);
                    buf.append("EEE");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 3: {
                    t = this.jj_consume_token(3);
                    buf.append("EEEE");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 4: {
                    t = this.jj_consume_token(4);
                    buf.append("DDD");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 5: {
                    t = this.jj_consume_token(5);
                    buf.append("dd");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 6: {
                    t = this.jj_consume_token(6);
                    buf.append("MM");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 8: {
                    t = this.jj_consume_token(8);
                    buf.append("MMMM");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 7: {
                    t = this.jj_consume_token(7);
                    buf.append("MMM");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 9: {
                    t = this.jj_consume_token(9);
                    buf.append("yyyy");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 10: {
                    t = this.jj_consume_token(10);
                    buf.append("yy");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    this.assertTokenImageNotInSet("yyyy", existingTokens);
                    break;
                }
                case 11: {
                    t = this.jj_consume_token(11);
                    buf.append("G");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 12: 
                case 14: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            t = this.jj_consume_token(12);
                            break;
                        }
                        case 14: {
                            t = this.jj_consume_token(14);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    buf.append("hh");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 15: {
                    t = this.jj_consume_token(15);
                    buf.append("HH");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    buf.append("H");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 16: {
                    t = this.jj_consume_token(16);
                    buf.append("mm");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 17: {
                    t = this.jj_consume_token(17);
                    buf.append("ss");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 18: {
                    t = this.jj_consume_token(18);
                    buf.append("w");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 20: {
                    t = this.jj_consume_token(20);
                    buf.append("SSS");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 21: {
                    t = this.jj_consume_token(21);
                    buf.append("aa");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                case 1: 
                case 19: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 31: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 22: {
                            t = this.jj_consume_token(22);
                            break;
                        }
                        case 23: {
                            t = this.jj_consume_token(23);
                            break;
                        }
                        case 24: {
                            t = this.jj_consume_token(24);
                            break;
                        }
                        case 26: {
                            t = this.jj_consume_token(26);
                            break;
                        }
                        case 27: {
                            t = this.jj_consume_token(27);
                            break;
                        }
                        case 28: {
                            t = this.jj_consume_token(28);
                            break;
                        }
                        case 31: {
                            t = this.jj_consume_token(31);
                            break;
                        }
                        case 29: {
                            t = this.jj_consume_token(29);
                            break;
                        }
                        case 25: {
                            t = this.jj_consume_token(25);
                            break;
                        }
                        case 19: {
                            t = this.jj_consume_token(19);
                            break;
                        }
                        case 1: {
                            t = this.jj_consume_token(1);
                            break;
                        }
                        default: {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    buf.append(t.image);
                    break;
                }
                case 30: {
                    t = this.jj_consume_token(30);
                    buf.append("'T'");
                    this.assertTokenImageNotInSet(t.image, existingTokens);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    continue block42;
                }
            }
            break;
        }
        return buf.toString();
    }

    public AxionDateTimeFormatParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new AxionDateTimeFormatParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public AxionDateTimeFormatParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new AxionDateTimeFormatParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public AxionDateTimeFormatParser(AxionDateTimeFormatParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(AxionDateTimeFormatParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

