/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;

public class BooleanType
extends BaseDataType {
    private static final BooleanComparator COMPARATOR_INSTANCE = new BooleanComparator();
    private static final long serialVersionUID = 8587725427253945440L;

    public int getJdbcType() {
        return 16;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Boolean";
    }

    public int getPrecision() {
        return 1;
    }

    public int getColumnDisplaySize() {
        return 5;
    }

    public Comparator getComparator() {
        return COMPARATOR_INSTANCE;
    }

    public String toString() {
        return "boolean";
    }

    public boolean toBoolean(Object value) throws AxionException {
        try {
            return (Boolean)this.convert(value);
        }
        catch (ClassCastException e) {
            throw new AxionException("Can't convert " + value + " to boolean.", e);
        }
        catch (NullPointerException e) {
            throw new AxionException("Can't convert null to boolean.", e);
        }
        catch (IllegalArgumentException e) {
            throw new AxionException("Can't convert " + value + " to boolean.", e);
        }
    }

    public boolean accepts(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        return value instanceof String;
    }

    public Object convert(Object value) throws IllegalArgumentException {
        if (null == value) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        throw new IllegalArgumentException("Can't convert " + value.getClass().getName() + " " + value + " into a Boolean.");
    }

    public Object read(DataInput in) throws IOException {
        byte value = in.readByte();
        switch (value) {
            case -1: {
                return null;
            }
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new IOException("Expected -1, 0, or 1, found " + value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeByte(-1);
        } else {
            boolean val = (Boolean)this.convert(value);
            if (val) {
                out.writeByte(1);
            } else {
                out.writeByte(0);
            }
        }
    }

    public DataType makeNewInstance() {
        return new BooleanType();
    }

    static class BooleanComparator
    implements Comparator {
        BooleanComparator() {
        }

        public int compare(Object left, Object right) {
            if (null == left) {
                return null == right ? 0 : 1;
            }
            if (null == right) {
                return -1;
            }
            return this.compare((Boolean)left, (Boolean)right);
        }

        private final int compare(boolean left, boolean right) {
            return left ? (right ? 0 : 1) : (right ? -1 : 0);
        }
    }
}

